/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.dns;

import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.smartcontract.dns.DnsUtils;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.utils.Utils;

public class Dns {
    public static final String DNS_CATEGORY_NEXT_RESOLVER = "dns_next_resolver";
    public static final String DNS_CATEGORY_WALLET = "wallet";
    public static final String DNS_CATEGORY_SITE = "site";
    private Tonlib tonlib;

    public Address getRootDnsAddress() {
        Cell cell = this.tonlib.getConfigParam(this.tonlib.getLast().getLast(), 4L);
        byte[] byteArray = cell.getBits().toByteArray();
        if (byteArray.length != 32) {
            throw new Error("Invalid ConfigParam 4 length " + byteArray.length);
        }
        String hex = Utils.bytesToHex((byte[])byteArray);
        return Address.of((String)("-1:" + hex));
    }

    public Object resolve(String domain, String category, boolean oneStep) {
        Address rootDnsAddress = this.getRootDnsAddress();
        return DnsUtils.dnsResolve(this.tonlib, rootDnsAddress, domain, category, oneStep);
    }

    public Object resolve(String domain, String category) {
        return this.resolve(domain, category, false);
    }

    public Object getWalletAddress(String domain) {
        return this.resolve(domain, DNS_CATEGORY_WALLET);
    }

    public Object getSiteAddress(String domain) {
        return this.resolve(domain, DNS_CATEGORY_SITE);
    }

    Dns(Tonlib tonlib) {
        this.tonlib = tonlib;
    }

    public static DnsBuilder builder() {
        return new DnsBuilder();
    }

    public static class DnsBuilder {
        private Tonlib tonlib;

        DnsBuilder() {
        }

        public DnsBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public Dns build() {
            return new Dns(this.tonlib);
        }

        public String toString() {
            return "Dns.DnsBuilder(tonlib=" + String.valueOf(this.tonlib) + ")";
        }
    }
}

