/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.util.Arrays;
import org.ton.java.utils.Utils;

public class UnsignedByteReader {
    byte[] data;
    public int pos;

    public long getDataSize() {
        return this.data.length;
    }

    public UnsignedByteReader(int[] data) {
        this.data = Utils.unsignedBytesToSigned((int[])data);
    }

    public UnsignedByteReader(byte[] data) {
        this.data = Arrays.copyOfRange(data, 0, data.length);
    }

    public byte[] readBytes(long num) {
        this.pos = (int)((long)this.pos + num);
        byte[] ret = Arrays.copyOfRange(this.data, 0, (int)num);
        this.data = Arrays.copyOfRange(this.data, (int)num, this.data.length);
        return ret;
    }

    public byte[] preReadBytes(long num) {
        return Arrays.copyOfRange(this.data, 0, (int)num);
    }

    public byte[] readBytes() {
        this.pos += this.data.length;
        byte[] ret = Arrays.copyOfRange(this.data, 0, this.data.length);
        this.data = new byte[0];
        return ret;
    }

    public byte[] preReadBytes() {
        return Arrays.copyOfRange(this.data, 0, this.data.length);
    }

    public byte[] readBytesPos(long num) {
        byte[] ret = Arrays.copyOfRange(this.data, this.pos, (int)num);
        this.pos = (int)((long)this.pos + num);
        return ret;
    }

    public byte[] readBytesReversed(long num) {
        return Utils.reverseByteArray((byte[])this.readBytes(num));
    }

    public byte[] readSignedBytes(long num) {
        this.pos = (int)((long)this.pos + num);
        byte[] ret = Arrays.copyOfRange(this.data, 0, (int)num);
        this.data = Arrays.copyOfRange(this.data, (int)num, this.data.length);
        return ret;
    }

    public byte[] preReadSignedBytes(long num) {
        return Arrays.copyOfRange(this.data, 0, (int)num);
    }

    public byte[] readSignedBytesReversed(long num) {
        return Utils.reverseByteArray((byte[])this.readSignedBytes(num));
    }

    public byte[] preReadSignedBytesReversed(long num) {
        return Utils.reverseByteArray((byte[])this.preReadSignedBytes(num));
    }

    public short readShortLittleEndian() {
        return Utils.bytesToShort((byte[])this.readSignedBytesReversed(2L));
    }

    public short preReadShortLittleEndian() {
        return Utils.bytesToShort((byte[])this.preReadSignedBytesReversed(2L));
    }

    public int readIntLittleEndian() {
        return Utils.bytesToInt((byte[])this.readSignedBytesReversed(4L));
    }

    public int preReadIntLittleEndian() {
        return Utils.bytesToInt((byte[])this.preReadSignedBytesReversed(4L));
    }

    public long readLongLittleEndian() {
        return Utils.bytesToLong((byte[])this.readSignedBytesReversed(8L));
    }

    public long preReadLongLittleEndian() {
        return Utils.bytesToLong((byte[])this.preReadSignedBytesReversed(8L));
    }

    public int readByte() {
        ++this.pos;
        byte[] ret = Arrays.copyOfRange(this.data, 0, 1);
        this.data = Arrays.copyOfRange(this.data, 1, this.data.length);
        return ret[0];
    }

    public int preReadByte() {
        return Arrays.copyOfRange(this.data, 0, 1)[0];
    }

    public byte readSignedByte() {
        ++this.pos;
        byte[] ret = Arrays.copyOfRange(this.data, 0, 1);
        this.data = Arrays.copyOfRange(this.data, 1, this.data.length);
        return ret[0];
    }

    public byte preReadSignedByte() {
        return Arrays.copyOfRange(this.data, 0, 1)[0];
    }
}

