/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.CellType;
import org.ton.java.cell.Node;
import org.ton.java.cell.PatriciaTreeNode;
import org.ton.java.utils.Utils;

public class TonHashMapAug
implements Serializable {
    public HashMap<Object, Pair<Object, Object>> elements = new LinkedHashMap<Object, Pair<Object, Object>>();
    int keySize;
    int maxMembers;

    public TonHashMapAug(int keySize, int maxMembers) {
        this.keySize = keySize;
        this.maxMembers = maxMembers;
    }

    public TonHashMapAug(int keySize) {
        this.keySize = keySize;
        this.maxMembers = 10000;
    }

    public List<Node> deserializeEdge(CellSlice edge, int keySize, BitString key) {
        if (edge.type != CellType.ORDINARY) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        BitString l = this.deserializeLabel(edge, keySize - key.toBitString().length());
        key.writeBitString(l);
        if (key.toBitString().length() == keySize) {
            Cell valueAndExtra = CellBuilder.beginCell().storeSlice(edge).endCell();
            nodes.add(new Node(key, valueAndExtra));
            return nodes;
        }
        for (int i = 0; i < edge.refs.size(); ++i) {
            CellSlice forkEdge = CellSlice.beginParse(edge.refs.get(i));
            BitString forkKey = key.clone();
            forkKey.writeBit(Boolean.valueOf(i != 0));
            nodes.addAll(this.deserializeEdge(forkEdge, keySize, forkKey));
        }
        return nodes;
    }

    void deserialize(CellSlice c, Function<BitString, Object> keyParser, Function<CellSlice, Object> valueParser, Function<CellSlice, Object> extraParser) {
        List<Node> nodes = this.deserializeEdge(c, this.keySize, new BitString(this.keySize));
        for (Node node : nodes) {
            CellSlice valueAndExtra = CellSlice.beginParse(node.value);
            Object extra = extraParser.apply(valueAndExtra);
            Object value = valueParser.apply(valueAndExtra);
            this.elements.put(keyParser.apply(node.key), (Pair<Object, Object>)Pair.of((Object)value, (Object)extra));
        }
    }

    PatriciaTreeNode splitTree(List<Node> nodes) {
        PatriciaTreeNode leftNode;
        if (nodes.size() == 1) {
            return new PatriciaTreeNode("", 0, nodes.get(0), null, null);
        }
        ArrayList<Node> left = new ArrayList<Node>();
        ArrayList<Node> right = new ArrayList<Node>();
        for (Node node : nodes) {
            boolean lr = node.key.readBit();
            if (lr) {
                right.add(node);
                continue;
            }
            left.add(node);
        }
        PatriciaTreeNode patriciaTreeNode = left.size() > 1 ? this.splitTree(left) : (leftNode = left.isEmpty() ? null : new PatriciaTreeNode("", 0, (Node)left.get(0), null, null));
        PatriciaTreeNode rightNode = right.size() > 1 ? this.splitTree(right) : (right.isEmpty() ? null : new PatriciaTreeNode("", 0, (Node)right.get(0), null, null));
        return new PatriciaTreeNode("", this.keySize, null, leftNode, rightNode);
    }

    PatriciaTreeNode flatten(PatriciaTreeNode node, int m) {
        if (node == null) {
            return null;
        }
        if (node.maxPrefixLength == 0) {
            node.maxPrefixLength = m;
        }
        if (node.leafNode != null) {
            return node;
        }
        PatriciaTreeNode left = node.left;
        PatriciaTreeNode right = node.right;
        if (left == null) {
            return this.flatten(new PatriciaTreeNode(node.prefix + "1", m, null, right.left, right.right), m);
        }
        if (right == null) {
            return this.flatten(new PatriciaTreeNode(node.prefix + "0", m, null, left.left, left.right), m);
        }
        node.maxPrefixLength = m;
        node.left = this.flatten(left, m - node.prefix.length() - 1);
        node.right = this.flatten(right, m - node.prefix.length() - 1);
        return node;
    }

    void serialize_label(String label, int m, CellBuilder builder) {
        boolean isSame;
        int n = label.length();
        if (label.isEmpty()) {
            builder.storeBit(false);
            builder.storeBit(false);
            return;
        }
        int sizeOfM = BigInteger.valueOf(m).bitLength();
        if (n < sizeOfM) {
            builder.storeBit(false);
            for (int i = 0; i < n; ++i) {
                builder.storeBit(true);
            }
            builder.storeBit(false);
            char[] i = label.toCharArray();
            int n2 = i.length;
            for (int j = 0; j < n2; ++j) {
                Character c = Character.valueOf(i[j]);
                builder.storeBit(c.charValue() == '1');
            }
            return;
        }
        boolean bl = isSame = label.equals(Utils.repeat((String)"0", (int)label.length())) || label.equals(Utils.repeat((String)"10", (int)label.length()));
        if (isSame) {
            builder.storeBit(true);
            builder.storeBit(true);
            builder.storeBit(label.charAt(0) == '1');
            builder.storeUint(label.length(), sizeOfM);
        } else {
            builder.storeBit(true);
            builder.storeBit(false);
            builder.storeUint(label.length(), sizeOfM);
            char[] cArray = label.toCharArray();
            int n3 = cArray.length;
            for (int i = 0; i < n3; ++i) {
                Character c = Character.valueOf(cArray[i]);
                builder.storeBit(c.charValue() == '1');
            }
        }
    }

    void serialize_edge(PatriciaTreeNode node, CellBuilder builder, BiFunction<Object, Object, Object> forkExtra) {
        if (node == null) {
            return;
        }
        if (node.leafNode != null) {
            BitString bs = node.leafNode.key.readBits(node.leafNode.key.getUsedBits());
            node.prefix = bs.toBitString();
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            builder.storeCell(node.leafNode.value);
        } else {
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            CellBuilder leftCell = CellBuilder.beginCell();
            this.serialize_edge(node.left, leftCell, forkExtra);
            CellBuilder rightCell = CellBuilder.beginCell();
            this.serialize_edge(node.right, rightCell, forkExtra);
            builder.storeCell(((CellBuilder)forkExtra.apply(leftCell.endCell(), rightCell.endCell())).endCell());
            builder.storeRef(leftCell.endCell());
            builder.storeRef(rightCell.endCell());
        }
    }

    public Cell serialize(Function<Object, BitString> keyParser, Function<Object, Object> valueParser, Function<Object, Object> extraParser, BiFunction<Object, Object, Object> forkExtra) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry<Object, Pair<Object, Object>> entry : this.elements.entrySet()) {
            BitString key = keyParser.apply(entry.getKey());
            Cell value = (Cell)valueParser.apply(entry.getValue().getLeft());
            Cell extra = (Cell)extraParser.apply(entry.getValue().getRight());
            Cell both = CellBuilder.beginCell().storeSlice(CellSlice.beginParse(extra)).storeSlice(CellSlice.beginParse(value)).endCell();
            nodes.add(new Node(key, both));
        }
        if (nodes.isEmpty()) {
            throw new Error("TonHashMapAug does not support empty dict. Consider using TonHashMapAugE");
        }
        PatriciaTreeNode root = this.flatten(this.splitTree(nodes), this.keySize);
        CellBuilder b = CellBuilder.beginCell();
        this.serialize_edge(root, b, forkExtra);
        return b.endCell();
    }

    public BitString deserializeLabel(CellSlice edge, int m) {
        if (!edge.loadBit()) {
            return this.deserializeLabelShort(edge);
        }
        if (!edge.loadBit()) {
            return this.deserializeLabelLong(edge, m);
        }
        return this.deserializeLabelSame(edge, m);
    }

    private BitString deserializeLabelShort(CellSlice edge) {
        int length = edge.bits.getBitString().indexOf("0");
        edge.skipBits(length + 1);
        return edge.loadBits(length);
    }

    private BitString deserializeLabelLong(CellSlice edge, int m) {
        BigInteger length = edge.loadUint(BigInteger.valueOf(m).bitLength());
        return edge.loadBits(length.intValue());
    }

    private BitString deserializeLabelSame(CellSlice edge, int m) {
        boolean v = edge.loadBit();
        BigInteger length = edge.loadUint(BigInteger.valueOf(m).bitLength());
        BitString r = new BitString(length.intValue());
        for (int i = 0; i < length.intValue(); ++i) {
            r.writeBit(Boolean.valueOf(v));
        }
        return r;
    }

    private static double log2(int n) {
        return Math.log(n) / Math.log(2.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map.Entry<Object, Pair<Object, Object>> entry : this.elements.entrySet()) {
            String s = String.format("[%s,(%s,%s)],", entry.getKey(), entry.getValue().getLeft(), entry.getValue().getRight());
            sb.append(s);
        }
        if (!this.elements.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    public Object getKeyByIndex(long index) {
        long i = 0L;
        for (Map.Entry<Object, Pair<Object, Object>> entry : this.elements.entrySet()) {
            if (i != index) continue;
            return entry.getKey();
        }
        throw new Error("key not found at index " + index);
    }

    public Object getValueByIndex(long index) {
        long i = 0L;
        for (Map.Entry<Object, Pair<Object, Object>> entry : this.elements.entrySet()) {
            if (i++ != index) continue;
            return entry.getValue().getLeft();
        }
        throw new Error("value not found at index " + index);
    }

    public Object getEdgeByIndex(long index) {
        long i = 0L;
        for (Map.Entry<Object, Pair<Object, Object>> entry : this.elements.entrySet()) {
            if (i++ != index) continue;
            return entry.getValue().getRight();
        }
        throw new Error("edge not found at index " + index);
    }
}

