/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.CellType;
import org.ton.java.cell.Node;
import org.ton.java.cell.PatriciaTreeNode;

public class TonHashMap
implements Serializable {
    public HashMap<Object, Object> elements;
    int keySize;
    int maxMembers;
    private static final double LOG_2 = Math.log(2.0);

    public TonHashMap(int keySize, int maxMembers) {
        int initialCapacity = Math.max(16, (int)((double)maxMembers * 1.25));
        this.elements = new LinkedHashMap<Object, Object>(initialCapacity, 0.75f);
        this.keySize = keySize;
        this.maxMembers = maxMembers;
    }

    public TonHashMap(int keySize) {
        this.elements = new LinkedHashMap<Object, Object>(16, 0.75f);
        this.keySize = keySize;
        this.maxMembers = 10000;
    }

    public List<Node> deserializeEdge(CellSlice edge, int keySize, BitString key) {
        ArrayList<Node> nodes = new ArrayList<Node>(4);
        BitString l = this.deserializeLabel(edge, keySize - key.getUsedBits());
        key.writeBitString(l);
        if (key.getUsedBits() == keySize) {
            Cell value = CellBuilder.beginCell().storeSlice(edge).endCell();
            nodes.add(new Node(key, value));
            return nodes;
        }
        int refsSize = edge.refs.size();
        for (int j = 0; j < refsSize; ++j) {
            CellSlice forkEdge = CellSlice.beginParse(edge.refs.get(j));
            BitString forkKey = key.clone();
            forkKey.writeBit(Boolean.valueOf(j != 0));
            List<Node> childNodes = this.deserializeEdge(forkEdge, keySize, forkKey);
            nodes.addAll(childNodes);
        }
        return nodes;
    }

    void deserialize(CellSlice c, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        List<Node> nodes = this.deserializeEdge(c, this.keySize, new BitString(this.keySize));
        for (Node node : nodes) {
            this.elements.put(keyParser.apply(node.key), valueParser.apply(node.value));
        }
    }

    PatriciaTreeNode splitTree(List<Node> nodes) {
        PatriciaTreeNode leftNode;
        if (nodes.size() == 1) {
            return new PatriciaTreeNode("", 0, nodes.get(0), null, null);
        }
        ArrayList<Node> left = new ArrayList<Node>();
        ArrayList<Node> right = new ArrayList<Node>();
        for (Node node : nodes) {
            boolean lr = node.key.readBit();
            if (lr) {
                right.add(node);
                continue;
            }
            left.add(node);
        }
        PatriciaTreeNode patriciaTreeNode = left.size() > 1 ? this.splitTree(left) : (leftNode = left.isEmpty() ? null : new PatriciaTreeNode("", 0, (Node)left.get(0), null, null));
        PatriciaTreeNode rightNode = right.size() > 1 ? this.splitTree(right) : (right.isEmpty() ? null : new PatriciaTreeNode("", 0, (Node)right.get(0), null, null));
        return new PatriciaTreeNode("", this.keySize, null, leftNode, rightNode);
    }

    PatriciaTreeNode flatten(PatriciaTreeNode node, int m) {
        if (node == null) {
            return null;
        }
        if (node.maxPrefixLength == 0) {
            node.maxPrefixLength = m;
        }
        if (node.leafNode != null) {
            return node;
        }
        PatriciaTreeNode left = node.left;
        PatriciaTreeNode right = node.right;
        if (left == null) {
            return this.flatten(new PatriciaTreeNode(node.prefix + "1", m, null, right.left, right.right), m);
        }
        if (right == null) {
            return this.flatten(new PatriciaTreeNode(node.prefix + "0", m, null, left.left, left.right), m);
        }
        node.maxPrefixLength = m;
        node.left = this.flatten(left, m - node.prefix.length() - 1);
        node.right = this.flatten(right, m - node.prefix.length() - 1);
        return node;
    }

    private boolean isSame(String label) {
        if (label.isEmpty() || label.length() == 1) {
            return true;
        }
        for (int i = 1; i < label.length(); ++i) {
            if (label.charAt(i) == label.charAt(0)) continue;
            return false;
        }
        return true;
    }

    private int detectLabelType(String label, int keyLength) {
        int type = 0;
        int bestLength = 1 + label.length() + 1 + label.length();
        int labelLongLength = 2 + (int)Math.ceil(TonHashMap.log2(keyLength + 1)) + label.length();
        boolean isSame = this.isSame(label);
        int labelSameLength = 3 + (int)Math.ceil(TonHashMap.log2(keyLength + 1));
        if (labelLongLength < bestLength) {
            type = 1;
            bestLength = labelLongLength;
        }
        if (isSame && labelSameLength < bestLength) {
            type = 2;
        }
        return type;
    }

    void serialize_label(String label, int m, CellBuilder builder) {
        int t = this.detectLabelType(label, m);
        int sizeOfM = BigInteger.valueOf(m).bitLength();
        if (t == 0) {
            int n = label.length();
            builder.storeBit(false);
            for (int i = 0; i < n; ++i) {
                builder.storeBit(true);
            }
            builder.storeBit(false);
            char[] cArray = label.toCharArray();
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                Character c = Character.valueOf(cArray[i]);
                builder.storeBit(c.charValue() == '1');
            }
        } else if (t == 1) {
            builder.storeBit(true);
            builder.storeBit(false);
            builder.storeUint(label.length(), sizeOfM);
            char[] cArray = label.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                builder.storeBit(c.charValue() == '1');
            }
        } else if (t == 2) {
            builder.storeBit(true);
            builder.storeBit(true);
            builder.storeBit(label.charAt(0) == '1');
            builder.storeUint(label.length(), sizeOfM);
        } else {
            throw new IllegalStateException("Unknown label type: " + t);
        }
    }

    void serialize_edge(PatriciaTreeNode node, CellBuilder builder) {
        if (node == null) {
            return;
        }
        if (node.leafNode != null) {
            BitString bs = node.leafNode.key.readBits(node.leafNode.key.getUsedBits());
            node.prefix = bs.toBitString();
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            builder.storeCell(node.leafNode.value);
        } else {
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            CellBuilder leftCell = CellBuilder.beginCell();
            this.serialize_edge(node.left, leftCell);
            CellBuilder rightCell = CellBuilder.beginCell();
            this.serialize_edge(node.right, rightCell);
            builder.storeRef(leftCell.endCell());
            builder.storeRef(rightCell.endCell());
        }
    }

    public Cell serialize(Function<Object, BitString> keyParser, Function<Object, Cell> valueParser) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry<Object, Object> entry : this.elements.entrySet()) {
            BitString key = keyParser.apply(entry.getKey());
            Cell value = valueParser.apply(entry.getValue());
            nodes.add(new Node(key, value));
        }
        if (nodes.isEmpty()) {
            throw new Error("TonHashMap does not support empty dict. Consider using TonHashMapE");
        }
        PatriciaTreeNode root = this.flatten(this.splitTree(nodes), this.keySize);
        CellBuilder b = CellBuilder.beginCell();
        this.serialize_edge(root, b);
        return b.endCell();
    }

    public BitString deserializeLabel(CellSlice edge, int m) {
        if (!edge.loadBit()) {
            return this.deserializeLabelShort(edge);
        }
        if (!edge.loadBit()) {
            return this.deserializeLabelLong(edge, m);
        }
        return this.deserializeLabelSame(edge, m);
    }

    private BitString deserializeLabelShort(CellSlice edge) {
        int length = edge.bits.getBitString().indexOf("0");
        edge.skipBits(length + 1);
        return edge.loadBits(length);
    }

    private BitString deserializeLabelLong(CellSlice edge, int m) {
        BigInteger length = edge.loadUint((int)Math.ceil(TonHashMap.log2(m + 1)));
        return edge.loadBits(length.intValue());
    }

    private BitString deserializeLabelSame(CellSlice edge, int m) {
        boolean v = edge.loadBit();
        BigInteger length = edge.loadUint((int)Math.ceil(TonHashMap.log2(m + 1)));
        BitString r = new BitString(length.intValue());
        for (int i = 0; i < length.intValue(); ++i) {
            r.writeBit(Boolean.valueOf(v));
        }
        return r;
    }

    private static double log2(int n) {
        if ((n & n - 1) == 0) {
            return Integer.numberOfTrailingZeros(n);
        }
        return Math.log(n) / LOG_2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map.Entry<Object, Object> entry : this.elements.entrySet()) {
            String s = String.format("[%s,%s],", entry.getKey(), entry.getValue());
            sb.append(s);
        }
        if (!this.elements.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    public Object getKeyByIndex(long index) {
        if (index < 0L || index >= (long)this.elements.size()) {
            throw new Error("key not found at index " + index);
        }
        Object[] keys = this.elements.keySet().toArray();
        if (index < (long)keys.length) {
            return keys[(int)index];
        }
        throw new Error("key not found at index " + index);
    }

    public Object getValueByIndex(long index) {
        if (index < 0L || index >= (long)this.elements.size()) {
            throw new Error("value not found at index " + index);
        }
        Object[] values = this.elements.values().toArray();
        if (index < (long)values.length) {
            return values[(int)index];
        }
        throw new Error("value not found at index " + index);
    }

    public Cell buildMerkleProof(Object key, Function<Object, BitString> keySerializer, Function<Object, Cell> valueSerializer) {
        Cell dictCell = CellBuilder.beginCell().storeDictInLine(this.serialize(keySerializer, valueSerializer)).endCell();
        Cell cell = this.generateMerkleProof("", CellSlice.beginParse(dictCell), this.keySize, this.padString(keySerializer.apply(key).toBitString(), this.keySize, '0'));
        return this.convertToMerkleProof(cell);
    }

    private int readUnaryLength(CellSlice slice) {
        int res = 0;
        while (slice.loadBit()) {
            ++res;
        }
        return res;
    }

    private Cell generateMerkleProof(String prefix, CellSlice slice, int n, String key) {
        int prefixLength;
        Cell originalCell = CellBuilder.beginCell().storeSlice(slice).endCell();
        boolean lb0 = slice.loadBit();
        StringBuilder pp = new StringBuilder(prefix);
        if (!lb0) {
            prefixLength = this.readUnaryLength(slice);
            for (int i = 0; i < prefixLength; ++i) {
                pp.append(slice.loadBit() ? (char)'1' : '0');
            }
        } else {
            boolean lb1;
            boolean bl = lb1 = slice.loadBit();
            if (!lb1) {
                prefixLength = slice.loadUint((int)Math.ceil(Math.log(n + 1) / Math.log(2.0))).intValue();
                for (int i = 0; i < prefixLength; ++i) {
                    pp.append(slice.loadBit() ? (char)'1' : '0');
                }
            } else {
                char bit = slice.loadBit() ? (char)'1' : '0';
                prefixLength = slice.loadUint((int)Math.ceil(Math.log(n + 1) / Math.log(2.0))).intValue();
                for (int i = 0; i < prefixLength; ++i) {
                    pp.append(bit);
                }
            }
        }
        if (n - prefixLength == 0) {
            return originalCell;
        }
        CellSlice sl = CellSlice.beginParse(originalCell);
        Cell left = sl.loadRef();
        Cell right = sl.loadRef();
        if (left.getCellType() == CellType.ORDINARY) {
            Cell cell = left = (pp.toString() + "0").equals(key.substring(0, pp.length() + 1)) ? this.generateMerkleProof(pp.toString() + "0", CellSlice.beginParse(left), n - prefixLength - 1, key) : this.convertToPrunedBranch(left);
        }
        if (right.getCellType() == CellType.ORDINARY) {
            right = (pp.toString() + "1").equals(key.substring(0, pp.length() + 1)) ? this.generateMerkleProof(pp.toString() + "1", CellSlice.beginParse(right), n - prefixLength - 1, key) : this.convertToPrunedBranch(right);
        }
        return CellBuilder.beginCell().storeSlice(sl).storeRef(left).storeRef(right).endCell();
    }

    private Cell endExoticCell(CellBuilder builder, CellType type) {
        Cell c = builder.endCell();
        Cell exotic = new Cell(c.getBits(), c.getBitLength(), c.getRefs(), true, type);
        exotic.calculateHashes();
        return exotic;
    }

    private Cell convertToMerkleProof(Cell c) {
        return this.endExoticCell(CellBuilder.beginCell().storeUint(3, 8).storeBytes(c.getHash(0)).storeUint(c.getDepthLevels()[0], 16).storeRef(c), CellType.MERKLE_PROOF);
    }

    private Cell convertToPrunedBranch(Cell c) {
        return this.endExoticCell(CellBuilder.beginCell().storeUint(1, 8).storeUint(1, 8).storeBytes(c.getHash(0)).storeUint(c.getDepthLevels()[0], 16), CellType.PRUNED_BRANCH);
    }

    private String padString(String original, int requiredSize, char padChar) {
        if (original.length() >= requiredSize) {
            return original;
        }
        return StringUtils.repeat((char)padChar, (int)Math.max(0, requiredSize - original.length() + 1)) + original;
    }
}

