/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.io.Serializable;

public class LevelMask
implements Serializable {
    int mask;
    int level;
    int hashIndex;

    public LevelMask(int mask) {
        this.mask = mask;
        this.level = this.getLevel();
        this.hashIndex = this.getHashIndex();
    }

    public LevelMask clone() {
        return new LevelMask(this.mask);
    }

    public int getLevel() {
        return LevelMask.calculateMinimumBits(this.mask);
    }

    public LevelMask apply(int lvl) {
        return new LevelMask(this.mask & (1 << lvl) - 1);
    }

    public int getHashIndex() {
        return LevelMask.calculateOnesBits(this.mask);
    }

    public static int calculateMinimumBits(int number) {
        if (number == 0) {
            return 0;
        }
        return 32 - Integer.numberOfLeadingZeros(number);
    }

    public static int calculateOnesBits(int number) {
        return Integer.bitCount(number);
    }

    public boolean isSignificant(int level) {
        return level == 0 || (this.mask >> level - 1) % 2 != 0;
    }

    public String toString() {
        return "LevelMask(mask=" + this.getMask() + ", level=" + this.getLevel() + ", hashIndex=" + this.getHashIndex() + ")";
    }

    public int getMask() {
        return this.mask;
    }
}

