/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.constraint.ConstraintHandler;
import io.github.nambach.excelutil.core.BaseEditor;
import io.github.nambach.excelutil.core.ColumnMapper;
import io.github.nambach.excelutil.core.DataTemplate;
import io.github.nambach.excelutil.core.FlatData;
import io.github.nambach.excelutil.core.MergeItem;
import io.github.nambach.excelutil.core.Template;
import io.github.nambach.excelutil.core.WriterCell;
import io.github.nambach.excelutil.core.WriterComment;
import io.github.nambach.excelutil.style.CacheStyle;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.util.PixelUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

class BaseWriter
implements BaseEditor {
    private static final Map<Class<?>, BiConsumer<Cell, Object>> FIELD_WRITERS = new HashMap();
    private static final Style DATE = Style.builder().datePattern("MMM dd, yyyy").build();
    final CacheStyle cachedStyles;
    final ConstraintHandler constraintHandler;

    BaseWriter(Workbook workbook) {
        this.cachedStyles = new CacheStyle(workbook);
        this.constraintHandler = new ConstraintHandler(workbook);
    }

    public <T> void writeData(Sheet sheet, DataTemplate<T> template, Collection<T> data, int rowAt, int colAt) {
        if (template.hasDeepLevel()) {
            DataTemplate<FlatData> flatTemplate = template.getFlatTemplate();
            Collection<FlatData> flatData = template.flattenData(data);
            this.internalWriteData(sheet, flatTemplate, flatData, rowAt, colAt);
        } else {
            this.internalWriteData(sheet, template, data, rowAt, colAt);
        }
    }

    private <T> void internalWriteData(Sheet sheet, DataTemplate<T> template, Collection<T> data, int rowAt, int colAt) {
        if (data == null) {
            data = Collections.emptyList();
        }
        if (rowAt < 0) {
            rowAt = 0;
        }
        if (colAt < 0) {
            colAt = 0;
        }
        Style headerStyle = template.getHeaderStyle();
        Style dataStyle = template.getDataStyle();
        if (!template.isNoHeader()) {
            Row headerRow = this.getRowAt(sheet, rowAt++);
            CellStyle defaultHeaderStyle = this.cachedStyles.accumulate(headerStyle);
            int cellCount = colAt;
            for (ColumnMapper columnMapper : template) {
                Cell cell = this.getCellAt(headerRow, cellCount++);
                cell.setCellValue(columnMapper.getDisplayName());
                cell.setCellStyle(defaultHeaderStyle);
            }
        }
        HashMap<Integer, MergeItem> mergeTracker = new HashMap<Integer, MergeItem>();
        int objectCount = 0;
        for (T object : data) {
            ++objectCount;
            Row row = this.getRowAt(sheet, rowAt++);
            int i = colAt - 1;
            for (ColumnMapper columnMapper : template) {
                Cell cell = this.getCellAt(row, ++i);
                Object cellValue = columnMapper.retrieveValue(object);
                if (cellValue == null) {
                    cell.setCellValue("");
                } else {
                    BiConsumer<Cell, Object> handler = FIELD_WRITERS.get(cellValue.getClass());
                    if (handler != null) {
                        handler.accept(cell, cellValue);
                    } else {
                        cell.setCellValue(cellValue.toString());
                    }
                }
                Style dateStyle = this.isDateType(cellValue) ? DATE : null;
                Style conditionalStyle = columnMapper.applyConditionalStyle(object);
                Style columnStyle = columnMapper.getStyle();
                Style rowStyle = template.applyConditionalRowStyle(object);
                CellStyle cellStyle = this.cachedStyles.accumulate(dateStyle, dataStyle, rowStyle, columnStyle, conditionalStyle);
                cell.setCellStyle(cellStyle);
                Constraint constraint = columnMapper.getConstraint();
                this.constraintHandler.applyConstraint(constraint, cell);
                if (columnMapper.needMerged()) {
                    int rowNum = row.getRowNum();
                    Object currentValue = columnMapper.retrievePivotValueForMergeComparison(object, cellValue);
                    if (objectCount == 1) {
                        mergeTracker.putIfAbsent(i, new MergeItem(currentValue, rowNum, rowNum));
                    } else {
                        MergeItem tracker = (MergeItem)mergeTracker.get(i);
                        if (Objects.equals(currentValue, tracker.getLastValue())) {
                            tracker.increaseRange();
                            if (objectCount == data.size()) {
                                tracker.handleMerge(cell);
                            }
                        } else {
                            tracker.handleMerge(cell);
                            tracker.reset(currentValue, rowNum);
                        }
                    }
                }
                if (objectCount != data.size()) continue;
                Integer pxWidth = columnMapper.getPxWidth();
                if (pxWidth != null && pxWidth > 0) {
                    PixelUtil.setColumnWidth(sheet, cell.getColumnIndex(), pxWidth);
                    continue;
                }
                if (!template.isAutoSizeColumns() && !columnMapper.isAutoSize()) continue;
                sheet.autoSizeColumn(i, columnMapper.needMerged());
            }
        }
    }

    public void writeTemplate(Sheet sheet, Template template) {
        Map<Integer, List<WriterCell>> lines = ListUtil.groupBy(template, WriterCell::getRowAt);
        lines.forEach((line, cells) -> {
            Row row = this.getRowAt(sheet, (int)line);
            for (WriterCell writerCell : cells) {
                Cell cell = this.getCellAt(row, writerCell.getColAt());
                this.writeCellInfo(writerCell, cell);
            }
        });
    }

    public void writeCellInfo(WriterCell writerCell, Cell cell) {
        CellStyle cellStyle;
        boolean isDate = false;
        if (writerCell.getContent() != null) {
            cell.setCellValue(writerCell.getContent());
        } else if (writerCell.getValue() != null) {
            cell.setCellValue(writerCell.getValue().doubleValue());
        } else if (writerCell.getDate() != null) {
            cell.setCellValue(writerCell.getDate());
            isDate = true;
        }
        if (writerCell.getComment() != null) {
            this.writeComment(writerCell.getComment(), cell);
        }
        if ((cellStyle = this.cachedStyles.accumulate(writerCell.getStyle(), isDate ? DATE : null)) != null) {
            cell.setCellStyle(cellStyle);
        }
        if (writerCell.getConstraint() != null) {
            this.constraintHandler.applyConstraint(writerCell.getConstraint(), cell);
        }
        int rowSpan = writerCell.getRowSpan();
        int colSpan = writerCell.getColSpan();
        if (colSpan > 1 || rowSpan > 1) {
            int rowAt = writerCell.getRowAt();
            int colAt = writerCell.getColAt();
            cell.getSheet().addMergedRegion(new CellRangeAddress(rowAt, rowAt + rowSpan - 1, colAt, colAt + colSpan - 1));
        }
    }

    public void writeComment(WriterComment writerComment, Cell cell) {
        Sheet sheet = cell.getSheet();
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + writerComment.getColSpan());
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + writerComment.getRowSpan());
        Comment comment = drawing.createCellComment(anchor);
        RichTextString rts = factory.createRichTextString(writerComment.getContent());
        comment.setString(rts);
        if (writerComment.getAuthor() != null) {
            comment.setAuthor(writerComment.getAuthor());
        }
        cell.setCellComment(comment);
    }

    static {
        Map<Class<?>, BiConsumer<Cell, Object>> o = FIELD_WRITERS;
        o.put(String.class, (cell, val) -> cell.setCellValue((String)val));
        o.put(Long.class, (cell, val) -> cell.setCellValue((double)((Long)val).longValue()));
        o.put(Integer.class, (cell, val) -> cell.setCellValue((double)((Integer)val).intValue()));
        o.put(Double.class, (cell, val) -> cell.setCellValue(((Double)val).doubleValue()));
        o.put(Float.class, (cell, val) -> cell.setCellValue((double)((Float)val).floatValue()));
        o.put(Boolean.class, (cell, val) -> cell.setCellValue(((Boolean)val).booleanValue()));
        o.put(Date.class, (cell, val) -> cell.setCellValue((Date)val));
        o.put(LocalDateTime.class, (cell, val) -> cell.setCellValue((LocalDateTime)val));
        o.put(LocalDate.class, (cell, val) -> cell.setCellValue((LocalDate)val));
        o.put(Calendar.class, (cell, val) -> cell.setCellValue((Calendar)val));
        o.put(RichTextString.class, (cell, val) -> cell.setCellValue((RichTextString)val));
    }
}

