/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.DynamoDBPagingAndSortingRepository;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.socialsignin.spring.data.dynamodb.repository.support.SimpleDynamoDBCrudRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleDynamoDBPagingAndSortingRepository<T, ID>
extends SimpleDynamoDBCrudRepository<T, ID>
implements DynamoDBPagingAndSortingRepository<T, ID> {
    public SimpleDynamoDBPagingAndSortingRepository(DynamoDBEntityInformation<T, ID> entityInformation, DynamoDBOperations dynamoDBOperations, EnableScanPermissions enableScanPermissions) {
        super(entityInformation, dynamoDBOperations, enableScanPermissions);
    }

    public Iterable<T> findAll(Sort sort) {
        return (Iterable)this.throwUnsupportedSortOperationException();
    }

    public Page<T> findAll(Pageable pageable) {
        long processedCount;
        this.ensureNoSort(pageable);
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        long scanTo = pageable.getOffset() + 2L * (long)pageable.getPageSize();
        scanExpression.setLimit(Integer.valueOf((int)Math.min(scanTo, Integer.MAX_VALUE)));
        PaginatedScanList paginatedScanList = this.dynamoDBOperations.scan(this.domainType, scanExpression);
        Iterator iterator = paginatedScanList.iterator();
        if (pageable.getOffset() > 0L && (processedCount = this.scanThroughResults(iterator, pageable.getOffset())) < pageable.getOffset()) {
            return new PageImpl(new ArrayList());
        }
        List<T> results = this.readPageOfResults(iterator, pageable.getPageSize());
        this.assertScanEnabled(this.enableScanPermissions.isFindAllPaginatedScanEnabled(), "findAll(Pageable pageable)");
        this.assertScanCountEnabled(this.enableScanPermissions.isFindAllUnpaginatedScanCountEnabled(), "findAll(Pageable pageable)");
        int totalCount = this.dynamoDBOperations.count(this.domainType, scanExpression);
        return new PageImpl(results, pageable, (long)totalCount);
    }

    private long scanThroughResults(Iterator<T> paginatedScanListIterator, long resultsToScan) {
        long processed;
        for (processed = 0L; paginatedScanListIterator.hasNext() && processed < resultsToScan; ++processed) {
            paginatedScanListIterator.next();
        }
        return processed;
    }

    private List<T> readPageOfResults(Iterator<T> paginatedScanListIterator, int pageSize) {
        ArrayList<T> resultsPage = new ArrayList<T>();
        for (int processed = 0; paginatedScanListIterator.hasNext() && processed < pageSize; ++processed) {
            resultsPage.add(paginatedScanListIterator.next());
        }
        return resultsPage;
    }

    public void assertScanCountEnabled(boolean countScanEnabled, String methodName) {
        Assert.isTrue((boolean)countScanEnabled, (String)("Scanning for the total counts for unpaginated " + methodName + " queries is not enabled.  To enable, re-implement the " + methodName + "() method in your repository interface and annotate with @EnableScanCount, or enable total count scanning for all repository methods by annotating your repository interface with @EnableScanCount"));
    }
}

