/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.AbstractSingleEntityQuery;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.springframework.util.Assert;

public class ScanExpressionCountQuery<T>
extends AbstractSingleEntityQuery<Long>
implements Query<Long> {
    private DynamoDBScanExpression scanExpression;
    private Class<T> domainClass;
    private boolean pageQuery;

    public ScanExpressionCountQuery(DynamoDBOperations dynamoDBOperations, Class<T> clazz, DynamoDBScanExpression scanExpression, boolean pageQuery) {
        super(dynamoDBOperations, Long.class);
        this.scanExpression = scanExpression;
        this.domainClass = clazz;
        this.pageQuery = pageQuery;
    }

    @Override
    public Long getSingleResult() {
        this.assertScanCountEnabled(this.isScanCountEnabled());
        return this.dynamoDBOperations.count(this.domainClass, this.scanExpression);
    }

    public void assertScanCountEnabled(boolean scanCountEnabled) {
        if (this.pageQuery) {
            Assert.isTrue((boolean)scanCountEnabled, (String)"Scanning for the total counts for this query is not enabled.  To enable annotate your repository method with @EnableScanCount, or enable scanning for all repository methods by annotating your repository interface with @EnableScanCount.  This total count is required to serve this Page query - if total counts are not desired an alternative approach could be to replace the Page query with a Slice query ");
        } else {
            Assert.isTrue((boolean)scanCountEnabled, (String)"Scanning for counts for this query is not enabled.  To enable annotate your repository method with @EnableScanCount, or enable scanning for all repository methods by annotating your repository interface with @EnableScanCount");
        }
    }
}

