/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.marshaller;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.springframework.util.StringUtils;

public class Instant2IsoDynamoDBMarshaller
implements DynamoDBTypeConverter<String, Instant>,
DynamoDBMarshaller<Instant> {
    private static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private DateTimeFormatter getDateFormat() {
        return DateTimeFormatter.ofPattern(PATTERN).withZone(ZoneOffset.UTC);
    }

    public String convert(Instant object) {
        return this.marshall(object);
    }

    public String marshall(Instant getterReturnResult) {
        if (getterReturnResult == null) {
            return null;
        }
        return this.getDateFormat().format(getterReturnResult);
    }

    public Instant unconvert(String object) {
        return this.unmarshall((Class)Instant.class, object);
    }

    public Instant unmarshall(Class<Instant> clazz, String obj) {
        if (StringUtils.isEmpty((Object)obj)) {
            return null;
        }
        return Instant.from(this.getDateFormat().parse(obj));
    }
}

