/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer.utilities;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.ImageInfo;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class PNGInfo {
    Point2D _centerPoint = null;
    Rectangle2D _symbolBounds = null;
    BufferedImage _image = null;

    public PNGInfo(ImageInfo ii) {
        this._centerPoint = new Point2D.Double(ii.getSymbolCenterX(), ii.getSymbolCenterY());
        this._symbolBounds = ii.getSymbolBounds();
        this._image = ii.getImage();
    }

    public PNGInfo(ISinglePointInfo spi) {
        this._centerPoint = spi.getSymbolCenterPoint();
        this._symbolBounds = spi.getSymbolBounds();
        this._image = spi.getImage();
    }

    public PNGInfo(BufferedImage image, Point2D centerPoint, Rectangle2D symbolBounds) {
        this._image = image;
        this._symbolBounds = symbolBounds;
        this._centerPoint = centerPoint;
    }

    public Point2D getCenterPoint() {
        return this._centerPoint;
    }

    public Rectangle2D getSymbolBounds() {
        return this._symbolBounds;
    }

    public BufferedImage getImage() {
        return this._image;
    }

    public byte[] getImageAsByteArray() {
        byte[] byteArray = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedImage image = this._image;
            ImageIO.write((RenderedImage)image, "png", baos);
            baos.flush();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"PNGInfo", (String)"getImageAsByteArray", (Exception)exc);
        }
        return byteArray;
    }

    public Boolean saveImageToFile(String filePath) {
        try {
            File outFile = new File(filePath);
            return ImageIO.write((RenderedImage)this._image, "png", outFile);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"ImageInfo", (String)"SaveImageToFile", (Exception)exc);
            return false;
        }
    }

    public byte[] getImageAsByteArrayWithMetaInfo() {
        byte[] metaImage = null;
        try {
            BufferedImage image = this._image;
            Iterator<ImageWriter> itr = ImageIO.getImageWritersBySuffix("png");
            String metaDataFormatName = "";
            if (itr.hasNext()) {
                ImageWriter iw = itr.next();
                IIOMetadata meta = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
                metaDataFormatName = meta.getMetadataFormatNames()[0];
                StringBuilder XML = new StringBuilder("");
                XML.append("<" + metaDataFormatName + ">");
                XML.append("<tEXt>");
                XML.append("<tEXtEntry keyword=\"centerPoint\" value=\"x=" + String.valueOf(this._centerPoint.getX()) + ",y=" + String.valueOf(this._centerPoint.getY()) + "\"/>");
                XML.append("<tEXtEntry keyword=\"bounds\" value=\"x=" + String.valueOf(this._symbolBounds.getX()) + ",y=" + String.valueOf(this._symbolBounds.getY()) + ",width=" + String.valueOf(this._symbolBounds.getWidth()) + ",height=" + String.valueOf(this._symbolBounds.getHeight()) + "\"/>");
                XML.append("<tEXtEntry keyword=\"imageExtent\" value=\"width=" + String.valueOf(image.getWidth()) + ",height=" + String.valueOf(image.getHeight()) + "\"/>");
                XML.append("</tEXt>");
                XML.append("</" + metaDataFormatName + ">");
                DOMResult domresult = new DOMResult();
                TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(XML.toString())), domresult);
                Node document = domresult.getNode();
                meta.mergeTree(metaDataFormatName, document.getFirstChild());
                IIOImage iioImage = new IIOImage(image, null, null);
                iioImage.setMetadata(meta);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ImageOutputStream ios = ImageIO.createImageOutputStream(bytes);
                iw.setOutput(ios);
                iw.write(null, iioImage, null);
                ios.close();
                iw.dispose();
                iw = null;
                itr = null;
                iioImage = null;
                bytes.flush();
                metaImage = bytes.toByteArray();
                bytes.close();
                return metaImage;
            }
            ErrorLogger.LogMessage((String)"ImageInfo", (String)"getImageAsByteArrayWithMetaInfo", (String)"no PNG imageWriter available");
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"ImageInfo", (String)"getImageAsByteArrayWithMetaInfo", (Exception)exc);
            return null;
        }
    }

    public PNGInfo centerImage() {
        BufferedImage image = null;
        Point2D point = null;
        Point2D.Double newCenter = null;
        PNGInfo pi = null;
        BufferedImage bi = null;
        int x = 0;
        int y = 0;
        int height = 0;
        int width = 0;
        try {
            image = this._image;
            point = this._centerPoint;
            height = image.getHeight();
            width = image.getWidth();
            if (point.getY() > (double)height - point.getY()) {
                height = (int)(point.getY() * 2.0);
                y = 0;
            } else {
                height = (int)(((double)height - point.getY()) * 2.0);
                y = (int)((double)(height / 2) - point.getY());
            }
            if (point.getX() > (double)width - point.getX()) {
                width = (int)(point.getX() * 2.0);
                x = 0;
            } else {
                width = (int)(((double)width - point.getX()) * 2.0);
                x = (int)((double)(width / 2) - point.getX());
            }
            bi = new BufferedImage(width, height, 2);
            newCenter = new Point2D.Double(bi.getWidth() / 2, bi.getHeight() / 2);
            double bx = this._symbolBounds.getX();
            double by = this._symbolBounds.getY();
            if (((Point2D)newCenter).getX() > bx) {
                bx += ((Point2D)newCenter).getX() - this._centerPoint.getX();
            }
            if (((Point2D)newCenter).getY() > by) {
                by += ((Point2D)newCenter).getY() - this._centerPoint.getY();
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(bx, by, this.getSymbolBounds().getWidth(), this.getSymbolBounds().getHeight());
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage((Image)image, x, y, null);
            pi = new PNGInfo(bi, newCenter, bounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"ImageInfo", (String)"CenterImage", (Exception)exc);
        }
        return pi;
    }

    public PNGInfo squareImage() {
        BufferedImage image = null;
        Point2D point = null;
        Point2D.Double newCenter = null;
        PNGInfo pi = null;
        BufferedImage bi = null;
        double x = 0.0;
        double y = 0.0;
        int height = 0;
        int width = 0;
        try {
            image = this._image;
            point = this._centerPoint;
            height = image.getHeight();
            width = image.getWidth();
            int newSize = height;
            if (width > height) {
                newSize = width;
            }
            if (width < newSize) {
                x = (double)(newSize - width) / 2.0;
            }
            if (height < newSize) {
                y = (double)(newSize - height) / 2.0;
            }
            bi = new BufferedImage(newSize, newSize, 2);
            newCenter = new Point2D.Double(this._centerPoint.getX() + x, this._centerPoint.getY() + y);
            double bx = this._symbolBounds.getX();
            double by = this._symbolBounds.getY();
            if (((Point2D)newCenter).getX() > bx) {
                bx += x;
            }
            if (((Point2D)newCenter).getY() > by) {
                by += y;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(bx, by, this.getSymbolBounds().getWidth(), this.getSymbolBounds().getHeight());
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage((Image)image, (int)x, (int)y, null);
            pi = new PNGInfo(bi, newCenter, bounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"ImageInfo", (String)"CenterImage", (Exception)exc);
        }
        return pi;
    }

    public PNGInfo fitImage(int eWidth, int eHeight, int ecX, int ecY, int buffer) {
        BufferedImage image = null;
        Point2D.Double newCenter = null;
        PNGInfo pi = null;
        BufferedImage bi = null;
        double x = 0.0;
        double y = 0.0;
        int height = 0;
        int width = 0;
        try {
            image = this._image;
            height = image.getHeight();
            width = image.getWidth();
            int newWidth = eWidth;
            int newHeight = eHeight;
            bi = new BufferedImage(newWidth, newHeight, 2);
            int cX = (int)this._centerPoint.getX();
            int cY = (int)this._centerPoint.getY();
            int offsetX = buffer + (ecX - (cX + buffer));
            int offsetY = buffer + (ecY - (cY + buffer));
            newCenter = new Point2D.Double(ecX, ecY);
            Rectangle2D.Double bounds = new Rectangle2D.Double(offsetX, offsetY, newWidth, newHeight);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage((Image)image, offsetX, offsetY, null);
            pi = new PNGInfo(bi, newCenter, bounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"ImageInfo", (String)"CenterImage", (Exception)exc);
        }
        return pi;
    }

    public String toSVG(int drawMode) {
        String svg = "<svg></svg>";
        if (this._image != null) {
            int x = 0;
            int y = 0;
            int width = this._image.getWidth();
            int height = this._image.getHeight();
            int svgWidth = width;
            int svgHeight = height;
            if (width > 0 && height > 0) {
                String b64 = "data:image/png;base64," + Base64.encode(this.getImageAsByteArray());
                if (drawMode == 0) {
                    svg = "<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"" + width + "\" height=\"" + height + "\"><image x=\"0\" y=\"0\" width=\"" + width + "\" height=\"" + height + "\" xlink:href=\"" + b64 + "\" /></svg>";
                } else if (drawMode == 1) {
                    if (this._centerPoint.getY() > (double)svgHeight - this._centerPoint.getY()) {
                        svgHeight = (int)(this._centerPoint.getY() * 2.0);
                        y = 0;
                    } else {
                        svgHeight = (int)(((double)svgHeight - this._centerPoint.getY()) * 2.0);
                        y = (int)((double)(svgHeight / 2) - this._centerPoint.getY());
                    }
                    if (this._centerPoint.getX() > (double)svgWidth - this._centerPoint.getX()) {
                        svgWidth = (int)(this._centerPoint.getX() * 2.0);
                        x = 0;
                    } else {
                        svgWidth = (int)(((double)svgWidth - this._centerPoint.getX()) * 2.0);
                        x = (int)((double)(svgWidth / 2) - this._centerPoint.getX());
                    }
                    svg = "<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"" + svgWidth + "\" height=\"" + svgHeight + "\"><image x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" xlink:href=\"" + b64 + "\" /></svg>";
                } else if (drawMode == 2) {
                    int newSize = svgHeight;
                    if (svgWidth > svgHeight) {
                        newSize = width;
                    }
                    if (svgWidth < newSize) {
                        x = (int)((double)(newSize - svgWidth) / 2.0);
                    }
                    if (svgHeight < newSize) {
                        y = (int)((double)(newSize - svgHeight) / 2.0);
                    }
                    svg = "<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"" + newSize + "\" height=\"" + newSize + "\"><image x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" xlink:href=\"" + b64 + "\" /></svg>";
                }
            }
        }
        return svg;
    }
}

