/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.RendererPluginInterface.ISinglePointRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

public class SinglePointRendererService {
    private static SinglePointRendererService service;
    private static ServiceLoader<ISinglePointRenderer> loader;
    private static Map<String, ISinglePointRenderer> spRenderers;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Class[] parameters = new Class[]{URL.class};

    private SinglePointRendererService() {
        try {
            loader = ServiceLoader.load(ISinglePointRenderer.class);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"SinglePointRendererService", (Exception)exc);
            ErrorLogger.LogMessage((String)exc.getMessage(), (Boolean)true);
        }
    }

    public void LoadSPRendererServices() {
        ISinglePointRenderer temp2 = null;
        try {
            this.rwl.writeLock().lock();
            loader.reload();
            System.out.println("Looking for renderer plugins...");
            for (ISinglePointRenderer temp2 : loader) {
                if (temp2 == null) continue;
                System.out.println("Found renderer plugin: " + temp2.getRendererID());
                if (spRenderers.containsKey(temp2.getRendererID())) continue;
                spRenderers.put(temp2.getRendererID(), temp2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"LoadSPREendererServices", (Exception)exc);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public static synchronized SinglePointRendererService getInstance() {
        if (service == null) {
            service = new SinglePointRendererService();
        }
        return service;
    }

    public boolean canRender(String rendererID, String symbolID, Map<String, String> params) {
        ISinglePointRenderer renderer = spRenderers.get(rendererID);
        if (renderer != null && !renderer.equals("")) {
            return renderer.canRender(symbolID, params);
        }
        System.out.println("Couldn't find renderer: " + rendererID);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISinglePointInfo render(String rendererID, String symbolID, Map<String, String> params) {
        ISinglePointInfo returnVal = null;
        try {
            this.rwl.readLock().lock();
            ISinglePointRenderer renderer = spRenderers.get(rendererID);
            if (renderer != null) {
                try {
                    returnVal = renderer.render(symbolID, params);
                }
                catch (Exception exc) {
                    String message = "Plugin \"" + rendererID + "\" failed to produce an image for symboldID \"" + symbolID + "\"";
                    ErrorLogger.LogMessage((String)"SinglePointRendererService", (String)"render", (String)message, (Level)Level.FINER);
                    ErrorLogger.LogException((String)"SinglePointRendererService", (String)"render", (Exception)exc, (Level)Level.FINER);
                }
            }
            Object var6_8 = null;
            return var6_8;
        }
        catch (Exception exc2) {
            System.err.println(exc2.getMessage());
            exc2.printStackTrace();
        }
        finally {
            this.rwl.readLock().unlock();
            return returnVal;
        }
    }

    public Map<String, String> processParams(String url) {
        String symbolInfo = url;
        HashMap<String, String> modifiers = new HashMap<String, String>();
        String symbolID = null;
        String parameters = null;
        String key = null;
        String value = null;
        String[] arrParameters = null;
        String[] arrKeyValue = null;
        String temp = null;
        int questionIndex = symbolInfo.indexOf(63);
        try {
            symbolID = questionIndex == -1 ? symbolInfo : symbolInfo.substring(0, questionIndex);
        }
        catch (Exception exc) {
            System.err.println("Error parsing SymbolID");
            System.err.println(exc.getMessage());
        }
        try {
            if (questionIndex > 0 && questionIndex + 1 < symbolInfo.length()) {
                parameters = symbolInfo.substring(questionIndex + 1, symbolInfo.length());
                arrParameters = parameters.split("&");
                for (int i = 0; i < arrParameters.length; ++i) {
                    arrKeyValue = arrParameters[i].split("=");
                    if (arrKeyValue.length != 2) continue;
                    key = arrKeyValue[0];
                    value = arrKeyValue[1];
                    temp = URLDecoder.decode(value, "UTF-8");
                    modifiers.put(key.toUpperCase(), temp);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing \"" + key + "\" parameter from URL");
            System.err.println(exc.getMessage());
        }
        return modifiers;
    }

    public ArrayList<String> getSinglePointRendererIDs() {
        ArrayList<String> renderers = new ArrayList<String>();
        ISinglePointRenderer temp = null;
        Iterator<ISinglePointRenderer> itr = loader.iterator();
        try {
            while (itr.hasNext()) {
                temp = itr.next();
                if (temp == null) continue;
                renderers.add(temp.getRendererID());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"getSinglePointRendererIDs", (Exception)exc);
        }
        return renderers;
    }

    public Boolean hasRenderer(String rendererID) {
        try {
            if (spRenderers != null && spRenderers.containsKey(rendererID)) {
                return true;
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"hasRenderer", (Exception)exc);
            return false;
        }
    }

    public void AddRenderersToPath(String url) {
        try {
            if (url != null && !url.equals("")) {
                this.addURL(new URL(url));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"AddRenderersToPath", (Exception)exc);
        }
    }

    public void AddRenderersToPath(List<String> urls) {
        try {
            String url = null;
            if (urls != null && urls.size() > 0) {
                for (int i = 0; i < urls.size(); ++i) {
                    url = urls.get(i);
                    if (url == null || url.equals("")) continue;
                    this.addURL(new URL(url));
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"", (String)"AddRenderersToPath", (Exception)exc);
        }
    }

    public void AddRenderersFromPluginFolder() {
        try {
            File foo = new File("");
            File directory = new File(foo.getAbsolutePath() + "\\plugins");
            if (directory.exists()) {
                File[] files = directory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith("jar")) continue;
                    this.addURL(file.toURI().toURL());
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"AddRenderersFromPluginFolder", (Exception)exc);
        }
    }

    public void AddRenderersToPathByFile(File file) {
        try {
            if (file.exists() && file.getName().endsWith("jar")) {
                this.addURL(file.toURI().toURL());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"AddRenderersToPathByDirectory", (Exception)exc);
        }
    }

    public void AddRenderersToPathByDirectory(File directory) {
        try {
            if (directory.exists()) {
                File[] files = directory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith("jar")) continue;
                    this.addURL(file.toURI().toURL());
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"AddRenderersToPathByDirectory", (Exception)exc);
        }
    }

    private Boolean isClassLoaded(String name) {
        Boolean returnVal = false;
        ClassLoader cl = null;
        cl = SinglePointRendererService.class.getClassLoader();
        try {
            cl.loadClass(name);
            returnVal = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return returnVal;
    }

    private void addURL(URL u) {
        try {
            URLClassLoader sysLoader = (URLClassLoader)SinglePointRendererService.class.getClassLoader();
            URL[] urls = sysLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].toString().equalsIgnoreCase(u.toString())) continue;
                return;
            }
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", this.parameters);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, u);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePointRendererService", (String)"addUrl", (Exception)exc);
        }
    }

    static {
        spRenderers = new HashMap<String, ISinglePointRenderer>();
    }
}

