/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.RendererPluginInterface.ISinglePointRenderer;
import ArmyC2.C2SD.RendererPluginInterface.SinglePointInfo;
import ArmyC2.C2SD.Rendering.JavaRenderer;
import ArmyC2.C2SD.Utilities.ImageInfo;
import RenderMultipoints.clsClipPolygon2;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AreaSymbolFill
implements ISinglePointRenderer {
    public static final int DEFAULT_SYMBOL_SIZE = 25;
    public static final String KEY_SYMBOL_FILL_IDS = "SYMBOLFILLIDS";
    public static final String KEY_SYMBOL_LINE_IDS = "SYMBOLLINEIDS";
    public static final String KEY_SYMBOL_FILL_ICON_SIZE = "SYMBOLFILLICONSIZE";
    public static final String KEY_SYMBOL_COORDS = "COORDS";
    public static final String KEY_SYMBOL_CLIP = "CLIP";
    public static final String KEY_SYMBOL_HEIGHT = "HEIGHT";
    public static final String KEY_SYMBOL_WIDTH = "WIDTH";

    public String getRendererID() {
        return "AreaSymbolFillRenderer";
    }

    public Boolean canRender(String symbolID, Map<String, String> params) {
        if (symbolID.equalsIgnoreCase("AREASYMBOLFILL")) {
            return true;
        }
        return false;
    }

    public ISinglePointInfo render(String symbolID, Map<String, String> params) {
        if (params.containsKey(KEY_SYMBOL_FILL_IDS)) {
            return this.renderAreaSymbolFill(params);
        }
        if (params.containsKey(KEY_SYMBOL_LINE_IDS)) {
            return this.renderLineSymbolFill(params);
        }
        return null;
    }

    private ISinglePointInfo renderAreaSymbolFill(Map<String, String> params) {
        SinglePointInfo returnVal = null;
        try {
            String strCoords = String.valueOf(params.get(KEY_SYMBOL_COORDS));
            String strSymbolIDs = String.valueOf(params.get(KEY_SYMBOL_FILL_IDS));
            String strClip = null;
            String[] arrclip = null;
            Rectangle2D.Double clip = null;
            String[] strArrCoords = strCoords.split(",");
            int length = strArrCoords.length;
            int[] coords = new int[strArrCoords.length];
            for (int i = 0; i < length; ++i) {
                coords[i] = Integer.valueOf(strArrCoords[i]);
            }
            if (params.containsKey(KEY_SYMBOL_CLIP)) {
                strClip = String.valueOf(params.get(KEY_SYMBOL_CLIP));
            }
            if (strClip != null) {
                arrclip = strClip.split(",");
                clip = new Rectangle2D.Double(Double.valueOf(arrclip[0]), Double.valueOf(arrclip[1]), Double.valueOf(arrclip[2]), Double.valueOf(arrclip[3]));
            }
            int height = Integer.valueOf(params.get(KEY_SYMBOL_HEIGHT));
            int width = Integer.valueOf(params.get(KEY_SYMBOL_WIDTH));
            if (height <= 0) {
                height = 1;
            }
            if (width <= 0) {
                width = 1;
            }
            int size = -1;
            size = params.containsKey(KEY_SYMBOL_FILL_ICON_SIZE) ? Integer.valueOf(params.get(KEY_SYMBOL_FILL_ICON_SIZE)) : 25;
            String[] symbolIDs = strSymbolIDs.split(",");
            double ratio = 1.0;
            double maxImageSize = 1000.0;
            double minImageSize = 400.0;
            if ((double)height > maxImageSize || (double)width > maxImageSize) {
                ratio = height > width ? maxImageSize / (double)height : maxImageSize / (double)width;
                height = (int)((double)height * ratio);
                width = (int)((double)width * ratio);
            } else if ((double)height < minImageSize || (double)width < minImageSize) {
                ratio = height > width ? minImageSize / (double)height : minImageSize / (double)width;
                height = (int)((double)height * ratio);
                width = (int)((double)width * ratio);
            }
            BufferedImage fill = new BufferedImage(width, height, 2);
            ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
            HashMap<String, String> modifiers = new HashMap<String, String>();
            if (size > 0) {
                modifiers.put("SIZE", String.valueOf(size));
            }
            Object bounds = null;
            ImageInfo iiTemp = null;
            int maxHeight = 0;
            int symStd = 1;
            for (String id : symbolIDs) {
                iiTemp = JavaRenderer.getInstance().RenderSinglePointAsImageInfo(id, modifiers, size, true, symStd);
                images.add(iiTemp);
                if (iiTemp.getImage().getHeight() <= maxHeight) continue;
                maxHeight = iiTemp.getImage().getHeight();
            }
            int hOffset = maxHeight / 2;
            int ySpacer = 5;
            int xSpacer = 5;
            int x = 0;
            int y = hOffset;
            Graphics2D g = fill.createGraphics();
            int imageIndex = 0;
            int cx = 0;
            int cy = 0;
            Polygon clipShape = new Polygon();
            Path2D.Double clipPath = new Path2D.Double();
            for (int i = 0; i < coords.length - 1; ++i) {
                clipShape.addPoint(coords[i], coords[i + 1]);
                if (i == 0) {
                    cx = coords[i];
                    cy = coords[i + 1];
                    ((Path2D)clipPath).moveTo(coords[i], coords[i + 1]);
                } else {
                    cx = coords[i];
                    cy = coords[i + 1];
                    ((Path2D)clipPath).lineTo(coords[i], coords[i + 1]);
                }
                ++i;
            }
            clipPath.closePath();
            clipPath.setWindingRule(0);
            Area clipArea = null;
            Area srcArea = null;
            Boolean clippingEnabled = false;
            if (clippingEnabled.booleanValue() && clip != null && !(clipArea = new Area(clip)).contains((srcArea = new Area(clipPath)).getBounds2D())) {
                srcArea.intersect(clipArea);
            }
            if (ratio != 1.0) {
                ((Path2D)clipPath).transform(AffineTransform.getScaleInstance(ratio, ratio));
            }
            if (srcArea != null) {
                g.setClip(srcArea);
            } else {
                g.setClip(clipPath);
            }
            while (y < fill.getHeight() && x < fill.getWidth()) {
                iiTemp = (ImageInfo)images.get(imageIndex);
                g.drawImage((Image)iiTemp.getImage(), x, y - iiTemp.getSymbolCenterY(), null);
                if ((x += iiTemp.getImage().getWidth() + xSpacer) + iiTemp.getImage().getWidth() > fill.getWidth()) {
                    x = 0;
                    y += maxHeight + ySpacer;
                }
                if (++imageIndex <= images.size() - 1) continue;
                imageIndex = 0;
            }
            g.setClip(null);
            returnVal = new SinglePointInfo(fill);
            g.dispose();
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return returnVal;
    }

    private ISinglePointInfo renderLineSymbolFill(Map<String, String> params) {
        SinglePointInfo returnVal = null;
        try {
            ArrayList<Point2D.Double> points = null;
            String strClip = null;
            String strCoords = String.valueOf(params.get(KEY_SYMBOL_COORDS));
            String strSymbolIDs = String.valueOf(params.get(KEY_SYMBOL_LINE_IDS));
            int buffer = 12;
            String[] arrclip = null;
            Rectangle2D.Double clip = null;
            int size = -1;
            size = params.containsKey(KEY_SYMBOL_FILL_ICON_SIZE) ? Integer.valueOf(params.get(KEY_SYMBOL_FILL_ICON_SIZE)) : 25;
            buffer = size / 2 + 3;
            if (params.containsKey(KEY_SYMBOL_CLIP)) {
                strClip = String.valueOf(params.get(KEY_SYMBOL_CLIP));
            }
            if (strClip != null) {
                arrclip = strClip.split(",");
                clip = new Rectangle2D.Double(Double.valueOf(arrclip[0]), Double.valueOf(arrclip[1]), Double.valueOf(arrclip[2]), Double.valueOf(arrclip[3]));
            }
            int height = Integer.valueOf(params.get(KEY_SYMBOL_HEIGHT));
            int width = Integer.valueOf(params.get(KEY_SYMBOL_WIDTH));
            if (height <= 0) {
                height = 1;
            } else if (width <= 0) {
                width = 1;
            }
            double ratio = 1.0;
            double maxImageSize = 1000.0;
            double minImageSize = 400.0;
            String[] strArrCoords = strCoords.split(",");
            int length = strArrCoords.length;
            int[] coords = new int[strArrCoords.length];
            for (int j = 0; j < strArrCoords.length; ++j) {
                coords[j] = Integer.valueOf(strArrCoords[j]);
            }
            Path2D.Double path = new Path2D.Double();
            for (int i = 0; i < length - 1; ++i) {
                if (i > 0) {
                    ((Path2D)path).lineTo(coords[i], coords[i + 1]);
                } else if (i == 0) {
                    ((Path2D)path).moveTo(coords[i], coords[i + 1]);
                }
                ++i;
            }
            Rectangle2D pathBounds = path.getBounds2D();
            if (pathBounds.getHeight() > maxImageSize || pathBounds.getWidth() > maxImageSize) {
                ratio = pathBounds.getHeight() > pathBounds.getWidth() ? maxImageSize / pathBounds.getHeight() : maxImageSize / pathBounds.getWidth();
            }
            if (ratio != 1.0) {
                ((Path2D)path).transform(AffineTransform.getScaleInstance(ratio, ratio));
            }
            ((Path2D)path).transform(AffineTransform.getTranslateInstance(buffer, buffer));
            PathIterator itr = path.getPathIterator(null);
            points = new ArrayList<Point2D.Double>();
            double[] dpts = new double[6];
            while (!itr.isDone()) {
                itr.currentSegment(dpts);
                points.add(new Point2D.Double(dpts[0], dpts[1]));
                itr.next();
            }
            height = (int)((double)height * ratio) + buffer * 2;
            width = (int)((double)width * ratio) + buffer * 2;
            String[] symbolIDs = strSymbolIDs.split(",");
            BufferedImage fill = new BufferedImage(width, height, 2);
            ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
            HashMap<String, String> modifiers = new HashMap<String, String>();
            if (size > 0) {
                modifiers.put("SIZE", String.valueOf(size));
            }
            Object bounds = null;
            ImageInfo iiTemp = null;
            int maxHeight = 0;
            ArrayList<SymbolPoint> iconPoints = this.getPointsOnLineForSymbols(points, size, size, null);
            boolean j = false;
            double rotation = 0.0;
            int symStd = 1;
            for (String id : symbolIDs) {
                iiTemp = JavaRenderer.getInstance().RenderSinglePointAsImageInfo(id, modifiers, size, true, symStd);
                images.add(iiTemp);
                if (iiTemp.getImage().getHeight() <= maxHeight) continue;
                maxHeight = iiTemp.getImage().getHeight();
            }
            Graphics2D g = fill.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            int i = 0;
            int k = 0;
            double currentRotation = 0.0;
            for (SymbolPoint point : iconPoints) {
                iiTemp = (ImageInfo)images.get(i);
                ++k;
                if (++i >= images.size()) {
                    i = 0;
                }
                int x = (int)point.getX() - iiTemp.getSymbolCenterX();
                int y = (int)point.getY() - iiTemp.getSymbolCenterY();
                currentRotation = Math.toRadians(point.getRotation());
                g.setTransform(AffineTransform.getRotateInstance(currentRotation, point.getX(), point.getY()));
                g.drawImage((Image)iiTemp.getImage(), x, y, null);
                g.setTransform(new AffineTransform());
            }
            returnVal = new SinglePointInfo(fill);
            g.dispose();
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return returnVal;
    }

    private ArrayList<SymbolPoint> getPointsOnLineForSymbols(ArrayList<Point2D.Double> points, int iconHeight, int iconWidth, Rectangle2D clip) {
        ArrayList<SymbolPoint> returnPoints = new ArrayList<SymbolPoint>();
        try {
            ArrayList<Double> pts = AreaSymbolFill.lineToImages(points, iconWidth, iconHeight, 10.0, clip);
            int j = 0;
            for (j = 0; j < pts.size() / 3; ++j) {
                returnPoints.add(new SymbolPoint(pts.get(3 * j), pts.get(3 * j + 1), pts.get(3 * j + 2)));
            }
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return returnPoints;
    }

    public static ArrayList<Double> lineToImages(ArrayList<Point2D.Double> points, double iconWidth, double iconHeight, double pixelSpace, Rectangle2D clipBounds) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        int j = 0;
        for (j = 0; j < points.size(); ++j) {
            pts.add(new Point2D.Double(points.get((int)j).x, points.get((int)j).y));
        }
        return AreaSymbolFill.lineToImages2(pts, iconWidth, iconHeight, pixelSpace, clipBounds);
    }

    private static ArrayList<Double> lineToImages2(ArrayList<Point2D> points, double iconWidth, double iconHeight, double pixelSpace, Rectangle2D clipBounds) {
        ArrayList<Double> pts = null;
        try {
            int j = 0;
            int k = 0;
            double x = 0.0;
            double y = 0.0;
            if (clipBounds != null) {
                double width = clipBounds.getWidth();
                double height = clipBounds.getHeight();
                x = clipBounds.getX();
                y = clipBounds.getY();
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
                points = clsClipPolygon2.ClipPolygon2(points, (Rectangle2D)clipBounds, (Boolean)false);
            }
            double x1 = 0.0;
            double y1 = 0.0;
            Point2D pt1 = null;
            Point2D pt2 = null;
            double dist = 0.0;
            pts = new ArrayList<Double>();
            for (j = 0; j < points.size() - 1; ++j) {
                if (points.get(j) == null) continue;
                pt1 = (Point2D)points.get(j);
                pt2 = (Point2D)points.get(j + 1);
                x1 = pt1.getX();
                y1 = pt1.getY();
                double x2 = pt2.getX();
                double y2 = pt2.getY();
                dist = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
                int iterations = (int)(dist / (pixelSpace + iconWidth));
                double angle = Math.atan((y2 - y1) / (x2 - x1)) * 57.29577951308232;
                for (k = 0; k < iterations; ++k) {
                    x = x1 + (double)k / (double)iterations * (x2 - x1);
                    y = y1 + (double)k / (double)iterations * (y2 - y1);
                    pts.add(x);
                    pts.add(y);
                    pts.add(angle);
                }
            }
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return pts;
    }

    public class SymbolPoint {
        double _x;
        double _y;
        double _rotation;

        public SymbolPoint(double x, double y, double rotation) {
            this._x = x;
            this._y = y;
            this._rotation = rotation;
        }

        public double getX() {
            return this._x;
        }

        public double getY() {
            return this._y;
        }

        public double getRotation() {
            return this._rotation;
        }
    }
}

