/*
 * Decompiled with CFR 0.152.
 */
package sec.geo;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gavaghan.geodesy.Angle;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import sec.geo.GeoPoint;

public class GeoPath
implements Shape {
    protected static final Ellipsoid REFERENCE_ELLIPSOID = Ellipsoid.WGS84;
    private final Path2D path = new Path2D.Double();
    private final List<GeoPoint> toPoints = new ArrayList<GeoPoint>();
    private final double maxDistanceMeters;
    private final double flatnessDistanceMeters;
    private final int limit;
    protected final GeodeticCalculator geoCalc = new GeodeticCalculator();

    public GeoPath() {
        this(100000.0, 1.0, 4);
    }

    public GeoPath(double maxDistanceMeters, double flatnessDistanceMeters, int limit) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.limit = limit;
    }

    public void moveTo(GeoPoint point) {
        this.path.moveTo(point.x, point.y);
        this.toPoints.add(point);
    }

    public void moveTo(double longitudeDegrees, double latitudeDegrees) {
        this.moveTo(new GeoPoint(longitudeDegrees, latitudeDegrees));
    }

    public void lineTo(GeoPoint point) {
        Path2D.Double newPath = new Path2D.Double();
        GeoPoint lastPoint = new GeoPoint();
        if (this.toPoints.size() > 0) {
            lastPoint = this.toPoints.get(this.toPoints.size() - 1);
            ((Path2D)newPath).moveTo(lastPoint.x, lastPoint.y);
        }
        GlobalCoordinates start = this.toGlobalCoord(lastPoint);
        GlobalCoordinates end = this.toGlobalCoord(point);
        GeodeticCurve curve = this.geoCalc.calculateGeodeticCurve(REFERENCE_ELLIPSOID, start, end);
        for (double distance = this.maxDistanceMeters; distance < curve.getEllipsoidalDistance(); distance += this.maxDistanceMeters) {
            GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, start, curve.getAzimuth(), distance);
            ((Path2D)newPath).lineTo(c.getLongitude(), c.getLatitude());
        }
        ((Path2D)newPath).lineTo(point.x, point.y);
        this.path.append(newPath, true);
        this.toPoints.add(point);
    }

    public void lineTo(double longitudeDegrees, double latitudeDegrees) {
        this.lineTo(new GeoPoint(longitudeDegrees, latitudeDegrees));
    }

    public void arcTo(GeoPoint pivot, double widthMeters, double heightMeters, double leftAzimuthDegrees, double rightAzimuthDegrees) {
        Path2D.Double newPath = new Path2D.Double();
        Arc2D.Double arc = leftAzimuthDegrees > rightAzimuthDegrees ? new Arc2D.Double(-widthMeters / 2.0, -heightMeters / 2.0, widthMeters, heightMeters, leftAzimuthDegrees - 90.0, Math.abs(360.0 - leftAzimuthDegrees + rightAzimuthDegrees), 0) : new Arc2D.Double(-widthMeters / 2.0, -heightMeters / 2.0, widthMeters, heightMeters, leftAzimuthDegrees - 90.0, Math.abs(leftAzimuthDegrees - rightAzimuthDegrees), 0);
        GeoPoint point = null;
        if (pivot != null) {
            FlatteningPathIterator it = new FlatteningPathIterator(arc.getPathIterator(null), this.flatnessDistanceMeters, this.limit);
            while (!it.isDone()) {
                double[] strokePoints = new double[6];
                int type = it.currentSegment(strokePoints);
                double x = strokePoints[0];
                double y = strokePoints[1];
                double azimuth = Angle.toDegrees(Math.atan2(x, y));
                GlobalCoordinates coord = new GlobalCoordinates(pivot.getLatitude(), pivot.getLongitude());
                GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, coord, azimuth, new Point2D.Double().distance(x, y));
                switch (type) {
                    case 0: {
                        ((Path2D)newPath).moveTo(c.getLongitude(), c.getLatitude());
                        GeoPoint startPoint = new GeoPoint(c.getLongitude(), c.getLatitude());
                        if (this.toPoints.size() <= 0 || startPoint.equals(this.toPoints.get(this.toPoints.size() - 1))) break;
                        this.lineTo(startPoint);
                        break;
                    }
                    case 1: {
                        ((Path2D)newPath).lineTo(c.getLongitude(), c.getLatitude());
                        point = new GeoPoint(c.getLongitude(), c.getLatitude());
                    }
                }
                it.next();
            }
        }
        this.path.append(newPath, true);
        this.toPoints.add(point);
    }

    public List<GeoPoint> getToPoints() {
        return this.toPoints;
    }

    public void closePath() {
        if (this.toPoints.get(0) != null && this.toPoints.get(this.toPoints.size() - 1) != null && this.toPoints.size() > 0 && !this.toPoints.get(0).equals(this.toPoints.get(this.toPoints.size() - 1))) {
            this.lineTo(this.toPoints.get(0));
        }
    }

    @Override
    public boolean contains(Point2D p) {
        return this.path.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    public String toString() {
        return this.toPoints.toString();
    }

    protected GlobalCoordinates toGlobalCoord(GeoPoint point) {
        return new GlobalCoordinates(point.getLatitude(), point.getLongitude());
    }

    public Path2D getPath() {
        return this.path;
    }
}

