/*
 * Decompiled with CFR 0.152.
 */
package sec.geo;

import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import sec.geo.GeoPath;
import sec.geo.GeoPoint;

public class GeoBlock
extends GeoPath {
    public GeoBlock(GeoPoint p1, GeoPoint p2, double widthMeters, double maxDistanceMeters, double flatnessDistanceMeters, int limit) {
        super(maxDistanceMeters, flatnessDistanceMeters, limit);
        GlobalCoordinates c1 = this.toGlobalCoord(p1);
        GlobalCoordinates c2 = this.toGlobalCoord(p2);
        GeodeticCurve curve = this.geoCalc.calculateGeodeticCurve(REFERENCE_ELLIPSOID, c1, c2);
        double a1 = curve.getAzimuth();
        double a2 = curve.getReverseAzimuth();
        double radius = widthMeters / 2.0;
        GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c1, a1 - 90.0, radius);
        this.moveTo(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c2, a2 + 90.0, radius);
        this.lineTo(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c2, a2 - 90.0, radius);
        this.lineTo(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c1, a1 + 90.0, radius);
        this.lineTo(c.getLongitude(), c.getLatitude());
        this.closePath();
    }
}

