/*
 * Decompiled with CFR 0.152.
 */
package org.gavaghan.geodesy;

import org.gavaghan.geodesy.Angle;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GeodeticMeasurement;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.gavaghan.geodesy.GlobalPosition;

public class GeodeticCalculator {
    private final double TwoPi = Math.PI * 2;

    public GlobalCoordinates calculateEndingGlobalCoordinates(Ellipsoid ellipsoid, GlobalCoordinates start, double startBearing, double distance, double[] endBearing) {
        double sinSigma;
        double cos2SigmaM2;
        double cosSigmaM2;
        double sigmaM2;
        double sOverbA;
        double a = ellipsoid.getSemiMajorAxis();
        double b = ellipsoid.getSemiMinorAxis();
        double aSquared = a * a;
        double bSquared = b * b;
        double f = ellipsoid.getFlattening();
        double phi1 = Angle.toRadians(start.getLatitude());
        double alpha1 = Angle.toRadians(startBearing);
        double cosAlpha1 = Math.cos(alpha1);
        double sinAlpha1 = Math.sin(alpha1);
        double s = distance;
        double tanU1 = (1.0 - f) * Math.tan(phi1);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double sigma1 = Math.atan2(tanU1, cosAlpha1);
        double sinAlpha = cosU1 * sinAlpha1;
        double sin2Alpha = sinAlpha * sinAlpha;
        double cos2Alpha = 1.0 - sin2Alpha;
        double uSquared = cos2Alpha * (aSquared - bSquared) / bSquared;
        double A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
        double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
        double sigma = sOverbA = s / (b * A);
        double prevSigma = sOverbA;
        while (true) {
            double cosSignma;
            sigmaM2 = 2.0 * sigma1 + sigma;
            cosSigmaM2 = Math.cos(sigmaM2);
            cos2SigmaM2 = cosSigmaM2 * cosSigmaM2;
            sinSigma = Math.sin(sigma);
            double deltaSigma = B * sinSigma * (cosSigmaM2 + B / 4.0 * ((cosSignma = Math.cos(sigma)) * (-1.0 + 2.0 * cos2SigmaM2) - B / 6.0 * cosSigmaM2 * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM2)));
            if (Double.isNaN(sigma = sOverbA + deltaSigma) || Double.isNaN(prevSigma)) {
                throw new RuntimeException("Point values may be the same; approximation convereged to NaN");
            }
            if (Math.abs(sigma - prevSigma) < 1.0E-13) break;
            prevSigma = sigma;
        }
        sigmaM2 = 2.0 * sigma1 + sigma;
        cosSigmaM2 = Math.cos(sigmaM2);
        cos2SigmaM2 = cosSigmaM2 * cosSigmaM2;
        double cosSigma = Math.cos(sigma);
        sinSigma = Math.sin(sigma);
        double phi2 = Math.atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosAlpha1, (1.0 - f) * Math.sqrt(sin2Alpha + Math.pow(sinU1 * sinSigma - cosU1 * cosSigma * cosAlpha1, 2.0)));
        double lambda = Math.atan2(sinSigma * sinAlpha1, cosU1 * cosSigma - sinU1 * sinSigma * cosAlpha1);
        double C = f / 16.0 * cos2Alpha * (4.0 + f * (4.0 - 3.0 * cos2Alpha));
        double L = lambda - (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cosSigmaM2 + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM2)));
        double alpha2 = Math.atan2(sinAlpha, -sinU1 * sinSigma + cosU1 * cosSigma * cosAlpha1);
        double latitude = Angle.toDegrees(phi2);
        double longitude = start.getLongitude() + Angle.toDegrees(L);
        if (endBearing != null && endBearing.length > 0) {
            endBearing[0] = Angle.toDegrees(alpha2);
        }
        return new GlobalCoordinates(latitude, longitude);
    }

    public GlobalCoordinates calculateEndingGlobalCoordinates(Ellipsoid ellipsoid, GlobalCoordinates start, double startBearing, double distance) {
        return this.calculateEndingGlobalCoordinates(ellipsoid, start, startBearing, distance, null);
    }

    public GeodeticCurve calculateGeodeticCurve(Ellipsoid ellipsoid, GlobalCoordinates start, GlobalCoordinates end) {
        double alpha2;
        double alpha1;
        double a = ellipsoid.getSemiMajorAxis();
        double b = ellipsoid.getSemiMinorAxis();
        double f = ellipsoid.getFlattening();
        double phi1 = Angle.toRadians(start.getLatitude());
        double lambda1 = Angle.toRadians(start.getLongitude());
        double phi2 = Angle.toRadians(end.getLatitude());
        double lambda2 = Angle.toRadians(end.getLongitude());
        double a2 = a * a;
        double b2 = b * b;
        double a2b2b2 = (a2 - b2) / b2;
        double omega = lambda2 - lambda1;
        double tanphi1 = Math.tan(phi1);
        double tanU1 = (1.0 - f) * tanphi1;
        double U1 = Math.atan(tanU1);
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double tanphi2 = Math.tan(phi2);
        double tanU2 = (1.0 - f) * tanphi2;
        double U2 = Math.atan(tanU2);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double sinU1sinU2 = sinU1 * sinU2;
        double cosU1sinU2 = cosU1 * sinU2;
        double sinU1cosU2 = sinU1 * cosU2;
        double cosU1cosU2 = cosU1 * cosU2;
        double lambda = omega;
        double A = 0.0;
        double B = 0.0;
        double sigma = 0.0;
        double deltasigma = 0.0;
        boolean converged = false;
        for (int i = 0; i < 20; ++i) {
            double lambda0 = lambda;
            double sinlambda = Math.sin(lambda);
            double coslambda = Math.cos(lambda);
            double sin2sigma = cosU2 * sinlambda * cosU2 * sinlambda + (cosU1sinU2 - sinU1cosU2 * coslambda) * (cosU1sinU2 - sinU1cosU2 * coslambda);
            double sinsigma = Math.sqrt(sin2sigma);
            double cossigma = sinU1sinU2 + cosU1cosU2 * coslambda;
            sigma = Math.atan2(sinsigma, cossigma);
            double sinalpha = sin2sigma == 0.0 ? 0.0 : cosU1cosU2 * sinlambda / sinsigma;
            double alpha = Math.asin(sinalpha);
            double cosalpha = Math.cos(alpha);
            double cos2alpha = cosalpha * cosalpha;
            double cos2sigmam = cos2alpha == 0.0 ? 0.0 : cossigma - 2.0 * sinU1sinU2 / cos2alpha;
            double u2 = cos2alpha * a2b2b2;
            double cos2sigmam2 = cos2sigmam * cos2sigmam;
            A = 1.0 + u2 / 16384.0 * (4096.0 + u2 * (-768.0 + u2 * (320.0 - 175.0 * u2)));
            B = u2 / 1024.0 * (256.0 + u2 * (-128.0 + u2 * (74.0 - 47.0 * u2)));
            deltasigma = B * sinsigma * (cos2sigmam + B / 4.0 * (cossigma * (-1.0 + 2.0 * cos2sigmam2) - B / 6.0 * cos2sigmam * (-3.0 + 4.0 * sin2sigma) * (-3.0 + 4.0 * cos2sigmam2)));
            double C = f / 16.0 * cos2alpha * (4.0 + f * (4.0 - 3.0 * cos2alpha));
            lambda = omega + (1.0 - C) * f * sinalpha * (sigma + C * sinsigma * (cos2sigmam + C * cossigma * (-1.0 + 2.0 * cos2sigmam2)));
            double change = Math.abs((lambda - lambda0) / lambda);
            if (i <= 1 || !(change < 1.0E-13)) continue;
            converged = true;
            break;
        }
        double s = b * A * (sigma - deltasigma);
        if (!converged) {
            if (phi1 > phi2) {
                alpha1 = 180.0;
                alpha2 = 0.0;
            } else if (phi1 < phi2) {
                alpha1 = 0.0;
                alpha2 = 180.0;
            } else {
                alpha1 = Double.NaN;
                alpha2 = Double.NaN;
            }
        } else {
            double radians = Math.atan2(cosU2 * Math.sin(lambda), cosU1sinU2 - sinU1cosU2 * Math.cos(lambda));
            if (radians < 0.0) {
                radians += Math.PI * 2;
            }
            alpha1 = Angle.toDegrees(radians);
            radians = Math.atan2(cosU1 * Math.sin(lambda), -sinU1cosU2 + cosU1sinU2 * Math.cos(lambda)) + Math.PI;
            if (radians < 0.0) {
                radians += Math.PI * 2;
            }
            alpha2 = Angle.toDegrees(radians);
        }
        if (alpha1 >= 360.0) {
            alpha1 -= 360.0;
        }
        if (alpha2 >= 360.0) {
            alpha2 -= 360.0;
        }
        return new GeodeticCurve(s, alpha1, alpha2);
    }

    public GeodeticMeasurement calculateGeodeticMeasurement(Ellipsoid refEllipsoid, GlobalPosition start, GlobalPosition end) {
        double elev1 = start.getElevation();
        double elev2 = end.getElevation();
        double elev12 = (elev1 + elev2) / 2.0;
        double phi1 = Angle.toRadians(start.getLatitude());
        double phi2 = Angle.toRadians(end.getLatitude());
        double phi12 = (phi1 + phi2) / 2.0;
        double refA = refEllipsoid.getSemiMajorAxis();
        double f = refEllipsoid.getFlattening();
        double a = refA + elev12 * (1.0 + f * Math.sin(phi12));
        Ellipsoid ellipsoid = Ellipsoid.fromAAndF(a, f);
        GeodeticCurve averageCurve = this.calculateGeodeticCurve(ellipsoid, start, end);
        return new GeodeticMeasurement(averageCurve, elev2 - elev1);
    }
}

