/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.UnitFontLookupInfo;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class UnitFontLookup {
    private static UnitFontLookup _instance;
    private boolean _ready = false;
    private static HashMap<String, UnitFontLookupInfo> hashMapB;
    private static HashMap<String, UnitFontLookupInfo> hashMapC;
    private static final int FillIndexUZ = 800;
    private static final int FillIndexUP = 849;
    private static final int FillIndexUA = 825;
    private static final int FillIndexUG = 800;
    private static final int FillIndexUGE = 800;
    private static final int FillIndexUS = 800;
    private static final int FillIndexUU = 837;
    private static final int FillIndexUF = 800;
    private static final int FillIndexFZ = 812;
    private static final int FillIndexFP = 843;
    private static final int FillIndexFA = 819;
    private static final int FillIndexFG = 803;
    private static final int FillIndexFGE = 812;
    private static final int FillIndexFS = 812;
    private static final int FillIndexFU = 831;
    private static final int FillIndexFF = 803;
    private static final int FillIndexNZ = 809;
    private static final int FillIndexNP = 846;
    private static final int FillIndexNA = 822;
    private static final int FillIndexNG = 809;
    private static final int FillIndexNGE = 809;
    private static final int FillIndexNS = 809;
    private static final int FillIndexNU = 834;
    private static final int FillIndexNF = 809;
    private static final int FillIndexHZ = 806;
    private static final int FillIndexHP = 840;
    private static final int FillIndexHA = 816;
    private static final int FillIndexHG = 806;
    private static final int FillIndexHGE = 806;
    private static final int FillIndexHS = 806;
    private static final int FillIndexHU = 828;
    private static final int FillIndexHF = 806;

    public boolean getReady() {
        return this._ready;
    }

    private UnitFontLookup() {
        this.init();
    }

    public static synchronized UnitFontLookup getInstance() {
        if (_instance == null) {
            _instance = new UnitFontLookup();
        }
        return _instance;
    }

    private void init() {
        this.xmlLoaded();
    }

    private void xmlLoaded() {
        String xmlPathB = "XML/UnitFontMappingsB.xml";
        String xmlPathC = "XML/UnitFontMappingsC.xml";
        InputStream xmlStreamB = this.getClass().getClassLoader().getResourceAsStream(xmlPathB);
        InputStream xmlStreamC = this.getClass().getClassLoader().getResourceAsStream(xmlPathC);
        String lookupXmlB = FileHandler.InputStreamToString(xmlStreamB);
        String lookupXmlC = FileHandler.InputStreamToString(xmlStreamC);
        this.populateLookup(lookupXmlB, 0);
        this.populateLookup(lookupXmlC, 1);
    }

    private void populateLookup(String xml, int SymbologyStandard) {
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            String ID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String description = XMLUtil.parseTagValue(data, "<DESCRIPTION>", "</DESCRIPTION>");
            String m1u = XMLUtil.parseTagValue(data, "<MAPPING1U>", "</MAPPING1U>");
            String m1f = XMLUtil.parseTagValue(data, "<MAPPING1F>", "</MAPPING1F>");
            String m1n = XMLUtil.parseTagValue(data, "<MAPPING1N>", "</MAPPING1N>");
            String m1h = XMLUtil.parseTagValue(data, "<MAPPING1H>", "</MAPPING1H>");
            String m2 = XMLUtil.parseTagValue(data, "<MAPPING2>", "</MAPPING2>");
            String c1 = XMLUtil.parseTagValue(data, "<MAPPING1COLOR>", "</MAPPING1COLOR>");
            String c2 = XMLUtil.parseTagValue(data, "<MAPPING2COLOR>", "</MAPPING2COLOR>");
            UnitFontLookupInfo uflTemp = null;
            uflTemp = new UnitFontLookupInfo(ID, description, m1u = UnitFontLookup.checkMappingIndex(m1u), m1f = UnitFontLookup.checkMappingIndex(m1f), m1n = UnitFontLookup.checkMappingIndex(m1n), m1h = UnitFontLookup.checkMappingIndex(m1h), c1, m2 = UnitFontLookup.checkMappingIndex(m2), c2);
            if (uflTemp == null) continue;
            if (SymbologyStandard == 0) {
                hashMapB.put(ID, uflTemp);
                continue;
            }
            if (SymbologyStandard != 1) continue;
            hashMapC.put(ID, uflTemp);
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            if (i < 9000) {
                return String.valueOf(i + 57000);
            }
            return String.valueOf(i + 54000);
        }
        return index;
    }

    private String resolveAffiliation(String symbolID) {
        String code = symbolID.substring(0);
        String affiliation = symbolID.substring(1, 2);
        if (affiliation.equals("F") || affiliation.equals("H") || affiliation.equals("U") || affiliation.equals("N")) {
            return code;
        }
        code = affiliation.equals("S") ? code.substring(0, 1) + "H" + code.substring(2, 15) : (affiliation.equals("L") ? code.substring(0, 1) + "N" + code.substring(2, 15) : (affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("K") || affiliation.equals("J") ? code.substring(0, 1) + "F" + code.substring(2, 15) : (affiliation.equals("P") || affiliation.equals("G") || affiliation.equals("O") || affiliation.equals("W") ? code.substring(0, 1) + "U" + code.substring(2, 15) : code.substring(0, 1) + "U" + code.substring(2, 15))));
        return code;
    }

    public static UnitFontLookupInfo adjustSubSurfaceIfNot2525C(UnitFontLookupInfo original) {
        UnitFontLookupInfo result = null;
        return result;
    }

    public static int getFillCode(String SymbolID2, int symStd) {
        int returnVal = -1;
        char scheme = '\u0000';
        char battleDimension = '\u0000';
        char status = '\u0000';
        char affiliation = '\u0000';
        char grdtrkSubset = '\u0000';
        try {
            if (SymbolID2 != null && SymbolID2.length() >= 10) {
                scheme = SymbolID2.charAt(0);
                affiliation = SymbolID2.charAt(1);
                battleDimension = SymbolID2.charAt(2);
                status = SymbolID2.charAt(3);
                grdtrkSubset = SymbolID2.charAt(4);
                returnVal = scheme == 'S' ? (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (battleDimension == 'F' || battleDimension == 'G' ? (battleDimension == 'F' || battleDimension == 'G' && (grdtrkSubset == 'U' || grdtrkSubset == 'I' || grdtrkSubset == '0' || grdtrkSubset == '-') ? 803 : (battleDimension == 'G' && grdtrkSubset == 'E' ? 812 : 803)) : (battleDimension == 'A' ? 819 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID2) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID2, symStd) : (battleDimension == 'P' ? (symStd == 0 ? 819 : 843) : 812))))) : (affiliation == 'H' || affiliation == 'S' ? (battleDimension == 'F' || battleDimension == 'G' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID2) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID2, symStd) : (battleDimension == 'P' ? (symStd == 0 ? 816 : 840) : 806))))) : (affiliation == 'N' || affiliation == 'L' ? (battleDimension == 'F' || battleDimension == 'G' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID2) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID2, symStd) : (battleDimension == 'P' ? (symStd == 0 ? 822 : 846) : 809))))) : (battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID2) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID2, symStd) : (battleDimension == 'P' ? (symStd == 0 ? 825 : 849) : 800)))))))) : (scheme == 'E' ? (battleDimension != 'N' ? (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (SymbolUtilities.isEMSEquipment(SymbolID2) ? 812 : 803) : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800))) : -1) : (scheme == 'I' ? (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (battleDimension == 'Z' ? 812 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? (scheme == 'I' ? 812 : 803) : (battleDimension == 'A' ? 819 : (battleDimension == 'U' ? 831 : (battleDimension == 'P' ? (symStd == 0 ? 819 : 843) : (scheme == 'I' ? 812 : 803)))))) : (affiliation == 'H' || affiliation == 'S' ? (battleDimension == 'Z' ? 806 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'U' ? 828 : (battleDimension == 'P' ? (symStd == 0 ? 816 : 840) : 806))))) : (affiliation == 'N' || affiliation == 'L' ? (battleDimension == 'Z' ? 809 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'U' ? 834 : (battleDimension == 'P' ? (symStd == 0 ? 822 : 846) : 809))))) : (battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'S' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'U' ? 837 : (battleDimension == 'P' ? (symStd == 0 ? 825 : 849) : 800))))))) : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (SymbolID2.startsWith("OFI") && SymbolID2.substring(4, 10).equals("T-----") ? 812 : 803) : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800)))));
            } else {
                returnVal = 800;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookup", "getFillCode", exc, Level.SEVERE);
        }
        return returnVal + 57000;
    }

    public static int getFrameCode(String SymbolID2, int FillCode) {
        return UnitFontLookup.getFrameCode(SymbolID2, FillCode, RendererSettings.getInstance().getSymbologyStandard());
    }

    public static int getFrameCode(String SymbolID2, int FillCode, int symStd) {
        int returnVal = 0;
        char status = SymbolID2.charAt(3);
        returnVal = status == 'A' ? FillCode + 2 : FillCode + 1;
        if (symStd > 0 && status != 'A') {
            char affiliation = SymbolID2.charAt(1);
            switch (affiliation) {
                case 'A': 
                case 'G': 
                case 'M': 
                case 'P': 
                case 'S': {
                    ++returnVal;
                }
            }
        }
        if (SymbolUtilities.isSeaSurface(SymbolID2)) {
            returnVal = UnitFontLookup.getSeaSurfaceFrame(SymbolID2, FillCode);
        }
        if (SymbolUtilities.isSubSurface(SymbolID2)) {
            returnVal = UnitFontLookup.getSubSurfaceFrame(SymbolID2, FillCode, symStd);
        }
        return returnVal;
    }

    private static int getSeaSurfaceFill(String SymbolID2) {
        char affiliation = '\u0000';
        char status = '\u0000';
        boolean returnVal = false;
        try {
            affiliation = SymbolID2.charAt(1);
            status = SymbolID2.charAt(3);
            if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*S*O-----*****")) {
                return 2016;
            }
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                return 812;
            }
            if (affiliation == 'H' || affiliation == 'S') {
                return 806;
            }
            if (affiliation == 'N' || affiliation == 'L') {
                return 809;
            }
            if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                return 800;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getSeaSurfaceFill", exc);
            return 800;
        }
        return 800;
    }

    private static int getSubSurfaceFill(String SymbolID2, int symStd) {
        char affiliation = '\u0000';
        char status = '\u0000';
        int returnVal = 0;
        returnVal = 831;
        try {
            affiliation = SymbolID2.charAt(1);
            status = SymbolID2.charAt(3);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                returnVal = 831;
            } else if (affiliation == 'H' || affiliation == 'S') {
                returnVal = 828;
            } else if (affiliation == 'N' || affiliation == 'L') {
                returnVal = 834;
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                returnVal = 837;
            }
            if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                returnVal = status == 'A' ? (returnVal += 2) : ++returnVal;
            }
            if (symStd == 1) {
                if (SymbolID2.indexOf("WM") == 4 || SymbolID2.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*V-----*****")) {
                    ++returnVal;
                    if (status == 'A') {
                        ++returnVal;
                    }
                } else if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = 2121;
                }
            } else if (SymbolID2.indexOf("WM") == 4) {
                if (SymbolID2.indexOf("----", 6) == 6 || SymbolID2.indexOf("D---", 6) == 6) {
                    returnVal = 2059;
                } else if (SymbolID2.indexOf("G---", 6) == 6) {
                    returnVal = 2062;
                } else if (SymbolID2.indexOf("GD--", 6) == 6) {
                    returnVal = 2064;
                } else if (SymbolID2.indexOf("M---", 6) == 6) {
                    returnVal = 2073;
                } else if (SymbolID2.indexOf("MD--", 6) == 6) {
                    returnVal = 2075;
                } else if (SymbolID2.indexOf("F---", 6) == 6) {
                    returnVal = 2084;
                } else if (SymbolID2.indexOf("FD--", 6) == 6) {
                    returnVal = 2086;
                } else if (SymbolID2.indexOf("O---", 6) == 6 || SymbolID2.indexOf("OD--", 6) == 6) {
                    returnVal = 2094;
                }
            } else if (SymbolID2.indexOf("WDM") == 4) {
                returnVal = 2115;
            } else if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                returnVal = 2121;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFill", exc);
            return 837;
        }
        return returnVal;
    }

    private static int getSeaSurfaceFrame(String SymbolID2, int fillCode) {
        int returnVal = fillCode + 1;
        if (!SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*S*O-----*****")) {
            if (SymbolID2.charAt(3) == 'A' || SymbolID2.charAt(3) == 'a') {
                return fillCode + 2;
            }
            return fillCode + 1;
        }
        returnVal = -1;
        return returnVal;
    }

    private static int getSubSurfaceFrame(String SymbolID2, int fillCode, int symStd) {
        int returnVal;
        block11: {
            returnVal = 0;
            returnVal = 831;
            try {
                if (RendererSettings.getInstance().getSymbologyStandard() == 1) {
                    if (SymbolID2.indexOf("WM") == 4 || SymbolID2.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*V-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolID2.charAt(3) == 'A' || SymbolID2.charAt(3) == 'a') {
                        return fillCode + 2;
                    }
                    return fillCode + 1;
                }
                if (SymbolID2.indexOf("WM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID2.indexOf("WDM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID2.charAt(3) == 'A' || SymbolID2.charAt(3) == 'a') {
                    return fillCode + 2;
                }
                return fillCode + 1;
            }
            catch (Exception exc) {
                ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFrame", exc);
                return fillCode;
            }
        }
        return returnVal;
    }

    public UnitFontLookupInfo getLookupInfo(String SymbolID2) {
        return this.getLookupInfo(SymbolID2, RendererSettings.getInstance().getSymbologyStandard());
    }

    public UnitFontLookupInfo getLookupInfo(String SymbolID2, int symbologyStandard) {
        try {
            String code = SymbolUtilities.getBasicSymbolIDStrict(SymbolID2);
            UnitFontLookupInfo data = null;
            data = symbologyStandard == 0 ? hashMapB.get(code) : hashMapC.get(code);
            return data;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookup", "getLookupInfo(" + String.valueOf(SymbolID2) + ")", exc, Level.WARNING);
            return null;
        }
    }

    public static double getUnitRatioHeight(int charIndex) {
        int characterIndex = charIndex - 57000;
        if (characterIndex == 840 || characterIndex == 816 || characterIndex == 828 || characterIndex == 829 || characterIndex == 830 || characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839) {
            return 1.3;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44;
        }
        if (characterIndex == 812 || characterIndex == 843 || characterIndex == 819 || characterIndex == 831 || characterIndex == 832 || characterIndex == 833 || characterIndex == 812 || characterIndex == 812 || characterIndex == 846 || characterIndex == 822 || characterIndex == 834 || characterIndex == 835 || characterIndex == 836) {
            return 1.2;
        }
        if (characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809) {
            return 1.1;
        }
        if (characterIndex == 803 || characterIndex == 812) {
            return 1.0;
        }
        return 1.2;
    }

    public static double getUnitRatioWidth(int charIndex) {
        int characterIndex = charIndex - 57000;
        if (characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839 || characterIndex == 803 || characterIndex == 803) {
            return 1.5;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44;
        }
        if (characterIndex == 812 || characterIndex == 812 || characterIndex == 812) {
            return 1.2;
        }
        return 1.1;
    }

    static {
        hashMapB = new HashMap();
        hashMapC = new HashMap();
    }
}

