/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.SinglePointLookupInfo;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class SinglePointLookup {
    private static SinglePointLookup _instance;
    private boolean _ready = false;
    Map<String, SinglePointLookupInfo> hashMapB = new HashMap<String, SinglePointLookupInfo>();
    Map<String, SinglePointLookupInfo> hashMapC = new HashMap<String, SinglePointLookupInfo>();

    public boolean getReady() {
        return this._ready;
    }

    private SinglePointLookup() {
        this.init();
    }

    public static synchronized SinglePointLookup getInstance() {
        if (_instance == null) {
            _instance = new SinglePointLookup();
        }
        return _instance;
    }

    private void init() {
        this.xmlLoaded();
    }

    private void xmlLoaded() {
        String xmlPathB = "XML/SinglePointB.xml";
        String xmlPathC = "XML/SinglePointC.xml";
        InputStream xmlStreamB = this.getClass().getClassLoader().getResourceAsStream(xmlPathB);
        InputStream xmlStreamC = this.getClass().getClassLoader().getResourceAsStream(xmlPathC);
        String lookupXmlB = FileHandler.InputStreamToString(xmlStreamB);
        String lookupXmlC = FileHandler.InputStreamToString(xmlStreamC);
        this.populateLookup(lookupXmlB, 0);
        this.populateLookup(lookupXmlC, 1);
    }

    private void populateLookup(String xml, int symStd) {
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            SinglePointLookupInfo spli = null;
            String basicID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String description = XMLUtil.parseTagValue(data, "<DESCRIPTION>", "</DESCRIPTION>");
            String mappingP = XMLUtil.parseTagValue(data, "<MAPPINGP>", "</MAPPINGP>");
            String mappingA = XMLUtil.parseTagValue(data, "<MAPPINGA>", "</MAPPINGA>");
            String width = XMLUtil.parseTagValue(data, "<WIDTH>", "</WIDTH>");
            String height = XMLUtil.parseTagValue(data, "<HEIGHT>", "</HEIGHT>");
            mappingP = SinglePointLookup.checkMappingIndex(mappingP);
            mappingA = SinglePointLookup.checkMappingIndex(mappingA);
            spli = new SinglePointLookupInfo(basicID, description, mappingP, mappingA, width, height);
            if (symStd == 0) {
                this.hashMapB.put(basicID, spli);
                continue;
            }
            if (symStd != 1) continue;
            this.hashMapC.put(basicID, spli);
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            return String.valueOf(i + 57000);
        }
        return index;
    }

    public int getCharCodeFromSymbol(String symbolCode, int symStd) {
        try {
            String strSymbolLookup = symbolCode;
            Map<String, SinglePointLookupInfo> hashMap = null;
            if (symStd == 0) {
                hashMap = this.hashMapB;
            } else if (symStd == 1) {
                hashMap = this.hashMapC;
            }
            SinglePointLookupInfo spli = null;
            if (SymbolUtilities.isWeather(strSymbolLookup) || symbolCode.contains("FILL")) {
                spli = hashMap.get(strSymbolLookup);
                if (spli != null) {
                    return spli.getMappingP();
                }
                return -1;
            }
            if (!hashMap.containsKey(strSymbolLookup)) {
                strSymbolLookup = SymbolUtilities.getBasicSymbolID(strSymbolLookup);
            }
            if ((spli = hashMap.get(strSymbolLookup)) != null) {
                if (SymbolUtilities.getStatus(symbolCode).equals("A")) {
                    return spli.getMappingA();
                }
                return spli.getMappingP();
            }
            return -1;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointLookup", "getCharCodeFromSymbol", exc, Level.WARNING);
            return -1;
        }
    }

    public SinglePointLookupInfo getSPLookupInfo(String basicSymbolID, int symStd) {
        SinglePointLookupInfo spli = null;
        if (symStd == 0) {
            spli = this.hashMapB.get(basicSymbolID);
        } else if (symStd == 1) {
            spli = this.hashMapC.get(basicSymbolID);
        }
        return spli;
    }
}

