/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MilStdSymbol {
    private Map<String, String> _Properties = null;
    private ArrayList<Double> _X_Altitude = null;
    private ArrayList<Double> _AM_Distance = null;
    private ArrayList<Double> _AN_Azimuth = null;
    private String _symbolID = "";
    private String _UUID = null;
    private ArrayList<ShapeInfo> _SymbolShapes;
    private ArrayList<ShapeInfo> _ModifierShapes;
    private ArrayList<Point2D.Double> _Coordinates;
    private int _UnitSize = 0;
    private double _scale = 0.0;
    private Boolean _KeepUnitRatio = true;
    Integer _LineWidth = 3;
    Color _IconColor = null;
    Color _LineColor = null;
    Color _FillColor = null;
    Color _TextColor = null;
    Color _TextBackgroundColor = null;
    TexturePaint _FillStyle = null;
    int _PatternFillType = 0;
    boolean _usePatternFill = false;
    double _Rotation = 0.0;
    boolean _Outline = false;
    Color _OutLineColor = null;
    int _OutLineWidth = 0;
    private boolean isPluginSymbol = false;
    public static final int Symbology_2525Bch2_USAS_13_14 = 0;
    public static final int Symbology_2525C = 1;
    private static int _SymbologyStandard = 0;
    private static String _AltitudeMode = "";
    private static boolean _HideOptionalLabels = false;
    private static boolean _UseDashArray = true;
    private static boolean _DrawAffiliationModifierAsLabel = true;
    private static boolean _UseLineInterpolation = false;
    private boolean _wasClipped = false;
    Object _Tag = null;

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D.Double> Coordinates, Map<String, String> modifiers) {
        this(symbolID, uniqueID, Coordinates, modifiers, true);
    }

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D.Double> Coordinates, Map<String, String> modifiers, Boolean keepUnitRatio) {
        this._Properties = modifiers == null ? new HashMap<String, String>() : modifiers;
        if (this._Properties.containsKey("RENDERER") || this._Properties.containsKey("RENDERER".toLowerCase())) {
            this.isPluginSymbol = true;
        }
        this._UUID = uniqueID;
        this.setCoordinates(Coordinates);
        this.setSymbolID(symbolID);
        this.setLineColor(SymbolUtilities.getLineColorOfAffiliation(this._symbolID));
        if (SymbolUtilities.hasDefaultFill(this._symbolID)) {
            this.setFillColor(SymbolUtilities.getFillColorOfAffiliation(this._symbolID));
        }
        this.setKeepUnitRatio(keepUnitRatio);
        this.setSymbologyStandard(RendererSettings.getInstance().getSymbologyStandard());
        _DrawAffiliationModifierAsLabel = RendererSettings.getInstance().getDrawAffiliationModifierAsLabel();
        _UseLineInterpolation = RendererSettings.getInstance().getUseLineInterpolation();
        int outlineWidth = RendererSettings.getInstance().getSinglePointSymbolOutlineWidth();
        if (outlineWidth > 0 && SymbolUtilities.isTacticalGraphic(symbolID)) {
            this.setOutlineEnabled(true, outlineWidth);
            this.setOutlineColor(SymbolDraw.getIdealTextBackgroundColor(this._LineColor));
        }
    }

    public void setSymbologyStandard(int standard) {
        _SymbologyStandard = standard;
    }

    public int getSymbologyStandard() {
        return _SymbologyStandard;
    }

    public String getAltitudeMode() {
        return _AltitudeMode;
    }

    public void setAltitudeMode(String value) {
        _AltitudeMode = value;
    }

    public boolean getUseDashArray() {
        return _UseDashArray;
    }

    public void setUseDashArray(boolean value) {
        _UseDashArray = value;
    }

    public boolean getHideOptionalLabels() {
        return _HideOptionalLabels;
    }

    public void setHideOptionalLabels(boolean value) {
        _HideOptionalLabels = value;
    }

    public void setUseLineInterpolation(boolean value) {
        _UseLineInterpolation = value;
    }

    public boolean getUseLineInterpolation() {
        return _UseLineInterpolation;
    }

    public void setDrawAffiliationModifierAsLabel(boolean value) {
        _DrawAffiliationModifierAsLabel = value;
    }

    public boolean getDrawAffiliationModifierAsLabel() {
        return _DrawAffiliationModifierAsLabel;
    }

    public Map<String, String> getModifierMap() {
        return this._Properties;
    }

    public void setModifierMap(Map<String, String> modifiers) {
        this._Properties = modifiers;
    }

    public String getModifier(String modifier) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        return this.getModifier(modifier, 0);
    }

    public void setModifier(String modifier, String value) {
        if (!value.equals("")) {
            if (!modifier.equalsIgnoreCase("AM") && !modifier.equalsIgnoreCase("AN") && !modifier.equalsIgnoreCase("X") || this.getSymbolID().charAt(0) == 'W') {
                this._Properties.put(modifier, value);
            } else {
                this.setModifier(modifier, value, 0);
            }
        }
    }

    public String getModifier(String modifier, int index) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        if (modifier.equalsIgnoreCase("AM") || modifier.equalsIgnoreCase("AN") || modifier.equalsIgnoreCase("X")) {
            String value = String.valueOf(this.getModifier_AM_AN_X(modifier, index));
            if (value != null && !value.equalsIgnoreCase("null") && !value.equalsIgnoreCase("")) {
                return value;
            }
            return null;
        }
        return null;
    }

    public Double getModifier_AM_AN_X(String modifier, int index) {
        ArrayList<Double> modifiers = null;
        if (modifier.equalsIgnoreCase("AM")) {
            modifiers = this._AM_Distance;
        } else if (modifier.equalsIgnoreCase("AN")) {
            modifiers = this._AN_Azimuth;
        } else if (modifier.equalsIgnoreCase("X")) {
            modifiers = this._X_Altitude;
        } else {
            return null;
        }
        if (modifiers != null && modifiers.size() > index) {
            Double value = null;
            value = modifiers.get(index);
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    public void setModifier(String modifier, String value, int index) {
        if (!value.equals("")) {
            if (!(modifier.equalsIgnoreCase("AM") || modifier.equalsIgnoreCase("AN") || modifier.equalsIgnoreCase("X"))) {
                this._Properties.put(modifier, value);
            } else {
                Double dblValue = Double.valueOf(value);
                if (dblValue != null) {
                    this.setModifier_AM_AN_X(modifier, dblValue, index);
                }
            }
        }
    }

    public void setModifier_AM_AN_X(String modifier, Double value, int index) {
        if (modifier.equalsIgnoreCase("AM") || modifier.equalsIgnoreCase("AN") || modifier.equalsIgnoreCase("X")) {
            ArrayList<Double> modifiers = null;
            if (modifier.equalsIgnoreCase("AM")) {
                if (this._AM_Distance == null) {
                    this._AM_Distance = new ArrayList();
                }
                modifiers = this._AM_Distance;
            } else if (modifier.equalsIgnoreCase("AN")) {
                if (this._AN_Azimuth == null) {
                    this._AN_Azimuth = new ArrayList();
                }
                modifiers = this._AN_Azimuth;
            } else if (modifier.equalsIgnoreCase("X")) {
                if (this._X_Altitude == null) {
                    this._X_Altitude = new ArrayList();
                }
                modifiers = this._X_Altitude;
            }
            if (index + 1 > modifiers.size()) {
                modifiers.add(value);
            } else {
                modifiers.set(index, value);
            }
        }
    }

    public ArrayList<Double> getModifiers_AM_AN_X(String modifier) {
        if (modifier.equalsIgnoreCase("AM")) {
            return this._AM_Distance;
        }
        if (modifier.equalsIgnoreCase("AN")) {
            return this._AN_Azimuth;
        }
        if (modifier.equalsIgnoreCase("X")) {
            return this._X_Altitude;
        }
        return null;
    }

    public void setModifiers_AM_AN_X(String modifier, ArrayList<Double> modifiers) {
        if (modifier.equalsIgnoreCase("AM")) {
            this._AM_Distance = modifiers;
        } else if (modifier.equalsIgnoreCase("AN")) {
            this._AN_Azimuth = modifiers;
        } else if (modifier.equalsIgnoreCase("X")) {
            this._X_Altitude = modifiers;
        }
    }

    public void setFillColor(Color value) {
        this._FillColor = value;
    }

    public Color getFillColor() {
        return this._FillColor;
    }

    public void setTextColor(Color value) {
        this._TextColor = value;
    }

    public Color getTextColor() {
        return this._TextColor;
    }

    public void setTextBackgroundColor(Color value) {
        this._TextBackgroundColor = value;
    }

    public Color getTextBackgroundColor() {
        return this._TextBackgroundColor;
    }

    public void setFillStyle(TexturePaint value) {
        this._FillStyle = value;
    }

    public TexturePaint getFillStyle() {
        return this._FillStyle;
    }

    public void setPatternFillType(int value) {
        this._PatternFillType = value;
    }

    public int getPatternFillType() {
        return this._PatternFillType;
    }

    public void setUsePatternFill(boolean value) {
        this._usePatternFill = value;
    }

    public boolean getUsePatternFill() {
        return this._usePatternFill;
    }

    public void setLineWidth(int value) {
        this._LineWidth = value;
    }

    public int getLineWidth() {
        return this._LineWidth;
    }

    public void setLineColor(Color value) {
        this._LineColor = value;
    }

    public Color getLineColor() {
        return this._LineColor;
    }

    public void setIconColor(Color value) {
        this._IconColor = value;
    }

    public Color getIconColor() {
        return this._IconColor;
    }

    public void setOutlineEnabled(boolean value) {
        this._Outline = value;
        this._OutLineWidth = value ? 1 : 0;
        if (this._OutLineColor == null) {
            this._OutLineColor = SymbolDraw.getIdealTextBackgroundColor(this._LineColor);
        }
    }

    public void setOutlineEnabled(boolean value, int width) {
        this._Outline = value;
        if (width > 0) {
            this._OutLineWidth = width;
        }
        if (this._OutLineColor == null) {
            this._OutLineColor = SymbolDraw.getIdealTextBackgroundColor(this._LineColor);
        }
    }

    public boolean getOutlineEnabled() {
        return this._Outline;
    }

    public int getOutlineWidth() {
        return this._OutLineWidth;
    }

    public void setOutlineColor(Color value) {
        this._OutLineColor = value;
    }

    public Color getOutlineColor() {
        return this._OutLineColor;
    }

    public void setRotation(double value) {
        this._Rotation = value;
    }

    public double getRotation() {
        return this._Rotation;
    }

    public void setTag(Object value) {
        this._Tag = value;
    }

    public Object getTag() {
        return this._Tag;
    }

    public void setCoordinates(ArrayList<Point2D.Double> value) {
        this._Coordinates = value;
    }

    public ArrayList<Point2D.Double> getCoordinates() {
        return this._Coordinates;
    }

    public void setModifierShapes(ArrayList<ShapeInfo> value) {
        this._ModifierShapes = value;
    }

    public ArrayList<ShapeInfo> getModifierShapes() {
        return this._ModifierShapes;
    }

    public void setSymbolShapes(ArrayList<ShapeInfo> value) {
        this._SymbolShapes = value;
    }

    public ArrayList<ShapeInfo> getSymbolShapes() {
        return this._SymbolShapes;
    }

    public String getSymbolID() {
        return this._symbolID;
    }

    public String getUUID() {
        return this._UUID;
    }

    public void setUUID(String ID) {
        this._UUID = ID;
    }

    public void setSymbolID(String value) {
        if (!this.isPluginSymbol) {
            String current = this._symbolID;
            try {
                String basicID;
                if (value != null && !value.equals("") && !current.equals(value)) {
                    this._symbolID = value;
                }
                if (SymbolUtilities.getAffiliation(value).equals("H") && (SymbolUtilities.isObstacle(basicID = SymbolUtilities.getBasicSymbolID(value)) || basicID.equals("G*M*NZ----****X") || basicID.equals("G*M*NEB---****X") || basicID.equals("G*M*NEC---****X"))) {
                    this.setModifier("N", "ENY");
                }
            }
            catch (Exception e) {
                ErrorLogger.LogException("MilStdSymbol", "setSymbolID - Did not fall under TG or FE", e);
            }
        } else {
            this._symbolID = value;
        }
    }

    private Map getSegmentData() {
        return null;
    }

    private void setSegmentData(Map value) {
    }

    public Rectangle getSymbolExtent() {
        Rectangle bounds = null;
        Rectangle temp = null;
        if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
            if (SymbolUtilities.isWarfighting(this._symbolID)) {
                int i;
                for (i = 0; i < this._SymbolShapes.size(); ++i) {
                    if (this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_FILL && this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_FRAME && this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_OUTLINE) continue;
                    if (bounds == null) {
                        bounds = this._SymbolShapes.get(i).getBounds();
                        continue;
                    }
                    temp = this._SymbolShapes.get(i).getBounds();
                    bounds = bounds.union(temp);
                }
                if (bounds == null) {
                    for (i = 0; i < this._SymbolShapes.size(); ++i) {
                        if (this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL1 && this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL2) continue;
                        bounds = bounds == null ? this._SymbolShapes.get(i).getBounds() : bounds.union(this._SymbolShapes.get(i).getBounds());
                    }
                }
            } else if (SymbolUtilities.isTacticalGraphic(this._symbolID)) {
                for (int i = 0; i < this._SymbolShapes.size(); ++i) {
                    if (this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_TG_SP_FRAME && this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_TG_SP_FILL && this._SymbolShapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE) continue;
                    if (bounds == null) {
                        bounds = this._SymbolShapes.get(i).getBounds();
                        continue;
                    }
                    temp = this._SymbolShapes.get(i).getBounds();
                    bounds = bounds.union(temp);
                }
            } else {
                bounds = this._SymbolShapes.get(0).getBounds();
            }
        }
        return bounds;
    }

    public Rectangle getSymbolExtentWithDisplayModifiers() {
        Rectangle bounds = null;
        if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
            bounds = this._SymbolShapes.get(0).getBounds();
            int symbolCount = this._SymbolShapes.size();
            for (int lcv = 1; lcv < symbolCount; ++lcv) {
                bounds = bounds.union(this._SymbolShapes.get(lcv).getBounds());
            }
        }
        return bounds;
    }

    public Rectangle getSymbolExtentFull() {
        Rectangle bounds = null;
        Rectangle temp = null;
        ShapeInfo siTemp = null;
        int lineWidth = 0;
        try {
            if (this._LineWidth > 0) {
                lineWidth = this._LineWidth;
            }
            if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
                siTemp = this._SymbolShapes.get(0);
                bounds = siTemp.getBounds();
                Object sTemp = null;
                int symbolCount = this._SymbolShapes.size();
                for (int lcv = 1; lcv < symbolCount; ++lcv) {
                    siTemp = this._SymbolShapes.get(lcv);
                    temp = siTemp.getBounds();
                    bounds = bounds.union(temp);
                }
            }
            if (this._ModifierShapes != null && this._ModifierShapes.size() > 0) {
                int symbolCount2 = this._ModifierShapes.size();
                for (int lcv2 = 0; lcv2 < symbolCount2; ++lcv2) {
                    temp = this._ModifierShapes.get(lcv2).getBounds();
                    bounds = bounds.union(temp);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdSymbol", "getFullSymbolExtent", exc);
        }
        return bounds;
    }

    public Rectangle getPictureExtent() {
        Rectangle bounds = null;
        Rectangle temp = null;
        try {
            if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
                bounds = this._SymbolShapes.get(0).getBounds();
                int symbolCount = this._SymbolShapes.size();
                for (int lcv = 1; lcv < symbolCount; ++lcv) {
                    temp = this._SymbolShapes.get(lcv).getBounds();
                    bounds = bounds.union(temp);
                }
            }
            if (this._ModifierShapes != null && this._ModifierShapes.size() > 0) {
                int symbolCount2 = this._ModifierShapes.size();
                for (int lcv2 = 0; lcv2 < symbolCount2; ++lcv2) {
                    temp = this._ModifierShapes.get(lcv2).getBounds();
                    bounds = bounds.union(temp);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdSymbol", "getFullSymbolExtent", exc);
        }
        return bounds;
    }

    public Boolean HitTest(Point2D point) {
        Rectangle2D.Double rect = null;
        double hitBuffer = 0.0;
        try {
            if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
                Shape symbol = null;
                BasicStroke sTemp = null;
                int symbolCount = this._SymbolShapes.size();
                if (symbolCount > 0) {
                    ShapeInfo siTemp = null;
                    for (int lcv = 0; lcv < symbolCount; ++lcv) {
                        siTemp = this._SymbolShapes.get(lcv);
                        if (siTemp.getStroke() instanceof BasicStroke) {
                            sTemp = (BasicStroke)siTemp.getStroke();
                        }
                        if (sTemp != null) {
                            hitBuffer = sTemp.getLineWidth();
                            rect = new Rectangle2D.Double(point.getX() - hitBuffer, point.getY() - hitBuffer, hitBuffer + hitBuffer, hitBuffer + hitBuffer);
                        } else {
                            rect = new Rectangle2D.Double(point.getX() - 4.0, point.getY() - 4.0, 8.0, 8.0);
                        }
                        if (siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_TG_SP_FRAME || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_TG_SP_FILL || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_UNIT_FILL || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_UNIT_FRAME || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL1 || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL2 || siTemp.getShapeType() == ShapeInfo.SHAPE_TYPE_POLYLINE && this._FillColor != null && this._FillColor.getAlpha() > 150) {
                            if (siTemp.getShape() != null) {
                                symbol = siTemp.getShape();
                                if (siTemp.getAffineTransform() != null) {
                                    symbol = siTemp.getAffineTransform().createTransformedShape(symbol);
                                }
                            } else {
                                symbol = siTemp.getBounds();
                            }
                            if (!symbol.intersects(rect)) continue;
                            return true;
                        }
                        if (siTemp.getShapeType() != ShapeInfo.SHAPE_TYPE_POLYLINE) continue;
                        if (siTemp.getShape() != null) {
                            symbol = siTemp.getShape();
                            if (siTemp.getAffineTransform() != null) {
                                symbol = siTemp.getAffineTransform().createTransformedShape(symbol);
                            }
                        } else {
                            symbol = siTemp.getBounds();
                        }
                        Path2D gp = null;
                        if (symbol instanceof Path2D) {
                            gp = (Path2D)symbol;
                            PathIterator itr = gp.getPathIterator(null);
                            double[] coords = new double[6];
                            itr.currentSegment(coords);
                            Point2D.Double start = new Point2D.Double(coords[0], coords[1]);
                            while (!itr.isDone()) {
                                itr.currentSegment(coords);
                                itr.next();
                            }
                            Point2D.Double end = new Point2D.Double(coords[0], coords[1]);
                            itr = null;
                            itr = gp.getPathIterator(null);
                            if (symbol.intersects(rect) && !symbol.contains(rect)) {
                                if (start.equals(end)) {
                                    return true;
                                }
                                Line2D.Double tempLine = new Line2D.Double(start, end);
                                if (tempLine.intersects(rect) && !tempLine.contains(rect)) {
                                    return false;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (!symbol.intersects(rect) || symbol.contains(rect)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdSymbol", "HitTest", exc);
        }
        return false;
    }

    public void setUnitSize(int size) {
        this._UnitSize = size;
    }

    public int getUnitSize() {
        return this._UnitSize;
    }

    public void setScale(double scale) {
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setKeepUnitRatio(Boolean value) {
        this._KeepUnitRatio = value;
    }

    public Boolean getKeepUnitRatio() {
        return this._KeepUnitRatio;
    }

    public void set_WasClipped(boolean value) {
        this._wasClipped = value;
    }

    public boolean get_WasClipped() {
        return this._wasClipped;
    }

    public ImageInfo toImageInfo() {
        ImageInfo returnVal = null;
        returnVal = this.ConvertShapesToImageInfo(2, false);
        return returnVal;
    }

    public ImageInfo toImageInfo(int type) {
        ImageInfo returnVal = null;
        returnVal = this.ConvertShapesToImageInfo(type, false);
        return returnVal;
    }

    public ImageInfo toImageInfo(int type, Boolean addBuffer) {
        ImageInfo returnVal = null;
        returnVal = this.ConvertShapesToImageInfo(type, addBuffer);
        return returnVal;
    }

    public ImageInfo toImageInfo(Boolean addBuffer) {
        ImageInfo returnVal = null;
        returnVal = this.ConvertShapesToImageInfo(2, addBuffer);
        return returnVal;
    }

    private ImageInfo ConvertShapesToImageInfo(int type, Boolean addBuffer) {
        ImageInfo returnVal = null;
        int widthBuffer = 0;
        int heightBuffer = 0;
        int offsetX = 0;
        int offsetY = 0;
        try {
            Graphics2D g2d;
            if (this._SymbolShapes != null && this._SymbolShapes.size() > 0) {
                Rectangle bounds = null;
                Rectangle boundsFull = null;
                bounds = this.getSymbolExtent();
                boundsFull = this.getSymbolExtentFull();
                if (addBuffer.booleanValue()) {
                    widthBuffer += 2;
                    heightBuffer += 2;
                    ++offsetX;
                    ++offsetY;
                }
                if (SymbolUtilities.isMobility(this._symbolID)) {
                    widthBuffer += 4;
                    heightBuffer += 2;
                    offsetX += 2;
                    offsetY += 0;
                }
                BufferedImage image = new BufferedImage(Math.round(boundsFull.width) + widthBuffer, Math.round(boundsFull.height) + heightBuffer, type);
                g2d = image.createGraphics();
                int newX = boundsFull.x - offsetX;
                int newY = boundsFull.y - offsetY;
                SymbolDraw.Draw(this, g2d, -newX, -newY);
                int centerX = 0;
                int centerY = 0;
                if (SymbolUtilities.isWarfighting(this._symbolID)) {
                    if (SymbolUtilities.isHQ(this._symbolID) && RendererSettings.getInstance().getCenterOnHQStaff().booleanValue()) {
                        centerX = bounds.x - boundsFull.x;
                        String affiliation = this.getSymbolID().substring(1, 2);
                        centerY = affiliation.equals("F") || affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("J") || affiliation.equals("K") || affiliation.equals("N") || affiliation.equals("L") ? (int)((double)(bounds.y - boundsFull.y + bounds.height / 2) + (double)bounds.height * 1.5) : bounds.y - boundsFull.y + bounds.height / 2 + bounds.height;
                    } else {
                        centerX = offsetX + bounds.x - boundsFull.x + bounds.width / 2;
                        centerY = offsetY + bounds.y - boundsFull.y + bounds.height / 2;
                    }
                    returnVal = new ImageInfo(image, newX, newY, centerX, centerY, new Rectangle2D.Double(bounds.getX() - (double)newX, bounds.getY() - (double)newY, bounds.getWidth(), bounds.getHeight()));
                } else {
                    ShapeInfo temp = null;
                    for (int i = 0; i < this._SymbolShapes.size(); ++i) {
                        temp = this._SymbolShapes.get(i);
                        if (temp.getShapeType() != ShapeInfo.SHAPE_TYPE_TG_SP_FRAME) continue;
                        i = this._SymbolShapes.size();
                    }
                    Boolean isMultiPoint = false;
                    if (temp.getGlyphPosition() != null) {
                        centerX = offsetX + (int)temp.getGlyphPosition().getX() - boundsFull.x;
                        centerY = offsetY + (int)temp.getGlyphPosition().getY() - boundsFull.y;
                    } else {
                        centerX = offsetX + (int)boundsFull.getWidth() / 2;
                        centerY = offsetY + (int)boundsFull.getHeight() / 2;
                        isMultiPoint = true;
                    }
                    if (isMultiPoint.booleanValue()) {
                        bounds = boundsFull;
                    }
                    returnVal = new ImageInfo(image, newX, newY, centerX, centerY, new Rectangle2D.Double(bounds.getX() - (double)newX, bounds.getY() - (double)newY, bounds.getWidth(), bounds.getHeight()));
                }
            } else {
                return null;
            }
            g2d.dispose();
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdSymbol", "ConvertShapesToImageInfo()", exc);
        }
        return returnVal;
    }
}

