/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.api;

import io.github.mightguy.spellcheck.symspell.api.DataHolder;
import io.github.mightguy.spellcheck.symspell.api.StringDistance;
import io.github.mightguy.spellcheck.symspell.common.Composition;
import io.github.mightguy.spellcheck.symspell.common.SpellCheckSettings;
import io.github.mightguy.spellcheck.symspell.common.SuggestionItem;
import io.github.mightguy.spellcheck.symspell.common.Verbosity;
import io.github.mightguy.spellcheck.symspell.exception.SpellCheckException;
import java.util.List;

public abstract class SpellChecker {
    protected DataHolder dataHolder;
    protected StringDistance stringDistance;
    protected SpellCheckSettings spellCheckSettings;

    public List<SuggestionItem> lookup(String word) throws SpellCheckException {
        return this.lookup(word, this.spellCheckSettings.getVerbosity(), this.spellCheckSettings.getMaxEditDistance());
    }

    public List<SuggestionItem> lookup(String word, Verbosity verbosity) throws SpellCheckException {
        return this.lookup(word, verbosity, this.spellCheckSettings.getMaxEditDistance());
    }

    public abstract List<SuggestionItem> lookup(String var1, Verbosity var2, double var3) throws SpellCheckException;

    public List<SuggestionItem> lookupCompound(String word) throws SpellCheckException {
        return this.lookupCompound(word, this.spellCheckSettings.getMaxEditDistance());
    }

    public abstract List<SuggestionItem> lookupCompound(String var1, double var2, boolean var4) throws SpellCheckException;

    public List<SuggestionItem> lookupCompound(String word, double editDistance) throws SpellCheckException {
        return this.lookupCompound(word, editDistance, true);
    }

    public Composition wordBreakSegmentation(String phrase) throws SpellCheckException {
        return this.wordBreakSegmentation(phrase, this.spellCheckSettings.getPrefixLength(), this.spellCheckSettings.getMaxEditDistance());
    }

    public Composition wordBreakSegmentation(String phrase, Double ed) throws SpellCheckException {
        return this.wordBreakSegmentation(phrase, this.spellCheckSettings.getPrefixLength(), ed);
    }

    public abstract Composition wordBreakSegmentation(String var1, int var2, double var3) throws SpellCheckException;

    public SpellChecker(DataHolder dataHolder, StringDistance stringDistance, SpellCheckSettings spellCheckSettings) {
        this.dataHolder = dataHolder;
        this.stringDistance = stringDistance;
        this.spellCheckSettings = spellCheckSettings;
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    public StringDistance getStringDistance() {
        return this.stringDistance;
    }

    public SpellCheckSettings getSpellCheckSettings() {
        return this.spellCheckSettings;
    }
}

