/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.XmlErrorHandler;
import io.github.microcks.util.XmlSchemaURLResolver;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

public class XmlSchemaValidator {
    private XmlSchemaValidator() {
    }

    public static List<String> validateXml(InputStream schemaStream, String xmlString) throws Exception {
        return XmlSchemaValidator.validateXml(schemaStream, xmlString, null);
    }

    public static List<String> validateXml(InputStream schemaStream, String xmlString, String baseResourceUrl) throws Exception {
        SchemaFactory factory = SchemaFactory.newDefaultInstance();
        factory.setResourceResolver(new XmlSchemaURLResolver(baseResourceUrl));
        StreamSource schemaFile = new StreamSource(schemaStream);
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        XmlErrorHandler errorHandler = new XmlErrorHandler();
        validator.setErrorHandler(errorHandler);
        validator.validate(new StreamSource(new StringReader(xmlString)));
        return errorHandler.getExceptions().stream().map(e -> "line " + e.getLineNumber() + ": " + e.getMessage()).toList();
    }
}

