/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaValidator.class);
    public static final String JSON_V4_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-04/schema#";
    public static final String JSON_V7_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-07/schema#";
    public static final String JSON_V12_SCHEMA_IDENTIFIER = "http://json-schema.org/draft/2020-12/schema#";
    public static final String JSON_SCHEMA_IDENTIFIER_ELEMENT = "$schema";
    public static final String JSON_SCHEMA_COMPONENTS_ELEMENT = "components";
    public static final String JSON_SCHEMA_PROPERTIES_ELEMENT = "properties";
    public static final String JSON_SCHEMA_REQUIRED_ELEMENT = "required";
    public static final String JSON_SCHEMA_ITEMS_ELEMENT = "items";
    public static final String JSON_SCHEMA_ADD_PROPERTIES_ELEMENT = "additionalProperties";
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).enable(SerializationFeature.INDENT_OUTPUT);

    private JsonSchemaValidator() {
    }

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        return JsonSchemaValidator.isJsonValid(schemaText, jsonText, null);
    }

    public static boolean isJsonValid(String schemaText, String jsonText, String namespace) throws IOException {
        List<String> errors = JsonSchemaValidator.validateJson(schemaText, jsonText, namespace);
        if (!errors.isEmpty()) {
            log.debug("Get validation errors, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException {
        return JsonSchemaValidator.validateJson(JsonSchemaValidator.getJsonNode(schemaText), JsonSchemaValidator.getJsonNode(jsonText), null);
    }

    public static List<String> validateJson(String schemaText, String jsonText, String namespace) throws IOException {
        return JsonSchemaValidator.validateJson(JsonSchemaValidator.getJsonNode(schemaText), JsonSchemaValidator.getJsonNode(jsonText), namespace);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        return JsonSchemaValidator.validateJson(schemaNode, jsonNode, null);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode, String namespace) {
        ArrayList<String> errors = new ArrayList<String>();
        JsonSchema jsonSchemaNode = JsonSchemaValidator.extractJsonSchemaNode(schemaNode, namespace);
        Set messages = jsonSchemaNode.validate(jsonNode, executionContext -> {
            executionContext.getExecutionConfig().setFormatAssertionsEnabled(Boolean.valueOf(true));
            executionContext.getExecutionConfig().setLocale(Locale.US);
        });
        if (!messages.isEmpty()) {
            for (ValidationMessage message : messages) {
                errors.add(message.getError());
            }
        }
        return errors;
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return mapper.readTree(jsonText);
    }

    public static JsonSchema getSchemaNode(String schemaText) throws IOException {
        JsonNode schemaNode = JsonSchemaValidator.getJsonNode(schemaText);
        return JsonSchemaValidator.extractJsonSchemaNode(schemaNode, null);
    }

    private static JsonSchema extractJsonSchemaNode(JsonNode jsonNode, String namespace) {
        JsonMetaSchema jsonMetaSchema = JsonMetaSchema.builder((JsonMetaSchema)JsonMetaSchema.getV202012()).build();
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.metaSchema(jsonMetaSchema));
        if (namespace != null) {
            URI baseUri = URI.create(namespace);
            return jsonSchemaFactory.getSchema(baseUri, jsonNode);
        }
        return jsonSchemaFactory.getSchema(jsonNode);
    }
}

