/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidHttpCodesAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(ValidHttpCodesAssertion.class);
    public static final String CODES_PARAM = "codes";
    private String codes = "200,";
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
        if (configParams.containsKey(CODES_PARAM)) {
            this.codes = configParams.get(CODES_PARAM);
            if (!this.codes.endsWith(",")) {
                this.codes = this.codes + ",";
            }
        }
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting response Http codes in {}", (Object)this.codes);
        String responseCode = null;
        try {
            responseCode = String.valueOf(exchange.response().getStatusCode().value());
            log.debug("Response status code : " + responseCode);
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            return AssertionStatus.FAILED;
        }
        if (!this.codes.contains(responseCode + ",")) {
            this.errorMessage = "Response status code:" + responseCode + " is not in acceptable list of status codes";
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

