/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.util.MalformedXmlException;
import io.github.microcks.util.soapui.SoapUIProjectParserUtils;
import io.github.microcks.util.soapui.assertions.AssertionFactory;
import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import io.github.microcks.util.test.HttpTestRunner;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SoapUIAssertionsTestRunner
extends HttpTestRunner {
    private static Logger log = LoggerFactory.getLogger(SoapUIAssertionsTestRunner.class);
    private String resourceUrl = null;
    private ResourceRepository resourceRepository;
    private Map<ResourceType, Resource> cachedResources = new HashMap<ResourceType, Resource>();
    private Element projectElement;
    private DocumentBuilder documentBuilder;
    private List<String> lastValidationErrors = null;
    private long startTimestamp;

    public SoapUIAssertionsTestRunner(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return super.buildMethod(method);
    }

    @Override
    protected void prepareRequest(Request request) {
        this.startTimestamp = System.currentTimeMillis();
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        long duration = System.currentTimeMillis() - this.startTimestamp;
        int code = 0;
        if (this.cachedResources.isEmpty()) {
            List<Resource> resources = this.resourceRepository.findByServiceId(service.getId());
            for (Resource resource : resources) {
                this.cachedResources.put(resource.getType(), resource);
            }
        }
        if (this.projectElement == null) {
            Resource soapuiProject = this.cachedResources.get(ResourceType.SOAP_UI_PROJECT);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.documentBuilder = factory.newDocumentBuilder();
                this.projectElement = this.documentBuilder.parse(new InputSource(new StringReader(soapuiProject.getContent()))).getDocumentElement();
            }
            catch (Exception e) {
                log.error("Exception while parsing SoapUI resource content {}", (Object)soapuiProject.getName(), (Object)e);
                return 1;
            }
        }
        try {
            Map<String, Element> testConfigRequests = this.collectTestStepsConfigRequest(operation);
            Element testRequest = testConfigRequests.get(request.getName());
            List<Element> assertions = SoapUIProjectParserUtils.getConfigDirectChildren(testRequest, "assertion");
            for (Element assertion : assertions) {
                Map<String, String> configParams;
                String type = assertion.getAttribute("type");
                SoapUIAssertion sAssertion = AssertionFactory.intializeAssertion(type, configParams = this.buildParamsMapFromConfiguration(assertion));
                AssertionStatus status = sAssertion.assertResponse(new RequestResponseExchange(request, httpResponse, responseContent, duration), new ExchangeContext(service, operation, List.copyOf(this.cachedResources.values()), this.resourceUrl));
                if (status != AssertionStatus.FAILED) continue;
                code = 1;
                if (this.lastValidationErrors == null) {
                    this.lastValidationErrors = new ArrayList<String>();
                }
                this.lastValidationErrors.addAll(sAssertion.getErrorMessages());
            }
        }
        catch (MalformedXmlException e) {
            log.error("Exception while parsing SoapUI resource content for assertion on {}", (Object)operation.getName(), (Object)e);
            return 1;
        }
        return code;
    }

    @Override
    protected String extractTestReturnMessage(Service service, Operation operation, Request request, ClientHttpResponse httpResponse) {
        StringBuilder builder = new StringBuilder();
        if (this.lastValidationErrors != null && !this.lastValidationErrors.isEmpty()) {
            for (String error : this.lastValidationErrors) {
                builder.append(error).append('\n');
            }
        }
        this.lastValidationErrors = null;
        return builder.toString();
    }

    private Map<String, Element> collectTestStepsConfigRequest(Operation operation) throws MalformedXmlException {
        HashMap<String, Element> results = new HashMap<String, Element>();
        List<Element> testSuites = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, "testSuite");
        for (Element testSuite : testSuites) {
            List<Element> testCases = SoapUIProjectParserUtils.getConfigDirectChildren(testSuite, "testCase");
            for (Element testCase : testCases) {
                List<Element> testSteps = SoapUIProjectParserUtils.getConfigDirectChildren(testCase, "testStep");
                for (Element testStep : testSteps) {
                    Element config = SoapUIProjectParserUtils.getConfigUniqueDirectChild(testStep, "config");
                    String operationName = null;
                    if (SoapUIProjectParserUtils.hasConfigDirectChild(config, "operation")) {
                        operationName = SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "operation").getTextContent();
                        if (!operation.getName().equals(operationName)) continue;
                        results.put(testStep.getAttribute("name"), SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "request"));
                        continue;
                    }
                    if (!config.hasAttribute("resourcePath")) continue;
                    operationName = config.getAttribute("resourcePath");
                    if (!operation.getName().equals(operationName)) continue;
                    results.put(testStep.getAttribute("name"), SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "restRequest"));
                }
            }
        }
        return results;
    }

    private Map<String, String> buildParamsMapFromConfiguration(Element assertion) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (SoapUIProjectParserUtils.hasConfigDirectChild(assertion, "configuration")) {
            try {
                Element configuration = SoapUIProjectParserUtils.getConfigUniqueDirectChild(assertion, "configuration");
                NodeList children = configuration.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    params.put(child.getLocalName(), child.getTextContent());
                }
            }
            catch (MalformedXmlException malformedXmlException) {
                // empty catch block
            }
        }
        return params;
    }
}

