/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.util.grpc.GrpcUtil;
import io.github.microcks.util.grpc.TokenCallCredentials;
import io.github.microcks.util.test.AbstractTestRunner;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import io.grpc.stub.ClientCalls;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class GrpcTestRunner
extends AbstractTestRunner<HttpMethod> {
    private static Logger log = LoggerFactory.getLogger(GrpcTestRunner.class);
    private long timeout = 10000L;
    private Secret secret;
    private ResourceRepository resourceRepository;

    public GrpcTestRunner(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    @Override
    public List<TestReturn> runTest(Service service, Operation operation, TestResult testResult, List<Request> requests, String endpointUrl, HttpMethod method) throws URISyntaxException, IOException {
        ManagedChannel channel;
        log.debug("Launching test run on {} for {} request(s)", (Object)endpointUrl, (Object)requests.size());
        if (requests.isEmpty()) {
            return null;
        }
        ArrayList<TestReturn> results = new ArrayList<TestReturn>();
        String fullMethodName = service.getXmlNS() + "." + service.getName() + "/" + operation.getName();
        URL endpoint = new URL(endpointUrl);
        if (endpointUrl.startsWith("https://") || endpoint.getPort() == 443) {
            TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder();
            if (this.secret != null && this.secret.getCaCertPem() != null) {
                tlsBuilder.trustManager((InputStream)new ByteArrayInputStream(this.secret.getCaCertPem().getBytes(StandardCharsets.UTF_8)));
            } else {
                tlsBuilder.trustManager(new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }});
            }
            channel = Grpc.newChannelBuilderForAddress((String)endpoint.getHost(), (int)endpoint.getPort(), (ChannelCredentials)tlsBuilder.build()).build();
        } else {
            channel = Grpc.newChannelBuilderForAddress((String)endpoint.getHost(), (int)endpoint.getPort(), null).usePlaintext().build();
        }
        List<Resource> resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.PROTOBUF_DESCRIPTOR);
        if (resources == null || resources.size() != 1) {
            log.error("Could not found any pre-processed Protobuf binary descriptor...");
            results.add(new TestReturn(1, 0L, "Could not found any pre-processed Protobuf binary descriptor...", null, null));
            return results;
        }
        Resource pbResource = resources.get(0);
        Descriptors.MethodDescriptor md = null;
        try {
            md = GrpcUtil.findMethodDescriptor(pbResource.getContent(), service.getName(), operation.getName());
        }
        catch (Exception e) {
            log.error("Protobuf descriptor cannot be read or parsed: " + e.getMessage());
            results.add(new TestReturn(1, 0L, "Protobuf descriptor cannot be read or parsed: " + e.getMessage(), null, null));
            return results;
        }
        DynamicMessage.Builder reqBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)md.getInputType());
        DynamicMessage.Builder resBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)md.getOutputType());
        JsonFormat.Parser parser = JsonFormat.parser();
        JsonFormat.Printer printer = JsonFormat.printer();
        for (Request request : requests) {
            int code = 0;
            String message = null;
            reqBuilder.clear();
            resBuilder.clear();
            parser.merge(request.getContent(), (Message.Builder)reqBuilder);
            byte[] requestBytes = reqBuilder.build().toByteArray();
            CallOptions callOptions = CallOptions.DEFAULT.withDeadline(Deadline.after((long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
            if (this.secret != null && this.secret.getToken() != null) {
                log.debug("Secret contains token and maybe token header, adding them as call credentials");
                callOptions.withCallCredentials((CallCredentials)new TokenCallCredentials(this.secret.getToken(), this.secret.getTokenHeader()));
            }
            long startTime = System.currentTimeMillis();
            byte[] responseBytes = (byte[])ClientCalls.blockingUnaryCall((Channel)channel, GrpcUtil.buildGenericUnaryMethodDescriptor(fullMethodName), (CallOptions)callOptions, (Object)requestBytes);
            long duration = System.currentTimeMillis() - startTime;
            Response response = new Response();
            response.setStatus("200");
            response.setMediaType("application/x-protobuf");
            response.setContent(new String(responseBytes, "UTF-8"));
            try {
                DynamicMessage respMsg = DynamicMessage.parseFrom((Descriptors.Descriptor)md.getOutputType(), (byte[])responseBytes);
                String respJson = printer.print((MessageOrBuilder)respMsg);
                response.setContent(respJson);
                results.add(new TestReturn(code, duration, message, request, response));
            }
            catch (InvalidProtocolBufferException ipbe) {
                log.error("Received bytes cannot be transformed in " + md.getOutputType().getFullName());
                results.add(new TestReturn(1, duration, "Received bytes cannot be transformed in \" + md.getOutputType().getFullName()", request, response));
            }
        }
        return results;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.POST;
    }
}

