/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.util.graphql.GraphQLSchemaValidator;
import io.github.microcks.util.test.HttpTestRunner;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public class GraphQLTestRunner
extends HttpTestRunner {
    private static Logger log = LoggerFactory.getLogger(GraphQLTestRunner.class);
    private static final String APPLICATION_JSON_TYPE = "application/json";
    private ObjectMapper mapper = new ObjectMapper();
    private ResourceRepository resourceRepository;
    private String lastQueryContent = null;
    private List<String> lastValidationErrors = null;

    public GraphQLTestRunner(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    @Override
    protected void prepareRequest(Request request) {
        try {
            JsonNode requestNode = this.mapper.readTree(request.getContent());
            this.lastQueryContent = requestNode.path("query").asText();
        }
        catch (JsonProcessingException jpe) {
            log.error("JsonProcessingException while preparing GraphQL test query", (Throwable)jpe);
            this.lastQueryContent = "";
        }
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        int code = 0;
        int responseCode = 0;
        try {
            responseCode = httpResponse.getStatusCode().value();
            log.debug("Response status code : {}", (Object)responseCode);
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            return 1;
        }
        if (!String.valueOf(responseCode).startsWith("20")) {
            log.debug("Response code if not in 20x range, assuming it's a failure");
            return 1;
        }
        String contentType = null;
        if (httpResponse.getHeaders().getContentType() != null) {
            log.debug("Response media-type is {}", (Object)httpResponse.getHeaders().getContentType());
            contentType = httpResponse.getHeaders().getContentType().toString();
            if (contentType.contains("charset=") && contentType.indexOf(";") > 0) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
        }
        if (responseCode != 204 && APPLICATION_JSON_TYPE.equals(contentType)) {
            Resource graphqlSchemaResource = null;
            List<Resource> resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.GRAPHQL_SCHEMA);
            if (!resources.isEmpty()) {
                graphqlSchemaResource = resources.get(0);
            }
            if (graphqlSchemaResource == null) {
                log.debug("Found no GraphQL specification resource for service {}, so failing validating", (Object)service.getId());
                return 1;
            }
            JsonNode responseSchema = null;
            try {
                responseSchema = GraphQLSchemaValidator.buildResponseJsonSchema((String)graphqlSchemaResource.getContent(), (String)this.lastQueryContent);
                log.debug("responseSchema: {}", (Object)responseSchema);
                this.lastValidationErrors = GraphQLSchemaValidator.validateJson((JsonNode)responseSchema, (JsonNode)this.mapper.readTree(responseContent));
            }
            catch (IOException ioe) {
                log.debug("Response body cannot be accessed or transformed as Json, returning failure");
                return 1;
            }
            if (!this.lastValidationErrors.isEmpty()) {
                log.debug("GraphQL schema validation errors found: {}, marking test as failed." + this.lastValidationErrors.size());
                return 1;
            }
            log.debug("GraphQL schema validation of response is successful !");
        }
        return code;
    }

    @Override
    protected String extractTestReturnMessage(Service service, Operation operation, Request request, ClientHttpResponse httpResponse) {
        StringBuilder builder = new StringBuilder();
        if (this.lastValidationErrors != null && !this.lastValidationErrors.isEmpty()) {
            for (String error : this.lastValidationErrors) {
                builder.append(error).append("/n");
            }
        }
        this.lastValidationErrors = null;
        return builder.toString();
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.POST;
    }
}

