/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.graphql;

import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.parser.Parser;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.TypeUtil;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(MockRepositoryImporter.class);
    public static final String MICROCKS_ID_STARTER = "microcksId:";
    private String specContent;
    private Document graphqlSchema;
    private static final List<String> VALID_OPERATION_TYPES = Arrays.asList("query", "mutation");

    public GraphQLImporter(String graphqlFilePath) throws IOException {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(graphqlFilePath, new String[0]));
            this.specContent = new String(bytes, Charset.forName("UTF-8"));
            this.graphqlSchema = Parser.parse((String)this.specContent);
        }
        catch (Exception e) {
            log.error("Exception while parsing GraphQL schema file " + graphqlFilePath, (Throwable)e);
            throw new IOException("GraphQL schema file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> results = new ArrayList<Service>();
        Service service = new Service();
        service.setType(ServiceType.GRAPHQL);
        for (Comment comment : this.graphqlSchema.getComments()) {
            String content = comment.getContent().trim();
            if (!content.startsWith(MICROCKS_ID_STARTER)) continue;
            String identifiers = content.substring(MICROCKS_ID_STARTER.length());
            if (identifiers.indexOf(":") != -1) {
                String[] serviceAndVersion = identifiers.split(":");
                service.setName(serviceAndVersion[0].trim());
                service.setVersion(serviceAndVersion[1].trim());
                break;
            }
            log.error("microcksId comment is malformed. Expecting 'microcksId: <API_name>:<API_version>'");
            throw new MockRepositoryImportException("microcksId comment is malformed. Expecting 'microcksId: <API_name>:<API_version>'");
        }
        if (service.getName() == null || service.getVersion() == null) {
            log.error("No microcksId: comment found into GraphQL schema to get API name and version");
            throw new MockRepositoryImportException("No microcksId: comment found into GraphQL schema to get API name and version");
        }
        service.setOperations(this.extractOperations());
        results.add(service);
        return results;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) throws MockRepositoryImportException {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Resource graphqlSchema = new Resource();
        graphqlSchema.setName(service.getName() + "-" + service.getVersion() + ".graphql");
        graphqlSchema.setType(ResourceType.GRAPHQL_SCHEMA);
        graphqlSchema.setContent(this.specContent);
        results.add(graphqlSchema);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        return result;
    }

    private List<Operation> extractOperations() {
        ArrayList<Operation> results = new ArrayList<Operation>();
        for (Definition definition : this.graphqlSchema.getDefinitions()) {
            ObjectTypeDefinition typeDefinition;
            if (!(definition instanceof ObjectTypeDefinition) || !VALID_OPERATION_TYPES.contains((typeDefinition = (ObjectTypeDefinition)definition).getName().toLowerCase())) continue;
            List<Operation> operations = this.extractOperations(typeDefinition);
            results.addAll(operations);
        }
        return results;
    }

    private List<Operation> extractOperations(ObjectTypeDefinition typeDef) {
        ArrayList<Operation> results = new ArrayList<Operation>();
        for (FieldDefinition fieldDef : typeDef.getFieldDefinitions()) {
            Operation operation = new Operation();
            operation.setName(fieldDef.getName());
            operation.setMethod(typeDef.getName().toUpperCase());
            if (fieldDef.getInputValueDefinitions() != null && !fieldDef.getInputValueDefinitions().isEmpty()) {
                operation.setInputName(this.getInputNames(fieldDef.getInputValueDefinitions()));
                boolean hasOnlyPrimitiveArgs = true;
                for (InputValueDefinition inputValueDef : fieldDef.getInputValueDefinitions()) {
                    TypeInfo inputValueTypeInfo;
                    Type inputValueType = inputValueDef.getType();
                    if (TypeUtil.isNonNull((Type)inputValueType)) {
                        inputValueType = TypeUtil.unwrapOne((Type)inputValueType);
                    }
                    if (TypeUtil.isList((Type)inputValueType)) {
                        hasOnlyPrimitiveArgs = false;
                    }
                    if (ScalarInfo.isGraphqlSpecifiedScalar((String)(inputValueTypeInfo = TypeInfo.typeInfo((Type)inputValueType)).getName())) continue;
                    hasOnlyPrimitiveArgs = false;
                }
                if (hasOnlyPrimitiveArgs) {
                    operation.setDispatcher("QUERY_ARGS");
                    operation.setDispatcherRules(this.extractOperationParams(fieldDef.getInputValueDefinitions()));
                }
            }
            if (fieldDef.getType() != null) {
                operation.setOutputName(this.getTypeName(fieldDef.getType()));
            }
            results.add(operation);
        }
        return results;
    }

    private String getInputNames(List<InputValueDefinition> inputsDef) {
        StringBuilder builder = new StringBuilder();
        for (InputValueDefinition inputDef : inputsDef) {
            builder.append(this.getTypeName(inputDef.getType())).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    private String extractOperationParams(List<InputValueDefinition> inputsDef) {
        StringBuilder builder = new StringBuilder();
        for (InputValueDefinition inputDef : inputsDef) {
            builder.append(inputDef.getName()).append(" && ");
        }
        return builder.substring(0, builder.length() - 4);
    }

    private String getTypeName(Type type) {
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return "[" + this.getTypeName(listType.getType()) + "]";
        }
        if (type instanceof TypeName) {
            return ((TypeName)type).getName();
        }
        return type.toString();
    }
}

