/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.asyncapi.AsyncAPI3Importer;
import io.github.microcks.util.asyncapi.AsyncAPIImporter;
import io.github.microcks.util.graphql.GraphQLImporter;
import io.github.microcks.util.grpc.ProtobufImporter;
import io.github.microcks.util.har.HARImporter;
import io.github.microcks.util.metadata.MetadataImporter;
import io.github.microcks.util.openapi.OpenAPIImporter;
import io.github.microcks.util.openapi.SwaggerImporter;
import io.github.microcks.util.postman.PostmanCollectionImporter;
import io.github.microcks.util.postman.PostmanWorkspaceCollectionImporter;
import io.github.microcks.util.soapui.SoapUIProjectImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRepositoryImporterFactory {
    private static Logger log = LoggerFactory.getLogger(MockRepositoryImporterFactory.class);
    public static final String OPENAPI_3_REGEXP = ".*['\\\"]?openapi['\\\"]?\\s*:\\s*['\\\"]?[3\\.].*";
    public static final String ASYNCAPI_2_REGEXP = ".*['\\\"]?asyncapi['\\\"]?\\s*:\\s*['\\\"]?[2\\.].*";
    public static final String ASYNCAPI_3_REGEXP = ".*['\\\"]?asyncapi['\\\"]?\\s*:\\s*['\\\"]?[3\\.].*";
    public static final String SWAGGER_REGEXP = ".*['\\\"]?swagger['\\\"]?\\s*:\\s*.*";

    private MockRepositoryImporterFactory() {
    }

    public static MockRepositoryImporter getMockRepositoryImporter(File mockRepository, ReferenceResolver referenceResolver) throws IOException {
        MockRepositoryImporter importer = null;
        String line = null;
        try (BufferedReader reader = Files.newBufferedReader(mockRepository.toPath(), StandardCharsets.UTF_8);){
            while ((line = reader.readLine()) != null && importer == null) {
                importer = MockRepositoryImporterFactory.checkPostmanImporters(line = line.trim(), mockRepository);
                if (importer == null) {
                    importer = MockRepositoryImporterFactory.checkOpenAPIImporters(line, mockRepository, referenceResolver);
                }
                if (importer != null) continue;
                importer = MockRepositoryImporterFactory.checkOtherImporters(line, mockRepository, referenceResolver);
            }
        }
        if (importer == null) {
            log.info("Have not found any explicit marker so applying the default SoapUI Project importer...");
            importer = new SoapUIProjectImporter(mockRepository.getPath());
        }
        return importer;
    }

    private static MockRepositoryImporter checkPostmanImporters(String line, File mockRepository) throws IOException {
        if (line.startsWith("\"_postman_id\":")) {
            log.info("Found a _postman_id in file so assuming it's a Postman Collection to import");
            return new PostmanCollectionImporter(mockRepository.getPath());
        }
        if (line.startsWith("\"collection\":") || line.startsWith("{\"collection\":")) {
            log.info("Found a collection in file so assuming it's a Postman Workspace Collection to import");
            return new PostmanWorkspaceCollectionImporter(mockRepository.getPath());
        }
        return null;
    }

    private static MockRepositoryImporter checkOpenAPIImporters(String line, File mockRepository, ReferenceResolver referenceResolver) throws IOException {
        if (line.matches(OPENAPI_3_REGEXP)) {
            log.info("Found an openapi: 3 pragma in file so assuming it's an OpenAPI spec to import");
            return new OpenAPIImporter(mockRepository.getPath(), referenceResolver);
        }
        if (line.matches(SWAGGER_REGEXP)) {
            log.info("Found an swagger: pragma in file so assuming it's a Swagger spec to import");
            return new SwaggerImporter(mockRepository.getPath(), referenceResolver);
        }
        return null;
    }

    private static MockRepositoryImporter checkOtherImporters(String line, File mockRepository, ReferenceResolver referenceResolver) throws IOException {
        if (line.startsWith("<?xml")) {
            log.info("Found a XML pragma in file so assuming it's a SoapUI Project to import");
            return new SoapUIProjectImporter(mockRepository.getPath());
        }
        if (line.startsWith("\"log\":") || line.startsWith("{\"log\":")) {
            log.info("Found a log JSON element in file so asssuming it's a HTTP Archive (HAR) to import");
            return new HARImporter(mockRepository.getPath());
        }
        if (line.matches(ASYNCAPI_2_REGEXP)) {
            log.info("Found an asyncapi: 2 pragma in file so assuming it's an AsyncAPI spec to import");
            return new AsyncAPIImporter(mockRepository.getPath(), referenceResolver);
        }
        if (line.matches(ASYNCAPI_3_REGEXP)) {
            log.info("Found an asyncapi: 3 pragma in file so assuming it's an AsyncAPI spec to import");
            return new AsyncAPI3Importer(mockRepository.getPath(), referenceResolver);
        }
        if (line.startsWith("syntax = \"proto3\";") || line.startsWith("syntax=\"proto3\";")) {
            log.info("Found a syntax = proto3 pragma in file so assuming it's a GRPC Protobuf spec to import");
            return new ProtobufImporter(mockRepository.getPath(), referenceResolver);
        }
        if (line.contains("kind: APIMetadata")) {
            log.info("Found a kind: APIMetadata pragma in file so assuming it's a Microcks APIMetadata to import");
            return new MetadataImporter(mockRepository.getPath());
        }
        if (line.contains("type Query {") || line.contains("type Mutation {") || line.contains("microcksId:")) {
            log.info("Found query, mutation or microcksId: pragmas in file so assuming it's a GraphQL schema to import");
            return new GraphQLImporter(mockRepository.getPath());
        }
        return null;
    }
}

