/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class MicrocksJwtConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private static Logger log = LoggerFactory.getLogger(MicrocksJwtConverter.class);

    public JwtAuthenticationToken convert(Jwt jwt) {
        Map microcksResource;
        Map resourceAccess = (Map)jwt.getClaim("resource_access");
        if (resourceAccess != null && (microcksResource = (Map)resourceAccess.get("microcks-app")) != null) {
            Collection roles = (Collection)microcksResource.get("roles");
            log.trace("JWT extracted roles for microcks-app: {}", (Object)roles);
            List<SimpleGrantedAuthority> grantedAuthorities = roles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).toList();
            return new JwtAuthenticationToken(jwt, grantedAuthorities);
        }
        return new JwtAuthenticationToken(jwt, Collections.emptyList());
    }
}

