/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.ServiceView;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.repository.CustomServiceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.MessageService;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.EntityAlreadyExistsException;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.web.dto.GenericResourceServiceDTO;
import io.github.microcks.web.dto.OperationOverrideDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ServiceController {
    private static Logger log = LoggerFactory.getLogger(ServiceController.class);
    @Autowired
    private ServiceService serviceService;
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private MessageService messageService;

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public List<Service> listServices(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size) {
        log.debug("Getting service list for page {} and size {}", (Object)page, (Object)size);
        return this.serviceRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name", "version"}))).getContent();
    }

    @RequestMapping(value={"/services/search"}, method={RequestMethod.GET})
    public List<Service> searchServices(@RequestParam Map<String, String> queryMap) {
        String name = null;
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String paramKey : queryMap.keySet()) {
            if ("name".equals(paramKey)) {
                name = queryMap.get("name");
            }
            if (!paramKey.startsWith("labels.")) continue;
            labels.put(paramKey.substring(paramKey.indexOf(46) + 1), queryMap.get(paramKey));
        }
        if (labels == null || labels.isEmpty()) {
            log.debug("Searching services corresponding to name {}", name);
            return this.serviceRepository.findByNameLike(name);
        }
        if (name == null || name.trim().length() == 0) {
            log.debug("Searching services corresponding to labels {}", labels);
            return this.serviceRepository.findByLabels(labels);
        }
        log.debug("Searching services corresponding to name {} and labels {}", (Object)name, labels);
        return this.serviceRepository.findByLabelsAndNameLike(labels, name);
    }

    @RequestMapping(value={"/services/count"}, method={RequestMethod.GET})
    public Map<String, Long> countServices() {
        log.debug("Counting services...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.serviceRepository.count());
        return counter;
    }

    @RequestMapping(value={"/services/map"}, method={RequestMethod.GET})
    public Map<String, Integer> getServicesMap() {
        log.debug("Counting services by type...");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List results = this.serviceRepository.countServicesByType();
        for (CustomServiceRepository.ServiceCount count : results) {
            map.put(count.getType(), count.getNumber());
        }
        return map;
    }

    @RequestMapping(value={"/services/labels"}, method={RequestMethod.GET})
    public Map<String, String[]> getServicesLabels() {
        log.debug("Retrieving available services labels...");
        HashMap<String, String[]> labelValues = new HashMap<String, String[]>();
        List results = this.serviceRepository.listLabels();
        for (CustomServiceRepository.LabelValues values : results) {
            labelValues.put(values.getKey(), values.getValues());
        }
        return labelValues;
    }

    @RequestMapping(value={"/services/{id:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getService(@PathVariable(value="id") String serviceId, @RequestParam(value="messages", required=false, defaultValue="true") boolean messages) {
        log.debug("Retrieving service with id {}", (Object)serviceId);
        Service service = null;
        if (serviceId.contains(":")) {
            String name = serviceId.substring(0, serviceId.indexOf(58));
            String version = serviceId.substring(serviceId.indexOf(58) + 1);
            if (name.contains("+")) {
                name = name.replace('+', ' ');
            }
            service = this.serviceRepository.findByNameAndVersion(name, version);
        } else {
            service = this.serviceRepository.findById(serviceId).orElse(null);
        }
        if (messages) {
            HashMap<String, List<Object>> messagesMap = new HashMap<String, List<Object>>();
            for (Operation operation : service.getOperations()) {
                if (service.getType() == ServiceType.EVENT || service.getType() == ServiceType.GENERIC_EVENT) {
                    List<UnidirectionalEvent> events = this.messageService.getEventByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                    messagesMap.put(operation.getName(), events);
                    continue;
                }
                List<RequestResponsePair> pairs = this.messageService.getRequestResponseByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                messagesMap.put(operation.getName(), pairs);
            }
            return new ResponseEntity((Object)new ServiceView(service, messagesMap), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/services/generic"}, method={RequestMethod.POST})
    public ResponseEntity<Service> createGenericResourceService(@RequestBody GenericResourceServiceDTO serviceDTO) {
        log.debug("Creating a new Service '{}-{}' for generic resource '{}'", new Object[]{serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource()});
        try {
            Service service = this.serviceService.createGenericResourceService(serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource(), serviceDTO.getReferencePayload());
            return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (EntityAlreadyExistsException eaee) {
            log.error("Service '{}-{} already exists'", (Object)serviceDTO.getName(), (Object)serviceDTO.getVersion());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/services/generic/event"}, method={RequestMethod.POST})
    public ResponseEntity<Service> createGenericEventService(@RequestBody GenericResourceServiceDTO serviceDTO) {
        log.debug("Creating a new Service '{}-{}' for generic resource '{}'", new Object[]{serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource()});
        try {
            Service service = this.serviceService.createGenericEventService(serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource(), serviceDTO.getReferencePayload());
            return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (EntityAlreadyExistsException eaee) {
            log.error("Service '{}-{} already exists'", (Object)serviceDTO.getName(), (Object)serviceDTO.getVersion());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/services/{id}/metadata"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateMetadata(@PathVariable(value="id") String serviceId, @RequestBody Metadata metadata, UserInfo userInfo) {
        log.debug("Updating the metadata of service {}", (Object)serviceId);
        boolean result = this.serviceService.updateMetadata(serviceId, metadata, userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/services/{id}/operation"}, method={RequestMethod.PUT})
    public ResponseEntity<?> overrideServiceOperation(@PathVariable(value="id") String serviceId, @RequestParam(value="operationName") String operationName, @RequestBody OperationOverrideDTO operationOverride, UserInfo userInfo) {
        log.debug("Updating operation {} of service {}", (Object)operationName, (Object)serviceId);
        log.debug("ParameterConstraints?: {}", operationOverride.getParameterConstraints());
        boolean result = this.serviceService.updateOperation(serviceId, operationName, operationOverride.getDispatcher(), operationOverride.getDispatcherRules(), operationOverride.getDefaultDelay(), operationOverride.getParameterConstraints(), userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/services/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteService(@PathVariable(value="id") String serviceId, UserInfo userInfo) {
        log.debug("Removing service with id {}", (Object)serviceId);
        boolean result = this.serviceService.deleteService(serviceId, userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }
}

