/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui;

import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MalformedXmlException;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.XmlUtil;
import io.github.microcks.util.soapui.SoapUIProjectParserUtils;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SoapUIProjectImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(SoapUIProjectImporter.class);
    public static final String SERVICE_VERSION_PROPERTY = "version";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String ELEMENT_ATTRIBUTE = "element";
    protected static final String MOCK_SERVICE_TAG = "mockService";
    protected static final String REST_MOCK_SERVICE_TAG = "restMockService";
    protected static final String MOCK_OPERATION_TAG = "mockOperation";
    protected static final String REST_MOCK_ACTION_TAG = "restMockAction";
    protected static final String REQUEST_TAG = "request";
    protected static final String RESPONSE_TAG = "response";
    private String projectContent;
    private DocumentBuilder documentBuilder;
    private Element projectElement;
    private Element serviceInterface;
    private Map<String, Element> interfaces = new HashMap<String, Element>();

    public SoapUIProjectImporter(String projectFilePath) throws IOException {
        try {
            byte[] projectBytes = Files.readAllBytes(Paths.get(projectFilePath, new String[0]));
            this.projectContent = new String(projectBytes, StandardCharsets.UTF_8);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.documentBuilder = factory.newDocumentBuilder();
            this.projectElement = this.documentBuilder.parse(new InputSource(new StringReader(this.projectContent))).getDocumentElement();
        }
        catch (Exception e) {
            log.error("Exception while parsing SoapUI file " + projectFilePath, (Throwable)e);
            throw new IOException("SoapUI project file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        List<Element> restMockServices;
        ArrayList<Service> result = new ArrayList<Service>();
        List<Element> interfaceNodes = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, "interface");
        for (Element interfaceNode : interfaceNodes) {
            if (interfaceNode.getAttribute(NAME_ATTRIBUTE) == null) continue;
            log.info("Found a service interface named: {}", (Object)interfaceNode.getAttribute(NAME_ATTRIBUTE));
            this.interfaces.put(interfaceNode.getAttribute(NAME_ATTRIBUTE), interfaceNode);
            this.serviceInterface = interfaceNode;
        }
        List<Element> mockServices = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, MOCK_SERVICE_TAG);
        if (!mockServices.isEmpty()) {
            result.addAll(this.getSoapServicesDefinitions(mockServices));
        }
        if (!(restMockServices = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, REST_MOCK_SERVICE_TAG)).isEmpty()) {
            result.addAll(this.getRestServicesDefinitions(restMockServices));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Service> getSoapServicesDefinitions(List<Element> mockServices) throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        try {
            for (Element mockService : mockServices) {
                Service service = new Service();
                service.setName(mockService.getAttribute(NAME_ATTRIBUTE));
                service.setType(ServiceType.SOAP_HTTP);
                Element properties = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockService, "properties");
                service.setVersion(this.extractVersion(properties));
                List<Element> mockOperations = SoapUIProjectParserUtils.getConfigDirectChildren(mockService, MOCK_OPERATION_TAG);
                for (Element mockOperation : mockOperations) {
                    Element interfaceElement = this.interfaces.get(mockOperation.getAttribute("interface"));
                    if (interfaceElement != null) {
                        log.info("Got matching service interface");
                        String bindingQName = interfaceElement.getAttribute("bindingName");
                        service.setXmlNS(this.extractNSFromQName(bindingQName));
                    }
                    Operation operation = new Operation();
                    operation.setName(mockOperation.getAttribute(NAME_ATTRIBUTE));
                    Element interfaceOperation = this.getInterfaceOperation(interfaceElement, operation.getName());
                    operation.setAction(interfaceOperation.getAttribute("action"));
                    try {
                        this.completeOperationPartsFromWsdl(interfaceElement, operation);
                    }
                    catch (Exception e) {
                        log.warn("Was not able to extract element names for input/output payload from WSDL. Defaulting to input and output names.");
                    }
                    finally {
                        if (operation.getInputName() == null) {
                            operation.setInputName(interfaceOperation.getAttribute("inputName"));
                        }
                        if (operation.getOutputName() == null) {
                            operation.setOutputName(interfaceOperation.getAttribute("outputName"));
                        }
                    }
                    Element dispatchStyle = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchStyle");
                    operation.setDispatcher(dispatchStyle.getTextContent());
                    if ("QUERY_MATCH".equals(operation.getDispatcher())) {
                        Element dispatchConfig = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchConfig");
                        Element firstQuery = SoapUIProjectParserUtils.getConfigDirectChildren(dispatchConfig, "query").get(0);
                        operation.setDispatcherRules(SoapUIProjectParserUtils.getConfigUniqueDirectChild(firstQuery, "query").getTextContent());
                    } else if ("SCRIPT".equals(operation.getDispatcher())) {
                        operation.setDispatcherRules(SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchPath").getTextContent());
                    }
                    service.addOperation(operation);
                }
                result.add(service);
            }
        }
        catch (MalformedXmlException mspe) {
            log.error("Your SoapUI Project seems to be malformed: {}", (Object)mspe.getMessage(), (Object)mspe);
            throw new MockRepositoryImportException("Your SoapUI Project seems to be malformed: " + mspe.getMessage(), mspe);
        }
        return result;
    }

    private void completeOperationPartsFromWsdl(Element interfaceElement, Operation operation) throws Exception {
        Element definitionCache = SoapUIProjectParserUtils.getConfigUniqueDirectChild(interfaceElement, "definitionCache");
        List<Element> parts = SoapUIProjectParserUtils.getConfigDirectChildren(definitionCache, "part");
        Element wsdlPart = parts.get(0);
        Element wsdlContent = SoapUIProjectParserUtils.getConfigUniqueDirectChild(wsdlPart, "content");
        String wsdlTextContent = wsdlContent.getTextContent();
        Element wsdlDoc = this.documentBuilder.parse(new InputSource(new StringReader(wsdlTextContent))).getDocumentElement();
        Element binding = XmlUtil.getUniqueDirectChild((Element)wsdlDoc, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"binding");
        List wsdlOperations = XmlUtil.getDirectChildren((Element)binding, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"operation");
        for (Element wsdlOperation : wsdlOperations) {
            String localTag;
            Element firstPart;
            if (!operation.getName().equals(wsdlOperation.getAttribute(NAME_ATTRIBUTE))) continue;
            Element input = XmlUtil.getUniqueDirectChild((Element)wsdlOperation, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"input");
            Element output = XmlUtil.getUniqueDirectChild((Element)wsdlOperation, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"output");
            String inputName = input.getAttribute(NAME_ATTRIBUTE);
            String outputName = output.getAttribute(NAME_ATTRIBUTE);
            List messages = XmlUtil.getDirectChildren((Element)wsdlDoc, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"message");
            Optional<Element> inputMsg = messages.stream().filter(m -> inputName.equals(m.getAttribute(NAME_ATTRIBUTE))).findFirst();
            Optional<Element> outputMsg = messages.stream().filter(m -> outputName.equals(m.getAttribute(NAME_ATTRIBUTE))).findFirst();
            if (inputMsg.isPresent()) {
                firstPart = (Element)XmlUtil.getDirectChildren((Element)inputMsg.get(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"part").get(0);
                localTag = firstPart.getAttribute(ELEMENT_ATTRIBUTE).substring(firstPart.getAttribute(ELEMENT_ATTRIBUTE).indexOf(":") + 1);
                operation.setInputName(localTag);
            }
            if (!outputMsg.isPresent()) continue;
            firstPart = (Element)XmlUtil.getDirectChildren((Element)outputMsg.get(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"part").get(0);
            localTag = firstPart.getAttribute(ELEMENT_ATTRIBUTE).substring(firstPart.getAttribute(ELEMENT_ATTRIBUTE).indexOf(":") + 1);
            operation.setOutputName(localTag);
        }
    }

    private List<Service> getRestServicesDefinitions(List<Element> restMockServices) throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        try {
            for (Element mockService : restMockServices) {
                Service service = new Service();
                service.setName(mockService.getAttribute(NAME_ATTRIBUTE));
                service.setType(ServiceType.REST);
                Element properties = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockService, "properties");
                service.setVersion(this.extractVersion(properties));
                HashMap<String, Operation> collectedOperations = new HashMap<String, Operation>();
                List<Element> mockOperations = SoapUIProjectParserUtils.getConfigDirectChildren(mockService, REST_MOCK_ACTION_TAG);
                for (Element mockOperation : mockOperations) {
                    Operation operation = (Operation)collectedOperations.get(mockOperation.getAttribute(NAME_ATTRIBUTE));
                    if (operation == null) {
                        operation = new Operation();
                        operation.setName(mockOperation.getAttribute(NAME_ATTRIBUTE));
                        operation.setMethod(mockOperation.getAttribute("method"));
                        Element dispatchStyle = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchStyle");
                        operation.setDispatcher(dispatchStyle.getTextContent());
                        if ("SEQUENCE".equals(operation.getDispatcher())) {
                            operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(operation.getName()));
                        } else if ("SCRIPT".equals(operation.getDispatcher())) {
                            operation.setDispatcherRules(SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchPath").getTextContent());
                        }
                        service.addOperation(operation);
                    }
                    operation.addResourcePath(mockOperation.getAttribute("resourcePath"));
                    collectedOperations.put(mockOperation.getAttribute(NAME_ATTRIBUTE), operation);
                }
                result.add(service);
            }
        }
        catch (MalformedXmlException mspe) {
            log.error("Your SoapUI Project seems to be malformed: {}", (Object)mspe.getMessage(), (Object)mspe);
            throw new MockRepositoryImportException("Your SoapUI Project seems to be malformed: " + mspe.getMessage(), mspe);
        }
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Resource projectResource = new Resource();
        projectResource.setName(service.getName() + "-" + service.getVersion() + ".xml");
        projectResource.setType(ResourceType.SOAP_UI_PROJECT);
        projectResource.setContent(this.projectContent);
        results.add(projectResource);
        try {
            Element definitionCache = SoapUIProjectParserUtils.getConfigUniqueDirectChild(this.serviceInterface, "definitionCache");
            List<Element> parts = SoapUIProjectParserUtils.getConfigDirectChildren(definitionCache, "part");
            if (!parts.isEmpty()) {
                Element wsdlPart = parts.get(0);
                Element wsdlContent = SoapUIProjectParserUtils.getConfigUniqueDirectChild(wsdlPart, "content");
                String wsdlTextContent = wsdlContent.getTextContent();
                for (int i = 1; i < parts.size(); ++i) {
                    Element xsdPart = parts.get(i);
                    String xsdUrl = SoapUIProjectParserUtils.getConfigUniqueDirectChild(xsdPart, "url").getTextContent().trim();
                    String xsdName = xsdUrl.substring(xsdUrl.lastIndexOf(47) + 1);
                    if (xsdUrl.contains("\\")) {
                        xsdName = xsdUrl.substring(xsdUrl.lastIndexOf("\\") + 1);
                    }
                    String xsdContent = SoapUIProjectParserUtils.getConfigUniqueDirectChild(xsdPart, "content").getTextContent();
                    Resource xsdResource = new Resource();
                    xsdResource.setName(xsdName);
                    xsdResource.setType(ResourceType.XSD);
                    xsdResource.setContent(xsdContent);
                    results.add(xsdResource);
                    wsdlTextContent = wsdlTextContent.replace(xsdUrl, "./" + xsdName);
                }
                Resource wsdlResource = new Resource();
                wsdlResource.setName(service.getName() + "-" + service.getVersion() + ".wsdl");
                wsdlResource.setType(ResourceType.WSDL);
                wsdlResource.setContent(wsdlTextContent);
                results.add(wsdlResource);
            }
        }
        catch (MalformedXmlException mxe) {
            log.warn("Got a MalformedXmlException while trying to extract WSDL and XSD: {}", (Object)mxe.getMessage());
            log.warn("Just failing silently as it's not a critical stuff in SoapUI implementation");
        }
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> results = new ArrayList<Exchange>();
        if (ServiceType.SOAP_HTTP == service.getType()) {
            results.addAll(this.getSoapMessageDefinitions(service, operation));
        } else if (ServiceType.REST == service.getType()) {
            results.addAll(this.getRestMessageDefinitions(service, operation));
        }
        return results;
    }

    private List<Exchange> getSoapMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        HashMap<Request, Response> result;
        block21: {
            result = new HashMap<Request, Response>();
            try {
                List<Element> mockServices = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, MOCK_SERVICE_TAG);
                for (Element mockService : mockServices) {
                    if (!service.getName().equals(mockService.getAttribute(NAME_ATTRIBUTE))) continue;
                    List<Element> mockOperations = SoapUIProjectParserUtils.getConfigDirectChildren(mockService, MOCK_OPERATION_TAG);
                    for (Element mockOperation : mockOperations) {
                        if (!operation.getName().equals(mockOperation.getAttribute("operation"))) continue;
                        Map<String, Element> availableRequests = this.collectTestStepsRequests(operation);
                        ArrayList<Element> candidateRequests = new ArrayList<Element>();
                        List<Element> mockResponses = SoapUIProjectParserUtils.getConfigDirectChildren(mockOperation, RESPONSE_TAG);
                        for (Element mockResponse : mockResponses) {
                            String responseName = mockResponse.getAttribute(NAME_ATTRIBUTE);
                            Element matchingRequest = availableRequests.get(responseName);
                            if (matchingRequest == null) {
                                matchingRequest = availableRequests.get((String)responseName + " Request");
                            }
                            if (matchingRequest == null && responseName.contains("Response")) {
                                matchingRequest = availableRequests.get(responseName.replace("Response", "Request"));
                            }
                            if (matchingRequest == null) {
                                log.warn("No request found for response '{}' into SoapUI project '{}'", (Object)responseName, (Object)this.projectElement.getAttribute(NAME_ATTRIBUTE));
                                continue;
                            }
                            candidateRequests.add(matchingRequest);
                        }
                        if ("QUERY_MATCH".equals(operation.getDispatcher())) {
                            try {
                                XPathExpression xpath = this.initializeXPathMatcher(operation);
                                Map<String, String> matchToResponseMap = this.buildQueryMatchDispatchCriteriaToResponseMap(mockOperation);
                                for (Element candidateRequest : candidateRequests) {
                                    String requestContent = SoapUIProjectParserUtils.getConfigUniqueDirectChild(candidateRequest, REQUEST_TAG).getTextContent();
                                    String dispatchCriteria = xpath.evaluate(new InputSource(new StringReader(requestContent)));
                                    String correspondingResponse = matchToResponseMap.get(dispatchCriteria);
                                    Element matchingResponse = this.getMockResponseByName(mockOperation, correspondingResponse);
                                    if (matchingResponse == null) continue;
                                    Response response = this.buildResponse(matchingResponse, dispatchCriteria);
                                    Request request = this.buildRequest(candidateRequest);
                                    result.put(request, response);
                                }
                                break block21;
                            }
                            catch (XPathExpressionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if ("SCRIPT".equals(operation.getDispatcher())) {
                            for (Element candidateRequest : candidateRequests) {
                                Element mockResponse = this.getMockResponseByName(mockOperation, candidateRequest.getAttribute(NAME_ATTRIBUTE));
                                if (mockResponse == null && candidateRequest.getAttribute(NAME_ATTRIBUTE).contains("Request")) {
                                    mockResponse = this.getMockResponseByName(mockOperation, candidateRequest.getAttribute(NAME_ATTRIBUTE).replace(" Request", " Response"));
                                }
                                if (mockResponse == null) {
                                    log.warn("No response found for request {} into SoapUI project {}", (Object)candidateRequest.getAttribute(NAME_ATTRIBUTE), (Object)this.projectElement.getAttribute(NAME_ATTRIBUTE));
                                    continue;
                                }
                                response = this.buildResponse(mockResponse, mockResponse.getAttribute(NAME_ATTRIBUTE));
                                Request request = this.buildRequest(candidateRequest);
                                result.put(request, response);
                            }
                        } else if ("RANDOM".equals(operation.getDispatcher())) {
                            if (availableRequests.isEmpty()) {
                                log.warn("A request is mandatory even for a RANDOM dispatch. Operation {} into SoapUI project  {}", (Object)operation.getName(), (Object)this.projectElement.getAttribute(NAME_ATTRIBUTE));
                            } else {
                                Element mockRequest = availableRequests.values().iterator().next();
                                for (Element mockResponse : mockResponses) {
                                    response = this.buildResponse(mockResponse, "RANDOM");
                                    Request request = this.buildRequest(mockRequest);
                                    request.setName(operation.getName());
                                    result.put(request, response);
                                }
                            }
                        }
                        break block21;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                throw new MockRepositoryImportException(t.getMessage());
            }
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private List<Exchange> getRestMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        try {
            List<Element> mockServices = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, REST_MOCK_SERVICE_TAG);
            block2: for (Element mockService : mockServices) {
                if (!service.getName().equals(mockService.getAttribute(NAME_ATTRIBUTE))) continue;
                List<Element> mockOperations = SoapUIProjectParserUtils.getConfigDirectChildren(mockService, REST_MOCK_ACTION_TAG);
                for (Element mockOperation : mockOperations) {
                    if (!operation.getName().equals(mockOperation.getAttribute(NAME_ATTRIBUTE))) continue;
                    Map<String, Element> availableRequests = this.collectTestStepsRestRequests(operation);
                    List<Element> mockResponses = this.getMockRestResponses(mockService, operation);
                    HashMap<Element, Element> requestToResponses = new HashMap<Element, Element>();
                    for (Element element : mockResponses) {
                        String responseName = element.getAttribute(NAME_ATTRIBUTE);
                        Element matchingRequest = availableRequests.get(responseName);
                        if (matchingRequest == null) {
                            matchingRequest = availableRequests.get(responseName + " Request");
                        }
                        if (matchingRequest == null && responseName.contains("Response")) {
                            matchingRequest = availableRequests.get(responseName.replace("Response", "Request"));
                        }
                        if (matchingRequest == null) {
                            log.warn("No request found for response '{}' into SoapUI project '{}'", (Object)responseName, (Object)this.projectElement.getAttribute(NAME_ATTRIBUTE));
                            continue;
                        }
                        requestToResponses.put(matchingRequest, element);
                    }
                    for (Map.Entry entry2 : requestToResponses.entrySet()) {
                        String dispatchCriteria = null;
                        if ("SEQUENCE".equals(operation.getDispatcher())) {
                            String resourcePath = ((Element)((Element)entry2.getValue()).getParentNode()).getAttribute("resourcePath");
                            dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(operation.getDispatcherRules(), operation.getName(), resourcePath);
                        } else if ("SCRIPT".equals(operation.getDispatcher())) {
                            dispatchCriteria = ((Element)entry2.getValue()).getAttribute(NAME_ATTRIBUTE);
                        }
                        Response response = this.buildResponse((Element)entry2.getValue(), dispatchCriteria);
                        Request request = this.buildRequest((Element)entry2.getKey());
                        result.put(request, response);
                    }
                    continue block2;
                }
            }
        }
        catch (Throwable t) {
            throw new MockRepositoryImportException(t.getMessage());
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private String extractNSFromQName(String qName) {
        if (qName.startsWith("{") && qName.indexOf("}") > 1) {
            return qName.substring(1, qName.indexOf("}"));
        }
        return qName;
    }

    private String extractVersion(Element properties) throws MockRepositoryImportException, MalformedXmlException {
        List<Element> propertyList = SoapUIProjectParserUtils.getConfigDirectChildren(properties, "property");
        for (Element property : propertyList) {
            Element propertyName = SoapUIProjectParserUtils.getConfigUniqueDirectChild(property, NAME_ATTRIBUTE);
            Element propertyValue = SoapUIProjectParserUtils.getConfigUniqueDirectChild(property, "value");
            if (!SERVICE_VERSION_PROPERTY.equals(propertyName.getTextContent())) continue;
            return propertyValue.getTextContent();
        }
        log.error("Version property is missing in Project properties");
        throw new MockRepositoryImportException("Version property is missing in Project properties");
    }

    private Element getInterfaceOperation(Element serviceInterface, String operationName) throws MockRepositoryImportException {
        List<Element> operations = SoapUIProjectParserUtils.getConfigDirectChildren(serviceInterface, "operation");
        for (Element operation : operations) {
            if (!operationName.equals(operation.getAttribute(NAME_ATTRIBUTE))) continue;
            return operation;
        }
        log.error("Operation {} is missing into Service interface", (Object)operationName);
        throw new MockRepositoryImportException("Operation " + operationName + " is missing into Service interface");
    }

    private Map<String, Element> collectTestStepsRequests(Operation operation) throws MalformedXmlException {
        HashMap<String, Element> results = new HashMap<String, Element>();
        List<Element> testSuites = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, "testSuite");
        for (Element testSuite : testSuites) {
            List<Element> testCases = SoapUIProjectParserUtils.getConfigDirectChildren(testSuite, "testCase");
            for (Element testCase : testCases) {
                List<Element> testSteps = SoapUIProjectParserUtils.getConfigDirectChildren(testCase, "testStep");
                for (Element testStep : testSteps) {
                    Element config = SoapUIProjectParserUtils.getConfigUniqueDirectChild(testStep, "config");
                    String interfaceName = SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "interface").getTextContent();
                    String operationName = SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "operation").getTextContent();
                    if (!operation.getName().equals(operationName)) continue;
                    results.put(testStep.getAttribute(NAME_ATTRIBUTE), SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, REQUEST_TAG));
                }
            }
        }
        return results;
    }

    private Map<String, Element> collectTestStepsRestRequests(Operation operation) throws MalformedXmlException {
        HashMap<String, Element> results = new HashMap<String, Element>();
        List<Element> testSuites = SoapUIProjectParserUtils.getConfigDirectChildren(this.projectElement, "testSuite");
        for (Element testSuite : testSuites) {
            List<Element> testCases = SoapUIProjectParserUtils.getConfigDirectChildren(testSuite, "testCase");
            for (Element testCase : testCases) {
                List<Element> testSteps = SoapUIProjectParserUtils.getConfigDirectChildren(testCase, "testStep");
                for (Element testStep : testSteps) {
                    Element config = SoapUIProjectParserUtils.getConfigUniqueDirectChild(testStep, "config");
                    String operationName = config.getAttribute("resourcePath");
                    if (!operation.getName().equals(operationName)) continue;
                    results.put(testStep.getAttribute(NAME_ATTRIBUTE), SoapUIProjectParserUtils.getConfigUniqueDirectChild(config, "restRequest"));
                }
            }
        }
        return results;
    }

    private List<Element> getMockRestResponses(Element restMockService, Operation operation) {
        ArrayList<Element> responses = new ArrayList<Element>();
        List<Element> mockActions = SoapUIProjectParserUtils.getConfigDirectChildren(restMockService, REST_MOCK_ACTION_TAG);
        for (Element mockAction : mockActions) {
            if (!operation.getName().equals(mockAction.getAttribute(NAME_ATTRIBUTE))) continue;
            responses.addAll(SoapUIProjectParserUtils.getConfigDirectChildren(mockAction, RESPONSE_TAG));
        }
        return responses;
    }

    private XPathExpression initializeXPathMatcher(Operation operation) throws XPathExpressionException {
        return SoapUIXPathBuilder.buildXPathMatcherFromRules(operation.getDispatcherRules());
    }

    private Map<String, String> buildQueryMatchDispatchCriteriaToResponseMap(Element mockOperation) throws MalformedXmlException {
        HashMap<String, String> matchResponseMap = new HashMap<String, String>();
        String dispatcher = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchStyle").getTextContent();
        if ("QUERY_MATCH".equals(dispatcher)) {
            Element dispatchConfig = SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockOperation, "dispatchConfig");
            List<Element> queries = SoapUIProjectParserUtils.getConfigDirectChildren(dispatchConfig, "query");
            for (Element query : queries) {
                String match = SoapUIProjectParserUtils.getConfigUniqueDirectChild(query, "match").getTextContent();
                String response = SoapUIProjectParserUtils.getConfigUniqueDirectChild(query, RESPONSE_TAG).getTextContent();
                matchResponseMap.put(match, response);
            }
        }
        return matchResponseMap;
    }

    private Element getMockResponseByName(Element mockOperation, String responseName) {
        List<Element> responses = SoapUIProjectParserUtils.getConfigDirectChildren(mockOperation, RESPONSE_TAG);
        for (Element response : responses) {
            if (!responseName.equals(response.getAttribute(NAME_ATTRIBUTE))) continue;
            return response;
        }
        return null;
    }

    private Response buildResponse(Element mockResponse, String dispatchCriteria) throws MockRepositoryImportException, Exception {
        Response response = new Response();
        response.setName(mockResponse.getAttribute(NAME_ATTRIBUTE));
        response.setContent(SoapUIProjectParserUtils.getConfigUniqueDirectChild(mockResponse, "responseContent").getTextContent());
        response.setHeaders(this.buildHeaders(mockResponse));
        response.setDispatchCriteria(dispatchCriteria);
        response.setStatus(mockResponse.getAttribute("httpResponseStatus"));
        if ("500".equals(response.getStatus())) {
            response.setFault(true);
        }
        response.setMediaType(mockResponse.getAttribute("mediaType"));
        return response;
    }

    private Request buildRequest(Element testRequest) throws MockRepositoryImportException, Exception {
        Request request = new Request();
        request.setName(testRequest.getAttribute(NAME_ATTRIBUTE));
        request.setContent(SoapUIProjectParserUtils.getConfigUniqueDirectChild(testRequest, REQUEST_TAG).getTextContent());
        request.setHeaders(this.buildHeaders(testRequest));
        if (SoapUIProjectParserUtils.hasConfigDirectChild(testRequest, "parameters")) {
            List<Element> entries = SoapUIProjectParserUtils.getConfigDirectChildren(SoapUIProjectParserUtils.getConfigUniqueDirectChild(testRequest, "parameters"), "entry");
            for (Element entry : entries) {
                Parameter param = new Parameter();
                param.setName(entry.getAttribute("key"));
                param.setValue(entry.getAttribute("value"));
                request.addQueryParameter(param);
            }
        }
        return request;
    }

    private Set<Header> buildHeaders(Element requestOrResponse) throws Exception {
        Element settingsElt = SoapUIProjectParserUtils.getConfigUniqueDirectChild(requestOrResponse, "settings");
        List<Element> settings = SoapUIProjectParserUtils.getConfigDirectChildren(settingsElt, "setting");
        for (Element setting : settings) {
            if (!setting.getAttribute("id").contains("@request-headers")) continue;
            String headersContent = setting.getTextContent();
            Element fragment = this.documentBuilder.parse(new InputSource(new StringReader(headersContent))).getDocumentElement();
            HashSet<Header> headers = new HashSet<Header>();
            if (headersContent.contains("xml-fragment")) {
                List<Element> entries = SoapUIProjectParserUtils.getConfigDirectChildren(fragment, "entry");
                for (Element entry : entries) {
                    Header header = new Header();
                    header.setName(entry.getAttribute("key"));
                    header.setValues(Set.of(entry.getAttribute("value")));
                    headers.add(header);
                }
            } else {
                Header header = new Header();
                header.setName(fragment.getAttribute("key"));
                header.setValues(Set.of(fragment.getAttribute("value")));
                headers.add(header);
            }
            return headers;
        }
        return null;
    }
}

