/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.util.openapi.OpenAPISchemaValidator;
import io.github.microcks.util.openapi.SwaggerSchemaValidator;
import io.github.microcks.util.test.HttpTestRunner;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public class OpenAPITestRunner
extends HttpTestRunner {
    private static Logger log = LoggerFactory.getLogger(OpenAPITestRunner.class);
    private static final String APPLICATION_JSON_TYPE = "application/json";
    private String resourceUrl = null;
    private ResourceRepository resourceRepository;
    private ResponseRepository responseRepository;
    private boolean validateResponseCode = false;
    private List<String> lastValidationErrors = null;

    public OpenAPITestRunner(ResourceRepository resourceRepository, ResponseRepository responseRepository, boolean validateResponseCode) {
        this.resourceRepository = resourceRepository;
        this.responseRepository = responseRepository;
        this.validateResponseCode = validateResponseCode;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.valueOf((String)method.toUpperCase());
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        Response expectedResponse;
        int code = 0;
        int responseCode = 0;
        try {
            responseCode = httpResponse.getStatusCode().value();
            log.debug("Response status code: {}", (Object)responseCode);
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            return 1;
        }
        String contentType = null;
        if (httpResponse.getHeaders().getContentType() != null) {
            contentType = httpResponse.getHeaders().getContentType().toString();
            log.debug("Response media-type is {}", (Object)httpResponse.getHeaders().getContentType());
            if (contentType.contains("charset=") && contentType.indexOf(";") > 0) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
        }
        if (this.validateResponseCode && (expectedResponse = (Response)this.responseRepository.findById(request.getResponseId()).orElse(null)) != null) {
            log.debug("Response expected status code: {}", (Object)expectedResponse.getStatus());
            if (!String.valueOf(responseCode).equals(expectedResponse.getStatus())) {
                log.debug("Response HttpStatus does not match expected one, returning failure");
                this.lastValidationErrors = List.of(String.format("Response HttpStatus does not match expected one. Expecting %s but got %d", expectedResponse.getStatus(), responseCode));
                return 1;
            }
            if (!expectedResponse.getMediaType().equalsIgnoreCase(contentType)) {
                log.debug("Response Content-Type does not match expected one, returning failure");
                this.lastValidationErrors = List.of(String.format("Response Content-Type does not match expected one. Expecting %s but got %s", expectedResponse.getMediaType(), contentType));
                return 1;
            }
        }
        if (responseCode != 204 && APPLICATION_JSON_TYPE.equals(contentType)) {
            boolean isOpenAPIv3 = true;
            Resource openapiSpecResource = null;
            List<Resource> resources = this.resourceRepository.findByServiceId(service.getId());
            for (Resource resource : resources) {
                if (ResourceType.OPEN_API_SPEC.equals((Object)resource.getType())) {
                    openapiSpecResource = resource;
                    break;
                }
                if (!ResourceType.SWAGGER.equals((Object)resource.getType())) continue;
                openapiSpecResource = resource;
                isOpenAPIv3 = false;
                break;
            }
            if (openapiSpecResource == null) {
                log.debug("Found no OpenAPI specification resource for service {} - {}, so failing validating", (Object)service.getId(), (Object)service.getName());
                return 1;
            }
            JsonNode openApiSpec = null;
            try {
                openApiSpec = OpenAPISchemaValidator.getJsonNodeForSchema((String)openapiSpecResource.getContent());
            }
            catch (IOException ioe) {
                log.debug("OpenAPI specification cannot be transformed into valid JsonNode schema, so failing");
                return 1;
            }
            String verb = operation.getName().split(" ")[0].toLowerCase();
            String path = operation.getName().split(" ")[1].trim();
            JsonNode contentNode = null;
            try {
                contentNode = OpenAPISchemaValidator.getJsonNode((String)responseContent);
            }
            catch (IOException ioe) {
                log.debug("Response body cannot be accessed or transformed as Json, returning failure");
                return 1;
            }
            String jsonPointer = "/paths/" + path.replace("/", "~1") + "/" + verb + "/responses/" + responseCode;
            this.lastValidationErrors = isOpenAPIv3 ? OpenAPISchemaValidator.validateJsonMessage((JsonNode)openApiSpec, (JsonNode)contentNode, (String)jsonPointer, (String)contentType, (String)this.resourceUrl) : SwaggerSchemaValidator.validateJsonMessage((JsonNode)openApiSpec, (JsonNode)contentNode, (String)jsonPointer, (String)this.resourceUrl);
            if (!this.lastValidationErrors.isEmpty()) {
                log.debug("OpenAPI schema validation errors found {}, marking test as failed.", (Object)this.lastValidationErrors.size());
                return 1;
            }
            log.debug("OpenAPI schema validation of response is successful !");
        }
        return code;
    }

    @Override
    protected String extractTestReturnMessage(Service service, Operation operation, Request request, ClientHttpResponse httpResponse) {
        StringBuilder builder = new StringBuilder();
        if (this.lastValidationErrors != null && !this.lastValidationErrors.isEmpty()) {
            for (String error : this.lastValidationErrors) {
                builder.append(error).append('\n');
            }
        }
        this.lastValidationErrors = null;
        return builder.toString();
    }
}

