/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DocumentationController {
    private static Logger log = LoggerFactory.getLogger(DocumentationController.class);
    private static final String RESOURCE_URL = "\\{RESOURCE_URL\\}";

    @RequestMapping(value={"/documentation/{name}/{resourceType}"}, method={RequestMethod.GET})
    public ResponseEntity<?> execute(@PathVariable(value="name") String name, @PathVariable(value="resourceType") String resourceType, HttpServletRequest request) {
        log.info("Requesting {} documentation for resource {}", (Object)resourceType, (Object)name);
        InputStream stream = null;
        HttpHeaders headers = new HttpHeaders();
        ClassPathResource template = null;
        if (ResourceType.OPEN_API_SPEC.toString().equals(resourceType) || ResourceType.SWAGGER.toString().equals(resourceType)) {
            template = new ClassPathResource("templates/redoc.html");
            headers.setContentType(MediaType.TEXT_HTML);
        } else if (ResourceType.ASYNC_API_SPEC.toString().equals(resourceType)) {
            template = new ClassPathResource("templates/asyncapi.html");
            headers.setContentType(MediaType.TEXT_HTML);
        }
        if (template != null) {
            try {
                stream = template.getInputStream();
            }
            catch (IOException e) {
                log.error("IOException while reading template " + template.getDescription(), (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringWriter writer = new StringWriter();
            try (Stream<String> lines = reader.lines();){
                lines.map(line -> this.replaceInLine((String)line, name)).forEach(line -> writer.write(line + "\n"));
            }
            return new ResponseEntity((Object)writer.toString().getBytes(), (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    private String replaceInLine(String line, String resourceName) {
        line = line.replaceAll(RESOURCE_URL, "/api/resources/" + resourceName);
        return line;
    }
}

