/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.dispatcher;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.util.dispatcher.DispatchCases;
import io.github.microcks.util.dispatcher.EvaluationOperator;
import io.github.microcks.util.dispatcher.JsonMappingException;

@JsonPropertyOrder(value={"exp", "operator", "cases"})
public class JsonEvaluationSpecification {
    private String exp;
    private EvaluationOperator operator;
    private DispatchCases cases;

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public EvaluationOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EvaluationOperator operator) {
        this.operator = operator;
    }

    public DispatchCases getCases() {
        return this.cases;
    }

    public void setCases(DispatchCases cases) {
        this.cases = cases;
    }

    public static JsonEvaluationSpecification buildFromJsonString(String jsonPayload) throws JsonMappingException {
        JsonEvaluationSpecification specification = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            specification = (JsonEvaluationSpecification)mapper.readValue(jsonPayload, JsonEvaluationSpecification.class);
        }
        catch (Exception e) {
            throw new JsonMappingException("Given JSON string cannot be interpreted as valid JsonEvaluationSpecification");
        }
        return specification;
    }
}

