/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.support.xml.XmlUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapMessageValidator {
    private static Logger log = LoggerFactory.getLogger(SoapMessageValidator.class);

    public static List<XmlError> validateSoapMessage(String partName, String partNamespace, String message, String wsdlUrl, boolean validateMessageBody) throws XmlException {
        WsdlContext ctx = new WsdlContext(wsdlUrl);
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        ctx.getSoapVersion().validateSoapEnvelope(message, errors);
        log.debug("SoapEnvelope validation errors: " + errors.size());
        if (validateMessageBody) {
            SchemaGlobalElement elm;
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            XmlObject xml = XmlUtils.createXmlObject((String)message, (XmlOptions)xmlOptions);
            String fullPartName = "{" + partNamespace + "}" + partName;
            XmlObject[] paths = xml.selectPath("declare namespace env='" + ctx.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + partNamespace + "';$this/env:Envelope/env:Body/ns:" + partName);
            try {
                elm = ctx.getSchemaTypeLoader().findElement(QName.valueOf(fullPartName));
            }
            catch (Exception e) {
                log.error("Exception while loading schema information for " + fullPartName, (Throwable)e);
                throw new XmlException("Exception while loading schema information for " + fullPartName, (Throwable)e);
            }
            if (elm != null) {
                SoapMessageValidator.validateMessageBody(ctx, errors, elm.getType(), paths[0]);
                NodeList children = XmlUtils.getChildElements((Element)((Element)paths[0].getDomNode().getParentNode()));
                for (int c = 0; c < children.getLength(); ++c) {
                    QName childName = XmlUtils.getQName((Node)children.item(c));
                    if (fullPartName.equals(childName.toString())) continue;
                    XmlCursor cur = paths[0].newCursor();
                    cur.toParent();
                    cur.toChild(childName);
                    errors.add(XmlError.forCursor((String)("Invalid element [" + childName + "] in SOAP Body"), (XmlCursor)cur));
                    cur.dispose();
                }
            }
            log.debug("SoapBody validation errors: " + errors.size());
        }
        return errors;
    }

    private static void validateMessageBody(WsdlContext ctx, List<XmlError> errors, SchemaType type, XmlObject msg) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
        XmlCursor cur = msg.newCursor();
        HashMap<String, String> map = new HashMap<String, String>();
        while (cur.hasNextToken()) {
            if (!cur.toNextToken().isNamespace()) continue;
            map.put(cur.getName().getLocalPart(), cur.getTextValue());
        }
        xmlOptions.setUseDefaultNamespace();
        xmlOptions.setSaveOuter();
        String xmlText = msg.copy().changeType(type).xmlText(xmlOptions);
        xmlOptions.setLoadAdditionalNamespaces(map);
        XmlObject obj = type.getTypeSystem().parse(xmlText, type, xmlOptions);
        obj = obj.changeType(type);
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(list);
        xmlOptions.setValidateTreatLaxAsSkip();
        try {
            obj.validate(xmlOptions);
        }
        catch (Exception e) {
            list.add((CallSite)((Object)("Internal Error - see error log for details - [" + e + "]")));
        }
        for (int c = 0; c < list.size(); ++c) {
            XmlError error = (XmlError)list.get(c);
            if (error instanceof XmlValidationError) {
                String text;
                XmlCursor cursor;
                XmlValidationError validationError = (XmlValidationError)error;
                if (ctx.getSoapVersion().shouldIgnore(validationError) || (validationError.getErrorCode().equals("base64Binary") || validationError.getErrorCode().equals("hexBinary")) && (cursor = validationError.getCursorLocation()).toParent() && ((text = cursor.getTextValue()).startsWith("cid:") || text.startsWith("file:"))) continue;
            }
            int line = error.getLine() == -1 ? 0 : error.getLine() - 1;
            errors.add(XmlError.forLocation((String)error.getMessage(), (String)error.getSourceName(), (int)(SoapMessageValidator.getLine(msg) + line), (int)error.getColumn(), (int)error.getOffset()));
        }
    }

    private static int getLine(XmlObject object) {
        ArrayList list = new ArrayList();
        object.newCursor().getAllBookmarkRefs(list);
        for (int c = 0; c < list.size(); ++c) {
            if (!(list.get(c) instanceof XmlLineNumber)) continue;
            return ((XmlLineNumber)list.get(c)).getLine();
        }
        return -1;
    }
}

