/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.TestCaseResult;
import io.github.microcks.domain.TestConformanceMetric;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestStepResult;
import io.github.microcks.domain.Trend;
import io.github.microcks.repository.TestConformanceMetricRepository;
import io.github.microcks.service.MessageService;
import io.github.microcks.util.IdBuilder;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Service;

@Service
@PropertySources(value={@PropertySource(value={"features.properties"}), @PropertySource(value={"file:/deployments/config/features.properties"}, ignoreResourceNotFound=true), @PropertySource(value={"application.properties"})})
public class MetricsService {
    private static Logger log = LoggerFactory.getLogger(MetricsService.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private TestConformanceMetricRepository metricRepository;
    @Value(value="${features.feature.repository-filter.label-key}")
    private final String filterLabelKey;
    @Value(value="${test-conformance.trend-size}")
    private final int testConformanceTrendSize = 3;
    @Value(value="${test-conformance.trend-history-size}")
    private final int testConformanceTrendHistorySize = 10;

    public MetricsService() {
        this.filterLabelKey = null;
    }

    public void configureTestConformanceMetric(io.github.microcks.domain.Service service) {
        TestConformanceMetric metric = this.metricRepository.findByServiceId(service.getId());
        if (metric == null) {
            log.debug("Creating a new TestCoverageMetric for Service '{}'", (Object)service.getId());
            metric = new TestConformanceMetric();
            metric.setServiceId(service.getId());
            metric.setLatestTrend(Trend.STABLE);
        }
        metric.setMaxPossibleScore(this.computeMaxPossibleConformanceScore(service));
        if (this.filterLabelKey != null && service.getMetadata().getLabels() != null) {
            metric.setAggregationLabelValue((String)service.getMetadata().getLabels().get(this.filterLabelKey));
        }
        this.metricRepository.save(metric);
    }

    public void removeTestConformanceMetric(String serviceId) {
        TestConformanceMetric metric = this.metricRepository.findByServiceId(serviceId);
        if (metric != null) {
            this.metricRepository.delete(metric);
        }
    }

    public void updateTestConformanceMetricOnTestResult(TestResult testResult) {
        TestConformanceMetric metric = this.metricRepository.findByServiceId(testResult.getServiceId());
        if (metric != null) {
            double currentScore = 0.0;
            if (testResult.isSuccess()) {
                currentScore = metric.getMaxPossibleScore();
            } else {
                int totalSteps = 0;
                int totalSuccess = 0;
                for (TestCaseResult caseResult : testResult.getTestCaseResults()) {
                    for (TestStepResult stepResult : caseResult.getTestStepResults()) {
                        if (stepResult.isSuccess()) {
                            ++totalSuccess;
                        }
                        ++totalSteps;
                    }
                }
                currentScore = metric.getMaxPossibleScore() * (double)(totalSuccess / totalSteps);
            }
            metric.setCurrentScore(currentScore);
            metric.setLastUpdateDay(this.getTodayAsString());
            if (metric.getLatestScores().size() >= 2) {
                List latestReversedScores = metric.getLatestScores().entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.reverseOrder())).collect(Collectors.toList());
                double globalAvg = latestReversedScores.stream().collect(Collectors.averagingDouble(Map.Entry::getValue));
                double latestAvg = currentScore;
                for (int i = 0; i < 2; ++i) {
                    latestAvg += ((Double)((Map.Entry)latestReversedScores.get(i)).getValue()).doubleValue();
                }
                double avgDiff = (latestAvg /= 3.0) - globalAvg;
                if (avgDiff >= 5.0) {
                    metric.setLatestTrend(Trend.UP);
                } else if (avgDiff < 5.0 && avgDiff >= 0.2) {
                    metric.setLatestTrend(Trend.LOW_UP);
                } else if (avgDiff < 0.2 && avgDiff > -0.2) {
                    metric.setLatestTrend(Trend.STABLE);
                } else if (avgDiff <= -0.2 && avgDiff > -5.0) {
                    metric.setLatestTrend(Trend.LOW_DOWN);
                } else if (avgDiff <= -5.0) {
                    metric.setLatestTrend(Trend.DOWN);
                }
                while (latestReversedScores.size() >= 10) {
                    Map.Entry lastEntry = (Map.Entry)latestReversedScores.get(latestReversedScores.size() - 1);
                    metric.getLatestScores().remove(lastEntry.getKey());
                    latestReversedScores.remove(latestReversedScores.size() - 1);
                }
                metric.getLatestScores().put(metric.getLastUpdateDay(), currentScore);
            }
            this.metricRepository.save(metric);
        }
    }

    private double computeMaxPossibleConformanceScore(io.github.microcks.domain.Service service) {
        double maxScore = 0.0;
        double operationContrib = 100 / service.getOperations().size();
        for (Operation operation : service.getOperations()) {
            List<Object> exchanges = ServiceType.EVENT.equals((Object)service.getType()) || ServiceType.GENERIC_EVENT.equals((Object)service.getType()) ? this.messageService.getEventByOperation(IdBuilder.buildOperationId((io.github.microcks.domain.Service)service, (Operation)operation)) : this.messageService.getRequestResponseByOperation(IdBuilder.buildOperationId((io.github.microcks.domain.Service)service, (Operation)operation));
            if (exchanges == null) continue;
            if (exchanges.size() >= 2) {
                maxScore += operationContrib;
                continue;
            }
            if (exchanges.size() != 1) continue;
            maxScore += operationContrib / 2.0;
        }
        return maxScore;
    }

    private String getTodayAsString() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + String.valueOf(month);
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + String.valueOf(dayOfMonth);
        return calendar.get(1) + monthStr + dayOfMonthStr;
    }
}

