/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.repository.EventMessageRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResponseRepository;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageService {
    private static Logger log = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private EventMessageRepository eventMessageRepository;

    public List<UnidirectionalEvent> getEventByOperation(String operationId) {
        List<EventMessage> eventMessages = this.eventMessageRepository.findByOperationId(operationId);
        if (log.isDebugEnabled()) {
            log.debug("Found " + eventMessages.size() + " event(s) for operation " + operationId);
        }
        ArrayList<UnidirectionalEvent> results = new ArrayList<UnidirectionalEvent>(eventMessages.size());
        for (EventMessage eventMessage : eventMessages) {
            results.add(new UnidirectionalEvent(eventMessage));
        }
        return results;
    }

    public List<RequestResponsePair> getRequestResponseByOperation(String operationId) {
        List<Request> requests = this.requestRepository.findByOperationId(operationId);
        List<Response> responses = this.responseRepository.findByOperationId(operationId);
        if (log.isDebugEnabled()) {
            log.debug("Found " + requests.size() + " request(s) for operation " + operationId);
            log.debug("Found " + responses.size() + " response(s) for operation " + operationId);
        }
        List<RequestResponsePair> results = this.associatePairs(requests, responses);
        if (log.isDebugEnabled()) {
            log.debug("Emitting " + results.size() + " request/response pair(s) as result");
        }
        return results;
    }

    public List<UnidirectionalEvent> getEventByTestCase(String testCaseId) {
        List<EventMessage> eventMessages = this.eventMessageRepository.findByTestCaseId(testCaseId);
        if (log.isDebugEnabled()) {
            log.debug("Found " + eventMessages.size() + " event(s) for testCase " + testCaseId);
        }
        ArrayList<UnidirectionalEvent> results = new ArrayList<UnidirectionalEvent>(eventMessages.size());
        for (EventMessage eventMessage : eventMessages) {
            results.add(new UnidirectionalEvent(eventMessage));
        }
        return results;
    }

    public List<RequestResponsePair> getRequestResponseByTestCase(String testCaseId) {
        List<Request> requests = this.requestRepository.findByTestCaseId(testCaseId);
        List<Response> responses = this.responseRepository.findByTestCaseId(testCaseId);
        if (log.isDebugEnabled()) {
            log.debug("Found " + requests.size() + " request(s) for testCase " + testCaseId);
            log.debug("Found " + responses.size() + " response(s) for testCase " + testCaseId);
        }
        List<RequestResponsePair> results = this.associatePairs(requests, responses);
        if (log.isDebugEnabled()) {
            log.debug("Emitting " + results.size() + " request/response pair(s) as result");
        }
        return results;
    }

    private List<RequestResponsePair> associatePairs(List<Request> requests, List<Response> responses) {
        ArrayList<RequestResponsePair> results = new ArrayList<RequestResponsePair>();
        block0: for (Request request : requests) {
            for (Response response : responses) {
                if (request.getResponseId() == null || !request.getResponseId().equals(response.getId())) continue;
                results.add(new RequestResponsePair(request, response));
                continue block0;
            }
        }
        return results;
    }
}

