/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.security.EnableUserInfoInContext;
import io.github.microcks.security.KeycloakTokenToUserInfoMapper;
import io.github.microcks.security.UserInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class UserInfoInContextInterceptor
implements HandlerInterceptor {
    private static Logger log = LoggerFactory.getLogger(UserInfoInContextInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.debug("Intercepting and pre-handling request to check @EnableUserInfoInContext");
        if (handler instanceof HandlerMethod) {
            EnableUserInfoInContext needUserInfo = (EnableUserInfoInContext)((HandlerMethod)handler).getMethodAnnotation(EnableUserInfoInContext.class);
            if (needUserInfo == null) {
                needUserInfo = ((HandlerMethod)handler).getMethod().getDeclaringClass().getAnnotation(EnableUserInfoInContext.class);
            }
            if (needUserInfo == null) {
                return true;
            }
            log.debug("@EnableUserInfoInContext is present on {}", handler);
            Object ksc = request.getAttribute(KeycloakSecurityContext.class.getName());
            if (ksc != null) {
                log.debug("Found a KeycloakSecurityContext to map to UserInfo");
                KeycloakSecurityContext context = (KeycloakSecurityContext)KeycloakSecurityContext.class.cast(ksc);
                UserInfo userInfo = KeycloakTokenToUserInfoMapper.map(context);
                request.setAttribute(UserInfo.class.getName(), (Object)userInfo);
            }
        }
        return super.preHandle(request, response, handler);
    }
}

