/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.security.UserInfo;
import java.util.Arrays;
import java.util.List;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakTokenToUserInfoMapper {
    private static Logger log = LoggerFactory.getLogger(KeycloakTokenToUserInfoMapper.class);
    public static final String MICROCKS_GROUPS_TOKEN_CLAIM = "microcks-groups";
    public static final String MICROCKS_APP_RESOURCE = "microcks-app";

    public static UserInfo map(KeycloakSecurityContext context) {
        AccessToken token = context.getToken();
        String[] microcksGroups = null;
        Object groups = context.getToken().getOtherClaims().get(MICROCKS_GROUPS_TOKEN_CLAIM);
        if (groups instanceof List) {
            Object[] objGroups = ((List)groups).toArray();
            microcksGroups = (String[])Arrays.copyOf(objGroups, objGroups.length, String[].class);
        }
        UserInfo userInfo = new UserInfo(token.getName(), token.getPreferredUsername(), token.getGivenName(), token.getFamilyName(), token.getEmail(), (String[])token.getResourceAccess(MICROCKS_APP_RESOURCE).getRoles().stream().toArray(String[]::new), microcksGroups);
        log.debug("Current user is: " + userInfo);
        return userInfo;
    }
}

