/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.repository;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.repository.CustomImportJobRepository;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ImportJobRepositoryImpl
implements CustomImportJobRepository {
    private static Logger log = LoggerFactory.getLogger(ImportJobRepositoryImpl.class);
    @Autowired
    private MongoTemplate template;

    @Override
    public List<ImportJob> findByLabels(Map<String, String> labels) {
        Query query = new Query();
        for (String labelKey : labels.keySet()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("metadata.labels." + labelKey)).is((Object)labels.get(labelKey)));
        }
        List results = this.template.find(query, ImportJob.class);
        return results;
    }

    @Override
    public List<ImportJob> findByLabelsAndNameLike(Map<String, String> labels, String name) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"name").regex(name, "i"));
        for (String labelKey : labels.keySet()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("metadata.labels." + labelKey)).is((Object)labels.get(labelKey)));
        }
        List results = this.template.find(query, ImportJob.class);
        return results;
    }
}

