/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.util.openapi.OpenAPISchemaValidator;
import io.github.microcks.util.openapi.SwaggerSchemaValidator;
import io.github.microcks.util.test.HttpTestRunner;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public class OpenAPITestRunner
extends HttpTestRunner {
    private static final Logger log = LoggerFactory.getLogger(OpenAPITestRunner.class);
    public static final Pattern APPLICATION_JSON_TYPES_PATTERN = Pattern.compile("application/.*json");
    private final ResourceRepository resourceRepository;
    private final ResponseRepository responseRepository;
    private final boolean validateResponseCode;
    private String resourceUrl = null;
    private List<String> lastValidationErrors = null;

    public OpenAPITestRunner(ResourceRepository resourceRepository, ResponseRepository responseRepository, boolean validateResponseCode) {
        this.resourceRepository = resourceRepository;
        this.responseRepository = responseRepository;
        this.validateResponseCode = validateResponseCode;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.valueOf((String)method.toUpperCase());
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        Response expectedResponse;
        int code = 0;
        int responseCode = 0;
        try {
            responseCode = httpResponse.getStatusCode().value();
            log.debug("Response status code: {}", (Object)responseCode);
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            return 1;
        }
        String contentType = null;
        if (httpResponse.getHeaders().getContentType() != null) {
            contentType = httpResponse.getHeaders().getContentType().toString();
            log.debug("Response media-type is {}", (Object)httpResponse.getHeaders().getContentType());
        }
        if (this.validateResponseCode && (expectedResponse = (Response)this.responseRepository.findById(request.getResponseId()).orElse(null)) != null) {
            log.debug("Response expected status code: {}", (Object)expectedResponse.getStatus());
            if (!String.valueOf(responseCode).equals(expectedResponse.getStatus())) {
                log.debug("Response HttpStatus does not match expected one, returning failure");
                this.lastValidationErrors = List.of(String.format("Response HttpStatus does not match expected one. Expecting %s but got %d", expectedResponse.getStatus(), responseCode));
                return 1;
            }
            if (expectedResponse.getMediaType() != null && !this.contentTypesAreEquivalent(expectedResponse.getMediaType(), contentType)) {
                log.debug("Response Content-Type does not match expected one, returning failure");
                this.lastValidationErrors = List.of(String.format("Response Content-Type does not match expected one. Expecting %s but got %s", expectedResponse.getMediaType(), contentType));
                return 1;
            }
        }
        String shortContentType = this.getShortContentType(contentType);
        if (responseCode != 204 && shortContentType != null && APPLICATION_JSON_TYPES_PATTERN.matcher(shortContentType).matches()) {
            boolean isOpenAPIv3 = true;
            Resource openapiSpecResource = this.findResourceCandidate(service);
            if (openapiSpecResource == null) {
                log.debug("Found no OpenAPI specification resource for service {} - {}, so failing validating", (Object)service.getId(), (Object)service.getName());
                return 1;
            }
            if (ResourceType.SWAGGER.equals((Object)openapiSpecResource.getType())) {
                isOpenAPIv3 = false;
            }
            JsonNode openApiSpec = null;
            try {
                openApiSpec = OpenAPISchemaValidator.getJsonNodeForSchema((String)openapiSpecResource.getContent());
            }
            catch (IOException ioe) {
                log.debug("OpenAPI specification cannot be transformed into valid JsonNode schema, so failing");
                return 1;
            }
            String verb = operation.getName().split(" ")[0].toLowerCase();
            String path = operation.getName().split(" ")[1].trim();
            JsonNode contentNode = null;
            try {
                contentNode = OpenAPISchemaValidator.getJsonNode((String)responseContent);
            }
            catch (IOException ioe) {
                log.debug("Response body cannot be accessed or transformed as Json, returning failure");
                return 1;
            }
            String jsonPointer = "/paths/" + path.replace("/", "~1") + "/" + verb + "/responses/" + responseCode;
            this.lastValidationErrors = isOpenAPIv3 ? OpenAPISchemaValidator.validateJsonMessage((JsonNode)openApiSpec, (JsonNode)contentNode, (String)jsonPointer, (String)contentType, (String)this.resourceUrl) : SwaggerSchemaValidator.validateJsonMessage((JsonNode)openApiSpec, (JsonNode)contentNode, (String)jsonPointer, (String)this.resourceUrl);
            if (!this.lastValidationErrors.isEmpty()) {
                log.debug("OpenAPI schema validation errors found {}, marking test as failed.", (Object)this.lastValidationErrors.size());
                return 1;
            }
            log.debug("OpenAPI schema validation of response is successful !");
        }
        return code;
    }

    @Override
    protected String extractTestReturnMessage(Service service, Operation operation, Request request, ClientHttpResponse httpResponse) {
        StringBuilder builder = new StringBuilder();
        if (this.lastValidationErrors != null && !this.lastValidationErrors.isEmpty()) {
            for (String error : this.lastValidationErrors) {
                builder.append(error).append('\n');
            }
        }
        this.lastValidationErrors = null;
        return builder.toString();
    }

    private boolean contentTypesAreEquivalent(String expectedContentType, String responseContentType) {
        if (responseContentType != null) {
            if (expectedContentType.contains("charset=")) {
                return expectedContentType.replace(" ", "").equalsIgnoreCase(responseContentType.replace(" ", ""));
            }
            String shortResponseContentType = this.getShortContentType(responseContentType);
            return expectedContentType.equalsIgnoreCase(shortResponseContentType);
        }
        return false;
    }

    private String getShortContentType(String contentType) {
        if (contentType != null && contentType.contains("charset=") && contentType.indexOf(";") > 0) {
            return contentType.substring(0, contentType.indexOf(";"));
        }
        return contentType;
    }

    private Resource findResourceCandidate(Service service) {
        Optional<Object> candidate = Optional.empty();
        List<Resource> resources = this.resourceRepository.findMainByServiceId(service.getId());
        if (!resources.isEmpty()) {
            candidate = this.getResourceCandidate(resources);
        }
        if (candidate.isEmpty() && !(resources = this.resourceRepository.findByServiceId(service.getId())).isEmpty()) {
            candidate = this.getResourceCandidate(resources);
        }
        return candidate.orElse(null);
    }

    private Optional<Resource> getResourceCandidate(List<Resource> resources) {
        return resources.stream().filter(r -> ResourceType.OPEN_API_SPEC.equals((Object)r.getType()) || ResourceType.SWAGGER.equals((Object)r.getType())).findFirst();
    }
}

