/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.property;

import com.gobrs.async.core.common.def.DefaultConfig;
import com.gobrs.async.core.property.GobbrsPropertySourceFactory;
import com.gobrs.async.core.property.PlatformConfig;
import com.gobrs.async.core.property.RuleConfig;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="gobrs.async.config", ignoreInvalidFields=false)
@PropertySource(value={"classpath:config/gobrs.yaml", "classpath:config/gobrs.yml", "classpath:config/gobrs.properties"}, ignoreResourceNotFound=false, factory=GobbrsPropertySourceFactory.class)
@Component
public class GobrsAsyncProperties {
    public static final String PREFIX = "gobrs.async.config";
    private boolean enable;
    private List<RuleConfig> rules;
    private PlatformConfig platform;
    private String split = ";";
    private String point = "->";
    private ThreadPool threadPool;
    private Integer timeoutCoreSize;
    private boolean paramContext = true;
    private boolean catchable;
    private long timeout = 3000L;
    private boolean relyDepend = false;

    public boolean isEnable() {
        return this.enable;
    }

    public List<RuleConfig> getRules() {
        return this.rules;
    }

    public PlatformConfig getPlatform() {
        return this.platform;
    }

    public String getSplit() {
        return this.split;
    }

    public String getPoint() {
        return this.point;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Integer getTimeoutCoreSize() {
        return this.timeoutCoreSize;
    }

    public boolean isParamContext() {
        return this.paramContext;
    }

    public boolean isCatchable() {
        return this.catchable;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRelyDepend() {
        return this.relyDepend;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRules(List<RuleConfig> rules) {
        this.rules = rules;
    }

    public void setPlatform(PlatformConfig platform) {
        this.platform = platform;
    }

    public void setSplit(String split) {
        this.split = split;
    }

    public void setPoint(String point) {
        this.point = point;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setTimeoutCoreSize(Integer timeoutCoreSize) {
        this.timeoutCoreSize = timeoutCoreSize;
    }

    public void setParamContext(boolean paramContext) {
        this.paramContext = paramContext;
    }

    public void setCatchable(boolean catchable) {
        this.catchable = catchable;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setRelyDepend(boolean relyDepend) {
        this.relyDepend = relyDepend;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GobrsAsyncProperties)) {
            return false;
        }
        GobrsAsyncProperties other = (GobrsAsyncProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isParamContext() != other.isParamContext()) {
            return false;
        }
        if (this.isCatchable() != other.isCatchable()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.isRelyDepend() != other.isRelyDepend()) {
            return false;
        }
        Integer this$timeoutCoreSize = this.getTimeoutCoreSize();
        Integer other$timeoutCoreSize = other.getTimeoutCoreSize();
        if (this$timeoutCoreSize == null ? other$timeoutCoreSize != null : !((Object)this$timeoutCoreSize).equals(other$timeoutCoreSize)) {
            return false;
        }
        List<RuleConfig> this$rules = this.getRules();
        List<RuleConfig> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        PlatformConfig this$platform = this.getPlatform();
        PlatformConfig other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !((Object)this$platform).equals(other$platform)) {
            return false;
        }
        String this$split = this.getSplit();
        String other$split = other.getSplit();
        if (this$split == null ? other$split != null : !this$split.equals(other$split)) {
            return false;
        }
        String this$point = this.getPoint();
        String other$point = other.getPoint();
        if (this$point == null ? other$point != null : !this$point.equals(other$point)) {
            return false;
        }
        ThreadPool this$threadPool = this.getThreadPool();
        ThreadPool other$threadPool = other.getThreadPool();
        return !(this$threadPool == null ? other$threadPool != null : !((Object)this$threadPool).equals(other$threadPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GobrsAsyncProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isParamContext() ? 79 : 97);
        result = result * 59 + (this.isCatchable() ? 79 : 97);
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        result = result * 59 + (this.isRelyDepend() ? 79 : 97);
        Integer $timeoutCoreSize = this.getTimeoutCoreSize();
        result = result * 59 + ($timeoutCoreSize == null ? 43 : ((Object)$timeoutCoreSize).hashCode());
        List<RuleConfig> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        PlatformConfig $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : ((Object)$platform).hashCode());
        String $split = this.getSplit();
        result = result * 59 + ($split == null ? 43 : $split.hashCode());
        String $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        ThreadPool $threadPool = this.getThreadPool();
        result = result * 59 + ($threadPool == null ? 43 : ((Object)$threadPool).hashCode());
        return result;
    }

    public String toString() {
        return "GobrsAsyncProperties(enable=" + this.isEnable() + ", rules=" + this.getRules() + ", platform=" + this.getPlatform() + ", split=" + this.getSplit() + ", point=" + this.getPoint() + ", threadPool=" + this.getThreadPool() + ", timeoutCoreSize=" + this.getTimeoutCoreSize() + ", paramContext=" + this.isParamContext() + ", catchable=" + this.isCatchable() + ", timeout=" + this.getTimeout() + ", relyDepend=" + this.isRelyDepend() + ")";
    }

    public static class ThreadPool {
        private Integer corePoolSize = this.calculateCoreNum();
        private Integer maxPoolSize = this.corePoolSize + (this.corePoolSize >> 1);
        private Long keepAliveTime = DefaultConfig.KEEPALIVETIME;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private Long executeTimeOut = DefaultConfig.EXECUTETIMEOUT;
        private Integer capacity = DefaultConfig.THREADPOOLQUEUESIZE;
        private BlockingQueue workQueue = new LinkedBlockingQueue(this.capacity);
        private String rejectedExecutionHandler = "AbortPolicy";
        private String threadNamePrefix;
        private Boolean allowCoreThreadTimeOut = false;

        private Integer calculateCoreNum() {
            int cpuCoreNum = Runtime.getRuntime().availableProcessors();
            return new BigDecimal(cpuCoreNum).divide(new BigDecimal("0.2")).intValue();
        }

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Integer getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Long getExecuteTimeOut() {
            return this.executeTimeOut;
        }

        public Integer getCapacity() {
            return this.capacity;
        }

        public BlockingQueue getWorkQueue() {
            return this.workQueue;
        }

        public String getRejectedExecutionHandler() {
            return this.rejectedExecutionHandler;
        }

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }

        public Boolean getAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(Integer maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setExecuteTimeOut(Long executeTimeOut) {
            this.executeTimeOut = executeTimeOut;
        }

        public void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        public void setWorkQueue(BlockingQueue workQueue) {
            this.workQueue = workQueue;
        }

        public void setRejectedExecutionHandler(String rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
        }

        public void setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPool)) {
                return false;
            }
            ThreadPool other = (ThreadPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$corePoolSize = this.getCorePoolSize();
            Integer other$corePoolSize = other.getCorePoolSize();
            if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
                return false;
            }
            Integer this$maxPoolSize = this.getMaxPoolSize();
            Integer other$maxPoolSize = other.getMaxPoolSize();
            if (this$maxPoolSize == null ? other$maxPoolSize != null : !((Object)this$maxPoolSize).equals(other$maxPoolSize)) {
                return false;
            }
            Long this$keepAliveTime = this.getKeepAliveTime();
            Long other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            Long this$executeTimeOut = this.getExecuteTimeOut();
            Long other$executeTimeOut = other.getExecuteTimeOut();
            if (this$executeTimeOut == null ? other$executeTimeOut != null : !((Object)this$executeTimeOut).equals(other$executeTimeOut)) {
                return false;
            }
            Integer this$capacity = this.getCapacity();
            Integer other$capacity = other.getCapacity();
            if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
                return false;
            }
            Boolean this$allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            Boolean other$allowCoreThreadTimeOut = other.getAllowCoreThreadTimeOut();
            if (this$allowCoreThreadTimeOut == null ? other$allowCoreThreadTimeOut != null : !((Object)this$allowCoreThreadTimeOut).equals(other$allowCoreThreadTimeOut)) {
                return false;
            }
            TimeUnit this$timeUnit = this.getTimeUnit();
            TimeUnit other$timeUnit = other.getTimeUnit();
            if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
                return false;
            }
            BlockingQueue this$workQueue = this.getWorkQueue();
            BlockingQueue other$workQueue = other.getWorkQueue();
            if (this$workQueue == null ? other$workQueue != null : !this$workQueue.equals(other$workQueue)) {
                return false;
            }
            String this$rejectedExecutionHandler = this.getRejectedExecutionHandler();
            String other$rejectedExecutionHandler = other.getRejectedExecutionHandler();
            if (this$rejectedExecutionHandler == null ? other$rejectedExecutionHandler != null : !this$rejectedExecutionHandler.equals(other$rejectedExecutionHandler)) {
                return false;
            }
            String this$threadNamePrefix = this.getThreadNamePrefix();
            String other$threadNamePrefix = other.getThreadNamePrefix();
            return !(this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $corePoolSize = this.getCorePoolSize();
            result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
            Integer $maxPoolSize = this.getMaxPoolSize();
            result = result * 59 + ($maxPoolSize == null ? 43 : ((Object)$maxPoolSize).hashCode());
            Long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            Long $executeTimeOut = this.getExecuteTimeOut();
            result = result * 59 + ($executeTimeOut == null ? 43 : ((Object)$executeTimeOut).hashCode());
            Integer $capacity = this.getCapacity();
            result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
            Boolean $allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            result = result * 59 + ($allowCoreThreadTimeOut == null ? 43 : ((Object)$allowCoreThreadTimeOut).hashCode());
            TimeUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
            BlockingQueue $workQueue = this.getWorkQueue();
            result = result * 59 + ($workQueue == null ? 43 : $workQueue.hashCode());
            String $rejectedExecutionHandler = this.getRejectedExecutionHandler();
            result = result * 59 + ($rejectedExecutionHandler == null ? 43 : $rejectedExecutionHandler.hashCode());
            String $threadNamePrefix = this.getThreadNamePrefix();
            result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
            return result;
        }

        public String toString() {
            return "GobrsAsyncProperties.ThreadPool(corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", executeTimeOut=" + this.getExecuteTimeOut() + ", capacity=" + this.getCapacity() + ", workQueue=" + this.getWorkQueue() + ", rejectedExecutionHandler=" + this.getRejectedExecutionHandler() + ", threadNamePrefix=" + this.getThreadNamePrefix() + ", allowCoreThreadTimeOut=" + this.getAllowCoreThreadTimeOut() + ")";
        }
    }
}

