/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import io.github.memfis19.annca.R;
import io.github.memfis19.annca.internal.utils.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MediaActionSwitchView
extends ImageButton {
    public static final int ACTION_PHOTO = 0;
    public static final int ACTION_VIDEO = 1;
    private int currentMediaActionState = 0;
    private OnMediaActionStateChangeListener onMediaActionStateChangeListener;
    private Context context;
    private Drawable photoDrawable;
    private Drawable videoDrawable;
    private int padding = 5;

    public MediaActionSwitchView(Context context) {
        this(context, null);
    }

    public MediaActionSwitchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initializeView();
    }

    public MediaActionSwitchView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs);
    }

    private void initializeView() {
        this.photoDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_photo_camera_white_24dp);
        this.photoDrawable = DrawableCompat.wrap((Drawable)this.photoDrawable);
        DrawableCompat.setTintList((Drawable)this.photoDrawable.mutate(), (ColorStateList)ContextCompat.getColorStateList((Context)this.context, (int)R.drawable.switch_camera_mode_selector));
        this.videoDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_videocam_white_24dp);
        this.videoDrawable = DrawableCompat.wrap((Drawable)this.videoDrawable);
        DrawableCompat.setTintList((Drawable)this.videoDrawable.mutate(), (ColorStateList)ContextCompat.getColorStateList((Context)this.context, (int)R.drawable.switch_camera_mode_selector));
        this.setBackgroundResource(R.drawable.circle_frame_background_dark);
        this.setOnClickListener(new MediaActionClickListener());
        this.setIcons();
        this.padding = Utils.convertDipToPixels(this.context, this.padding);
        this.setPadding(this.padding, this.padding, this.padding, this.padding);
    }

    private void setIcons() {
        if (this.currentMediaActionState == 0) {
            this.setImageDrawable(this.videoDrawable);
        } else {
            this.setImageDrawable(this.photoDrawable);
        }
    }

    public void setMediaActionState(int currentMediaActionState) {
        this.currentMediaActionState = currentMediaActionState;
        this.setIcons();
    }

    public void setOnMediaActionStateChangeListener(OnMediaActionStateChangeListener onMediaActionStateChangeListener) {
        this.onMediaActionStateChangeListener = onMediaActionStateChangeListener;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (Build.VERSION.SDK_INT > 10) {
            if (enabled) {
                this.setAlpha(1.0f);
            } else {
                this.setAlpha(0.5f);
            }
        }
    }

    private class MediaActionClickListener
    implements View.OnClickListener {
        private MediaActionClickListener() {
        }

        public void onClick(View view) {
            if (MediaActionSwitchView.this.currentMediaActionState == 0) {
                MediaActionSwitchView.this.currentMediaActionState = 1;
            } else {
                MediaActionSwitchView.this.currentMediaActionState = 0;
            }
            MediaActionSwitchView.this.setIcons();
            if (MediaActionSwitchView.this.onMediaActionStateChangeListener != null) {
                MediaActionSwitchView.this.onMediaActionStateChangeListener.onMediaActionChanged(MediaActionSwitchView.this.currentMediaActionState);
            }
        }
    }

    public static interface OnMediaActionStateChangeListener {
        public void onMediaActionChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaActionState {
    }
}

