/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.controller.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Bundle;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.controller.CameraController;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.manager.CameraManager;
import io.github.memfis19.annca.internal.manager.impl.Camera2Manager;
import io.github.memfis19.annca.internal.manager.listener.CameraCloseListener;
import io.github.memfis19.annca.internal.manager.listener.CameraOpenListener;
import io.github.memfis19.annca.internal.manager.listener.CameraPhotoListener;
import io.github.memfis19.annca.internal.manager.listener.CameraVideoListener;
import io.github.memfis19.annca.internal.ui.view.AutoFitTextureView;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import io.github.memfis19.annca.internal.utils.Size;
import java.io.File;

@TargetApi(value=21)
public class Camera2Controller
implements CameraController<String>,
CameraOpenListener<String, TextureView.SurfaceTextureListener>,
CameraPhotoListener,
CameraVideoListener,
CameraCloseListener<String> {
    private static final String TAG = "Camera2Controller";
    private String currentCameraId;
    private ConfigurationProvider configurationProvider;
    private CameraManager<String, TextureView.SurfaceTextureListener, CaptureRequest.Builder, CameraDevice> camera2Manager;
    private CameraView cameraView;
    private File outputFile;

    public Camera2Controller(CameraView cameraView, ConfigurationProvider configurationProvider) {
        this.cameraView = cameraView;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.camera2Manager = Camera2Manager.getInstance();
        this.camera2Manager.initializeCameraManager(this.configurationProvider, (Context)this.cameraView.getActivity());
        this.currentCameraId = this.camera2Manager.getFaceBackCameraId();
    }

    @Override
    public void onResume() {
        this.camera2Manager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onPause() {
        this.camera2Manager.closeCamera(null);
        this.cameraView.releaseCameraPreview();
    }

    @Override
    public void onDestroy() {
        this.camera2Manager.releaseCameraManager();
    }

    @Override
    public void takePhoto() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 101);
        this.camera2Manager.takePhoto(this.outputFile, this);
    }

    @Override
    public void startVideoRecord() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 100);
        this.camera2Manager.startVideoRecord(this.outputFile, this);
    }

    @Override
    public void stopVideoRecord() {
        this.camera2Manager.stopVideoRecord();
    }

    @Override
    public boolean isVideoRecording() {
        return this.camera2Manager.isVideoRecording();
    }

    @Override
    public void switchCamera(int cameraFace) {
        this.currentCameraId = this.camera2Manager.getCurrentCameraId().equals(this.camera2Manager.getFaceFrontCameraId()) ? this.camera2Manager.getFaceBackCameraId() : this.camera2Manager.getFaceFrontCameraId();
        this.camera2Manager.closeCamera(this);
    }

    @Override
    public void setFlashMode(int flashMode) {
        this.camera2Manager.setFlashMode(flashMode);
    }

    @Override
    public void switchQuality() {
        this.camera2Manager.closeCamera(this);
    }

    @Override
    public int getNumberOfCameras() {
        return this.camera2Manager.getNumberOfCameras();
    }

    @Override
    public int getMediaAction() {
        return this.configurationProvider.getMediaAction();
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public String getCurrentCameraId() {
        return this.currentCameraId;
    }

    @Override
    public void onCameraOpened(String openedCameraId, Size previewSize, TextureView.SurfaceTextureListener surfaceTextureListener) {
        this.cameraView.updateUiForMediaAction(102);
        this.cameraView.updateCameraPreview(previewSize, (View)new AutoFitTextureView((Context)this.cameraView.getActivity(), surfaceTextureListener));
        this.cameraView.updateCameraSwitcher(this.camera2Manager.getNumberOfCameras());
    }

    @Override
    public void onCameraReady() {
        this.cameraView.onCameraReady();
    }

    @Override
    public void onCameraOpenError() {
        Log.e((String)TAG, (String)"onCameraOpenError");
    }

    @Override
    public void onCameraClosed(String closedCameraId) {
        this.cameraView.releaseCameraPreview();
        this.camera2Manager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onPhotoTaken(File photoFile) {
        this.cameraView.onPhotoTaken();
    }

    @Override
    public void onPhotoTakeError() {
    }

    @Override
    public void onVideoRecordStarted(Size videoSize) {
        this.cameraView.onVideoRecordStart(videoSize.getWidth(), videoSize.getHeight());
    }

    @Override
    public void onVideoRecordStopped(File videoFile) {
        this.cameraView.onVideoRecordStop();
    }

    @Override
    public void onVideoRecordError() {
    }

    @Override
    public CameraManager getCameraManager() {
        return this.camera2Manager;
    }
}

