/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ExifInterface;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageView;
import java.io.IOException;

public final class AnncaImageLoader {
    private static final String TAG = "AnncaImageLoader";
    private Context context;
    private String url;

    private AnncaImageLoader(Context context) {
        this.context = context;
    }

    public void into(final ImageView target) {
        ViewTreeObserver viewTreeObserver = target.getViewTreeObserver();
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                target.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                new ImageLoaderThread(target, AnncaImageLoader.this.url).start();
                return true;
            }
        });
    }

    private class ImageLoaderThread
    extends Thread {
        private ImageView target;
        private String url;
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private ImageLoaderThread(ImageView target, String url) {
            this.target = target;
            this.url = url;
        }

        @Override
        public void run() {
            int imageViewWidth;
            int imageViewHeight;
            Process.setThreadPriority((int)10);
            WindowManager windowManager = (WindowManager)AnncaImageLoader.this.context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            if (Build.VERSION.SDK_INT < 13) {
                imageViewHeight = display.getHeight();
                imageViewWidth = display.getWidth();
            } else {
                Point size = new Point();
                display.getSize(size);
                imageViewHeight = size.y;
                imageViewWidth = size.x;
            }
            Bitmap decodedBitmap = this.decodeSampledBitmapFromResource(this.url, imageViewWidth, imageViewHeight);
            final Bitmap resultBitmap = this.rotateBitmap(decodedBitmap, this.getExifOrientation());
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    ImageLoaderThread.this.target.setImageBitmap(resultBitmap);
                }
            });
        }

        private Bitmap rotateBitmap(Bitmap bitmap, int orientation) {
            Matrix matrix = new Matrix();
            switch (orientation) {
                case 1: {
                    return bitmap;
                }
                case 2: {
                    matrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 3: {
                    matrix.setRotate(180.0f);
                    break;
                }
                case 4: {
                    matrix.setRotate(180.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 5: {
                    matrix.setRotate(90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 6: {
                    matrix.setRotate(90.0f);
                    break;
                }
                case 7: {
                    matrix.setRotate(-90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 8: {
                    matrix.setRotate(-90.0f);
                    break;
                }
                default: {
                    return bitmap;
                }
            }
            try {
                Bitmap bmRotated = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                return bmRotated;
            }
            catch (OutOfMemoryError ignore) {
                return null;
            }
        }

        private int getExifOrientation() {
            ExifInterface exif = null;
            try {
                exif = new ExifInterface(this.url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return exif == null ? 0 : exif.getAttributeInt("Orientation", 0);
        }

        private Bitmap decodeSampledBitmapFromResource(String url, int requestedWidth, int requestedHeight) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)options);
            options.inSampleSize = this.calculateInSampleSize(options, requestedWidth, requestedHeight);
            options.inJustDecodeBounds = false;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            return BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)options);
        }

        private int calculateInSampleSize(BitmapFactory.Options options, int requestedWidth, int requestedHeight) {
            int height = options.outHeight;
            int width = options.outWidth;
            int inSampleSize = 1;
            if (height > requestedHeight || width > requestedWidth) {
                int halfHeight = height / inSampleSize;
                int halfWidth = width / inSampleSize;
                while (halfHeight / inSampleSize > requestedHeight && halfWidth / inSampleSize > requestedWidth) {
                    inSampleSize *= 2;
                }
            }
            return inSampleSize;
        }
    }

    public static class Builder {
        private AnncaImageLoader anncaImageLoader;

        public Builder(@NonNull Context context) {
            this.anncaImageLoader = new AnncaImageLoader(context);
        }

        public Builder load(String url) {
            this.anncaImageLoader.url = url;
            return this;
        }

        public AnncaImageLoader build() {
            return this.anncaImageLoader;
        }
    }
}

