/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.view.TextureView;

@SuppressLint(value={"ViewConstructor"})
@TargetApi(value=21)
public class AutoFitTextureView
extends TextureView {
    private static final String TAG = "AutoFitTextureView";
    private int ratioWidth = 0;
    private int ratioHeight = 0;

    public AutoFitTextureView(Context context, TextureView.SurfaceTextureListener surfaceTextureListener) {
        super(context, null);
        this.setSurfaceTextureListener(surfaceTextureListener);
    }

    public void setAspectRatio(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        this.ratioWidth = width;
        this.ratioHeight = height;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AutoFitTextureView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = AutoFitTextureView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (0 == this.ratioWidth || 0 == this.ratioHeight) {
            this.setMeasuredDimension(width, height);
        } else if ((float)width < (float)height * ((float)this.ratioWidth / (float)this.ratioHeight)) {
            this.setMeasuredDimension(width, (int)((float)width * ((float)this.ratioWidth / (float)this.ratioHeight)));
        } else {
            this.setMeasuredDimension((int)((float)height * ((float)this.ratioWidth / (float)this.ratioHeight)), height);
        }
    }
}

