/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.os.Bundle;
import android.view.SurfaceHolder;
import android.view.View;
import io.github.memfis19.annca.internal.controller.impl.Camera1Controller;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.manager.impl.Camera1Manager;
import io.github.memfis19.annca.internal.ui.BaseCameraActivity;
import io.github.memfis19.annca.internal.ui.view.AutoFitSurfaceView;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import java.util.concurrent.TimeUnit;

public class Camera1Activity
extends BaseCameraActivity
implements CameraView {
    private AutoFitSurfaceView autoFitSurfaceView;
    private CharSequence[] videoQualities;
    private CharSequence[] photoQualities;
    private int cameraFace = 7;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.cameraController = new Camera1Controller(this, this);
        this.cameraController.onCreate(savedInstanceState);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraController.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraController.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cameraController.onDestroy();
    }

    @Override
    protected void onTakePhotoEvent() {
        this.cameraController.takePhoto();
    }

    @Override
    protected void onStartRecordingEvent() {
        this.cameraController.startVideoRecord();
    }

    @Override
    protected void onStopRecordingEvent() {
        this.cameraController.stopVideoRecord();
    }

    @Override
    protected void onMediaActionChangedEvent(int mediaActionState) {
    }

    @Override
    protected void onCameraTypeChangedEvent(int cameraType) {
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraFace = cameraType == 0 ? 6 : 7;
        this.cameraController.switchCamera(this.cameraFace);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public void updateCameraPreview(Object ... parameters) {
        this.controlPanel.unLockControls();
        this.controlPanel.allowRecord(true);
        Camera.Size previewSize = (Camera.Size)parameters[0];
        this.autoFitSurfaceView = new AutoFitSurfaceView((Context)this, (SurfaceHolder.Callback)parameters[1]);
        this.putPreviewToContainer((View)this.autoFitSurfaceView);
        this.previewContainer.setAspectRatio((double)previewSize.height / (double)previewSize.width);
    }

    @Override
    public void updateUiForMediaAction(int mediaAction) {
    }

    @Override
    public void updateCameraSwitcher(int numberOfCameras) {
        this.controlPanel.allowCameraSwitching(numberOfCameras > 1);
    }

    @Override
    public void onPhotoTaken() {
        this.startPreviewActivity();
    }

    @Override
    public void onVideoRecordStart(int width, int height) {
        this.controlPanel.onStartVideoRecord(this.cameraController.getOutputFile());
    }

    @Override
    public void onVideoRecordStop() {
        this.controlPanel.allowRecord(false);
        this.controlPanel.onStopVideoRecord();
        this.startPreviewActivity();
    }

    @Override
    public void releaseCameraPreview() {
        this.clearPreviewContainer();
    }

    @Override
    protected CharSequence[] getVideoQualityOptions() {
        this.videoQualities = new CharSequence[]{new VideoQualityOption(10, (Integer)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(13, (Integer)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(12, (Integer)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(11, (Integer)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration())};
        return this.videoQualities;
    }

    @Override
    protected CharSequence[] getPhotoQualityOptions() {
        this.photoQualities = new CharSequence[]{new PhotoQualityOption(14, Camera1Manager.getInstance().getPhotoSizeForQuality(14)), new PhotoQualityOption(13, Camera1Manager.getInstance().getPhotoSizeForQuality(13)), new PhotoQualityOption(12, Camera1Manager.getInstance().getPhotoSizeForQuality(12)), new PhotoQualityOption(15, Camera1Manager.getInstance().getPhotoSizeForQuality(15))};
        return this.photoQualities;
    }

    @Override
    protected int getVideoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 10) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 11) {
            checkedIndex = 3;
        }
        return checkedIndex;
    }

    @Override
    protected int getPhotoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 14) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 15) {
            checkedIndex = 3;
        }
        return checkedIndex;
    }

    @Override
    protected DialogInterface.OnClickListener getVideoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Camera1Activity.this.newQuality = ((VideoQualityOption)Camera1Activity.this.videoQualities[i]).getMediaQuality();
            }
        };
    }

    @Override
    protected DialogInterface.OnClickListener getPhotoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Camera1Activity.this.newQuality = ((PhotoQualityOption)Camera1Activity.this.photoQualities[i]).getMediaQuality();
            }
        };
    }

    private class VideoQualityOption
    implements CharSequence {
        private String title;
        private int mediaQuality;
        private CamcorderProfile camcorderProfile;
        private int videoDuration;

        public VideoQualityOption(int mediaQuality, int cameraId, long maxFileSize, int baseDuration) {
            this.mediaQuality = mediaQuality;
            long minutes = TimeUnit.SECONDS.toMinutes(baseDuration);
            long seconds = (long)baseDuration - minutes * 60L;
            if (mediaQuality == 10) {
                this.title = "Auto , (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)";
            } else {
                this.camcorderProfile = CameraHelper.getCamcorderProfile(mediaQuality, cameraId);
                this.videoDuration = (int)CameraHelper.calculateApproximateVideoDuration(this.camcorderProfile, maxFileSize);
                minutes = TimeUnit.SECONDS.toMinutes(this.videoDuration);
                seconds = (long)this.videoDuration - minutes * 60L;
                this.title = String.valueOf(this.camcorderProfile.videoFrameWidth) + " x " + String.valueOf(this.camcorderProfile.videoFrameHeight) + ", (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)";
            }
        }

        public int getMediaQuality() {
            return this.mediaQuality;
        }

        @Override
        public int length() {
            return this.title.length();
        }

        @Override
        public char charAt(int i) {
            return this.title.charAt(i);
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return this.title.subSequence(i, i1);
        }

        @Override
        public String toString() {
            return this.title;
        }
    }

    private class PhotoQualityOption
    implements CharSequence {
        private int mediaQuality;
        private String title;
        private Camera.Size size;

        public PhotoQualityOption(int mediaQuality, Camera.Size size) {
            this.mediaQuality = mediaQuality;
            this.size = size;
            this.title = String.valueOf(size.width) + " x " + String.valueOf(size.height);
        }

        public int getMediaQuality() {
            return this.mediaQuality;
        }

        @Override
        public int length() {
            return this.title.length();
        }

        @Override
        public char charAt(int i) {
            return this.title.charAt(i);
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return this.title.subSequence(i, i1);
        }

        @Override
        public String toString() {
            return this.title;
        }
    }
}

