/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresPermission;
import io.github.memfis19.annca.internal.configuration.AnncaConfiguration;
import io.github.memfis19.annca.internal.ui.camera.Camera1Activity;
import io.github.memfis19.annca.internal.ui.camera2.Camera2Activity;
import io.github.memfis19.annca.internal.utils.CameraHelper;

public class Annca {
    private AnncaConfiguration anncaConfiguration;

    public Annca(Activity activity, @IntRange(from=0L) int requestCode) {
        AnncaConfiguration.Builder builder = new AnncaConfiguration.Builder(activity, requestCode);
        this.anncaConfiguration = builder.build();
    }

    public Annca(AnncaConfiguration cameraConfiguration) {
        this.anncaConfiguration = cameraConfiguration;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void launchCamera() {
        if (this.anncaConfiguration == null || this.anncaConfiguration.getActivity() == null) {
            return;
        }
        Intent cameraIntent = CameraHelper.hasCamera2((Context)this.anncaConfiguration.getActivity()) ? new Intent((Context)this.anncaConfiguration.getActivity(), Camera2Activity.class) : new Intent((Context)this.anncaConfiguration.getActivity(), Camera1Activity.class);
        cameraIntent.putExtra("io.memfis19.annca.request_code", this.anncaConfiguration.getRequestCode());
        if (this.anncaConfiguration.getMediaAction() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.media_action", this.anncaConfiguration.getMediaAction());
        }
        if (this.anncaConfiguration.getMediaQuality() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.camera_media_quality", this.anncaConfiguration.getMediaQuality());
        }
        if (this.anncaConfiguration.getVideoDuration() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.video_duration", this.anncaConfiguration.getVideoDuration());
        }
        if (this.anncaConfiguration.getVideoFileSize() > 0L) {
            cameraIntent.putExtra("io.memfis19.annca.camera_video_file_size", this.anncaConfiguration.getVideoFileSize());
        }
        this.anncaConfiguration.getActivity().startActivityForResult(cameraIntent, this.anncaConfiguration.getRequestCode());
    }
}

