/*
 * Decompiled with CFR 0.152.
 */
package io.github.maritims;

import io.github.maritims.node.NodeConfiguration;
import io.github.maritims.node.NodeWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmWrapper
extends NodeWrapper {
    private static final Logger log = LoggerFactory.getLogger(NpmWrapper.class);

    public NpmWrapper(NodeConfiguration nodeConfiguration, String projectSourceCodeDirectory) {
        super(nodeConfiguration, projectSourceCodeDirectory);
    }

    private Path getNpmCliJs() {
        return this.getNodePaths().getNodeModule("npm").resolve(Paths.get("bin", "npm-cli.js"));
    }

    protected int doSystemCall(ProcessBuilder pb) {
        try {
            return pb.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            log.error("Unable to execute system call", (Throwable)e);
            return -1;
        }
    }

    public boolean install() {
        return this.doSystemCall(new ProcessBuilder(this.getNpmCliJs().toAbsolutePath().toString(), "install").directory(new File(this.projectSourceCodeDirectory)).inheritIO()) == 0;
    }

    public boolean runScript(String script) {
        if (!this.getPackageJson().getScripts().containsKey(script)) {
            log.error(script + " is not a valid script in package.json");
            return false;
        }
        return this.doSystemCall(new ProcessBuilder(this.getNpmCliJs().toAbsolutePath().toString(), "run", script).directory(new File(this.projectSourceCodeDirectory)).inheritIO()) == 0;
    }

    @Override
    public boolean run(String script) {
        this.download();
        this.extract();
        return "install".equalsIgnoreCase(script) ? this.install() : this.runScript(script);
    }
}

