/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.security.commons.oauth.token.api;

import io.github.marceltanuri.security.commons.oauth.token.api.TokenService;

public class DefaultClientCredentialsSettings
implements TokenService.ClientCredentialsSettings {
    private final String _audience;
    private final String _clientId;
    private final String _clientSecret;
    private final String _scope;
    private final String _tokenEndpoint;

    @Override
    public String audience() {
        return this._audience;
    }

    @Override
    public String clientId() {
        return this._clientId;
    }

    @Override
    public String clientSecret() {
        return this._clientSecret;
    }

    @Override
    public String scope() {
        return this._scope;
    }

    @Override
    public String tokenEndpoint() {
        return this._tokenEndpoint;
    }

    public String toString() {
        return "DefaultClientCredentialsSettings{clientId='" + this._clientId + "', clientSecret='[PROTECTED]', tokenEndpoint='" + this._tokenEndpoint + "', scope='" + this._scope + "', audience='" + this._audience + "'}";
    }

    private DefaultClientCredentialsSettings(Builder builder) {
        this._clientId = builder._clientId;
        this._clientSecret = builder._clientSecret;
        this._tokenEndpoint = builder._tokenEndpoint;
        this._scope = builder._scope;
        this._audience = builder._audience;
    }

    public static class Builder {
        private String _audience;
        private String _clientId;
        private String _clientSecret;
        private String _scope;
        private String _tokenEndpoint;

        public Builder audience(String audience) {
            this._audience = audience;
            return this;
        }

        public DefaultClientCredentialsSettings build() {
            return new DefaultClientCredentialsSettings(this);
        }

        public Builder clientId(String clientId) {
            this._clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this._clientSecret = clientSecret;
            return this;
        }

        public Builder scope(String scope) {
            this._scope = scope;
            return this;
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            this._tokenEndpoint = tokenEndpoint;
            return this;
        }
    }
}

