/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.commons.oauthclient.internal;

import io.github.marceltanuri.commons.oauthclient.api.OAuth2ClientSettings;
import java.lang.annotation.Annotation;

public class OAuth2ClientSettingsProxy
implements OAuth2ClientSettings {
    private static final String ENV_VAR_PREFIX = OAuth2ClientSettingsProxy.normalizeForEnvVar(OAuth2ClientSettings.class.getPackage().getName());
    private final OAuth2ClientSettings _settings;

    public OAuth2ClientSettingsProxy(OAuth2ClientSettings settings) {
        this._settings = settings;
    }

    @Override
    public String clientName() {
        return this._settings.clientName();
    }

    @Override
    public String tokenEndpoint() {
        return this._settings.tokenEndpoint();
    }

    @Override
    public String clientId() {
        String clientName = this._settings.clientName();
        String normalizedClientName = OAuth2ClientSettingsProxy.normalizeForEnvVar(clientName);
        String envVarName = ENV_VAR_PREFIX + "_" + normalizedClientName + "_CLIENT_ID";
        String envValue = System.getenv(envVarName);
        if (envValue != null) {
            return envValue;
        }
        return this._settings.clientId();
    }

    @Override
    public String clientSecret() {
        String clientName = this._settings.clientName();
        String normalizedClientName = OAuth2ClientSettingsProxy.normalizeForEnvVar(clientName);
        String envVarName = ENV_VAR_PREFIX + "_" + normalizedClientName + "_CLIENT_SECRET";
        String envValue = System.getenv(envVarName);
        if (envValue != null) {
            return envValue;
        }
        return this._settings.clientSecret();
    }

    @Override
    public String audience() {
        return this._settings.audience();
    }

    @Override
    public String scope() {
        return this._settings.scope();
    }

    @Override
    public int cacheMaxEntries() {
        return this._settings.cacheMaxEntries();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this._settings.annotationType();
    }

    private static String normalizeForEnvVar(String name) {
        if (name == null) {
            return "";
        }
        return name.toUpperCase().replaceAll("[^A-Z0-9_]+", "_");
    }
}

